package com.jshx.extend.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.jshx.core.base.entity.BaseModel;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.extend.IDeptExtendInfo;
/**
 * 部门扩展信息测试
 * 
 * @author Chenjian
 *
 */
@Entity
@Table(name = "DEPT_EXTEND")
public class DeptExtend extends BaseModel implements IDeptExtendInfo {

	private static final long serialVersionUID = -6996211441016138903L;
	
	private Department dept;
	
	private String deptId;
	
	private String info;

	@Override
	public void setDept(Department dept) {
		this.dept = dept;
	}

	@Override
	public void setDeptId(String deptId) {
		this.deptId = deptId;
	}

	@Column(name = "INFO", length = 30)
	public String getInfo() {
		return info;
	}

	public void setInfo(String info) {
		this.info = info;
	}

	@ManyToOne(targetEntity = Department.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "DEPT_ID", insertable = false, updatable = false)
	public Department getDept() {
		return dept;
	}

	@Column(name = "DEPT_ID", length = 40)
	public String getDeptId() {
		return deptId;
	}

}
