package com.jshx.leavedemo.entity;

import com.jshx.core.base.entity.BaseModel;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Map;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 *
 * @author
 */
@SuppressWarnings("serial")
@Entity
@Table(name = "LEAVE_DEMO")
public class LeaveDemo extends BaseModel {
    /**
     * 部门代码
     */
    private String deptId;

    /**
     * 删除标记
     */
    private Integer delFlag;


    /**
     * 请假事由
     */
    private String reason;

    /**
     * 请假天数
     */
    private Integer numDays;

    /**
     * 申请人
     */
    private String applyUser;


    //-- 临时属性 --//
    // 流程任务
    private Task task;

    private Map<String, Object> variables;

    // 运行中的流程实例
    private ProcessInstance processInstance;

    // 历史的流程实例
    private HistoricProcessInstance historicProcessInstance;

    // 流程定义
    private ProcessDefinition processDefinition;


    public LeaveDemo() {
    }

    public LeaveDemo(String id, String reason, Integer numDays) {
        this.id = id;
        this.reason = reason;
        this.numDays = numDays;
    }


    @Column
    public String getDeptId() {
        return deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    @Column
    public Integer getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }


    @Column(name = "REASON")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Column(name = "NUM_DAYS")
    public Integer getNumDays() {
        return this.numDays;
    }

    public void setNumDays(Integer numDays) {
        this.numDays = numDays;
    }

    @Column(name = "APPLY_USER")
    public String getApplyUser() {
        return this.applyUser;
    }

    public void setApplyUser(String applyUser) {
        this.applyUser = applyUser;
    }

    @Transient
    public Map<String, Object> getVariables() {
        return variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    @Transient
    public ProcessInstance getProcessInstance() {
        return processInstance;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    @Transient
    public HistoricProcessInstance getHistoricProcessInstance() {
        return historicProcessInstance;
    }

    public void setHistoricProcessInstance(HistoricProcessInstance historicProcessInstance) {
        this.historicProcessInstance = historicProcessInstance;
    }

    @Transient
    public ProcessDefinition getProcessDefinition() {
        return processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

}
