package com.jshx.activiti.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.activiti.dao.ActivitiOperLogDao;
import com.jshx.activiti.entity.ActivitiOperLog;
import com.jshx.activiti.service.ActivitiOperLogService;

@Service("activitiOperLogService")
public class ActivitiOperLogServiceImpl extends BaseServiceImpl implements ActivitiOperLogService {
    /**
     * Dao类
     */
    @Autowired()
    @Qualifier("activitiOperLogDao")
    private ActivitiOperLogDao activitiOperLogDao;

    /**
     * 分页查询
     *
     * @param page    分页信息
     * @param paraMap 查询条件信息
     * @return 分页信息
     */
    public Pagination findByPage(Pagination page, Map<String, Object> paraMap) {
        return activitiOperLogDao.findByPage(page, paraMap);
    }

    /**
     * 根据主键ID查询信息
     *
     * @param id 主键ID
     * @return 主键ID对应的信息
     */
    public ActivitiOperLog getById(String id) {
        return activitiOperLogDao.getById(id);
    }

    /**
     * 保存信息
     *
     * @param activitiOperLog 信息
     */
    @Transactional
    public void save(ActivitiOperLog activitiOperLog) {
        activitiOperLogDao.save(activitiOperLog);
    }

    /**
     * 修改信息
     *
     * @param activitiOperLog 信息
     */
    @Transactional
    public void update(ActivitiOperLog activitiOperLog) {
        activitiOperLogDao.update(activitiOperLog);
    }

    /**
     * 物理删除信息
     *
     * @param ids 主键ID列表
     */
    @Transactional
    public void delete(String[] ids) {
        List list = Arrays.asList(ids);

        Map<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("ids", list);
        List objects = activitiOperLogDao.findActivitiOperLog(paraMap);

        activitiOperLogDao.removeAll(objects);
    }

    /**
     * 逻辑删除信息
     *
     * @param ids 主键ID列表
     */
    @Transactional
    public void deleteWithFlag(String ids) {
        String[] idArray = ids.split("\\|");
        if (null != idArray) {
            for (String id : idArray) {
                if (id != null && !id.trim().equals(""))
                    activitiOperLogDao.deleteWithFlag(id);
            }
        }
    }

    @Transactional
    public void saveLog(String operUser, String operType, String taskId, String taskName, String processInstanceId, String remark) {
        ActivitiOperLog activitiOperLog = new ActivitiOperLog();

        activitiOperLog.setOperuser(operUser);
        activitiOperLog.setOpertype(operType);
        activitiOperLog.setTaskid(taskId);
        activitiOperLog.setTaskname(taskName);
        activitiOperLog.setProcessinstanceid(processInstanceId);
        activitiOperLog.setRemark(remark);
        activitiOperLog.setDelFlag(0);

        activitiOperLogDao.save(activitiOperLog);
    }
}
