

/*
 * Freeflow Properties
 */

var KisBpmFreeflowPropertiesCtrl = [ '$scope', '$modal', '$timeout', '$translate', function($scope, $modal) {

    // Config for the modal window
    var opts = {
        template:  'editor-app/configuration/properties/freeflow-popup.html?version=' + Date.now(),
        scope: $scope
    };

    // Open the dialog
    $modal(opts);
}];

var KisBpmFreeflowPropertiesPopupCtrl = ['$scope', '$modal', '$rootScope', '$q', '$translate', '$timeout', function($scope, $modal, $rootScope, $q, $translate, $timeout) {
	
	//获取当前模型中Task任务节点名
	var selectShapName = $scope.selectedShape.properties['oryx-name'];
	$scope.taskList = [];
    var length = $rootScope.modelData.model.childShapes.length;
    for(var i = 0; i < length; i++){
        var shape = $rootScope.modelData.model.childShapes[i];
        var id = shape.stencil.id;
        if(id.indexOf("Task")!==-1 && shape.properties.name !== selectShapName){
            $scope.taskList.push(shape.properties.name + "(" + shape.properties.overrideid + ")");
        }
    }
    
    // Put json representing form properties on scope
    if ($scope.property.value !== undefined && $scope.property.value !== null
        && $scope.property.value.freeflowProperties !== undefined
        && $scope.property.value.freeflowProperties !== null) {
        // Note that we clone the json object rather then setting it directly,
        // this to cope with the fact that the user can click the cancel button and no changes should have happended
        $scope.freeflowProperties = angular.copy($scope.property.value.freeflowProperties);        
    } else {
        $scope.freeflowProperties = [];
    }

    // Click handler for - button after enum value
    $scope.removeCandidateGroupValue = function() {
        $scope.selectedProperties[0].group = "";
        jQuery("#userField").val("");
    };
    
	$scope.searchGroup = function(target){
		$scope.currTarget = target;
		var opts = {
			template:  'editor-app/configuration/properties/freeflow-group-popup.html?version=' + Date.now(),
			scope: $scope,
			//container: "#assignmentPopup"
		};
		// Open the dialog
		$scope.groupModal = $modal(opts);
	}

    // Array to contain selected properties (yes - we only can select one, but ng-grid isn't smart enough)
    $scope.selectedProperties = [];
    $scope.selectedEnumValues = [];
    
    $scope.translationsRetrieved = false;
    
    $scope.labels = {};
    
    var idPromise = $translate('PROPERTY.FREEFLOW.ID');
    var nodePromise = $translate('PROPERTY.FREEFLOW.NODE');
    var groupPromise = $translate('PROPERTY.FREEFLOW.GROUP');
    var compensation = $translate('PROPERTY.FREEFLOW.COMPENSATION');

    $q.all([idPromise, nodePromise, groupPromise, compensation]).then(function(results) {
    	$scope.labels.idLabel = results[0];
        $scope.labels.nodeLabel = results[1];
        $scope.labels.groupLabel = results[2];
        $scope.labels.compensationLabel = results[3];
        $scope.translationsRetrieved = true;

    	// Config for grid
        $scope.gridOptions = {
            data: 'freeflowProperties',
            enableRowReordering: true,
            headerRowHeight: 28,
            multiSelect: false,
            keepLastSelected : false,
            selectedItems: $scope.selectedProperties,
            columnDefs: [{ field: 'id', displayName: $scope.labels.idLabel },
                { field: 'node', displayName: $scope.labels.nodeLabel},
                { field: 'group', displayName: $scope.labels.groupLabel},
                { field: 'compensation', displayName: $scope.labels.compensationLabel}]
        };
    });

    // Click handler for add button
    var propertyIndex = 1;
    $scope.addNewProperty = function() {
        $scope.freeflowProperties.push({ id : 'freeflow_' + propertyIndex++,
        	node : '',
        	group : ''});
        
        $timeout(function(){
        	$scope.gridOptions.selectItem($scope.freeflowProperties.length - 1, true);
        });
    };

    // Click handler for remove button
    $scope.removeProperty = function() {
        if ($scope.selectedProperties.length > 0) {
            var index = $scope.freeflowProperties.indexOf($scope.selectedProperties[0]);
            $scope.gridOptions.selectItem(index, false);
            $scope.freeflowProperties.splice(index, 1);

            $scope.selectedProperties.length = 0;
            if (index < $scope.freeflowProperties.length) {
                $scope.gridOptions.selectItem(index + 1, true);
            } else if ($scope.freeflowProperties.length > 0) {
                $scope.gridOptions.selectItem(index - 1, true);
            }
        }
    };

    // Click handler for save button
    $scope.save = function() {

        if ($scope.freeflowProperties.length > 0) {
            $scope.property.value = {};
            $scope.property.value.freeflowProperties = $scope.freeflowProperties;
        } else {
            $scope.property.value = null;
        }

        $scope.updatePropertyInModel($scope.property);
        $scope.close();
    };

    $scope.cancel = function() {
    	$scope.$hide();
    	$scope.property.mode = 'read';
    };

    // Close button handler
    $scope.close = function() {
        $scope.$hide();
    	$scope.property.mode = 'read';
        jQuery("script[type='text/ng-template']").remove();
    };

}];