/*
 * Delay Properties
 */

var KisBpmDelayPropertiesCtrl = [ '$scope', '$modal', function($scope, $modal) {

    // Config for the modal window
    var opts = {
    	backdrop: 'static',  
        template:  'editor-app/configuration/properties/delay-properties-popup.html?version=' + Date.now(),
        scope: $scope
    };

    // Open the dialog
    $modal(opts);
}];

var KisBpmDelayPropertiesPopupCtrl = ['$scope', '$q', '$translate', '$timeout', function($scope, $q, $translate, $timeout) {

    // Put json representing form properties on scope
    if ($scope.property.value !== undefined && $scope.property.value !== null
        && $scope.property.value.delayProperties !== undefined
        && $scope.property.value.delayProperties !== null) {
        // Note that we clone the json object rather then setting it directly,
        // this to cope with the fact that the user can click the cancel button and no changes should have happended
        $scope.delayProperties = angular.copy($scope.property.value.delayProperties);                
    } else {
        $scope.delayProperties = [];
    }

    // Array to contain selected properties (yes - we only can select one, but ng-grid isn't smart enough)
    $scope.selectedProperties = [];
    
    $scope.translationsRetrieved = false;
    
    $scope.labels = {};
    
    var delaytypePromise = $translate('PROPERTY.DELAY.DELAYTYPE');
    var timePromise = $translate('PROPERTY.DELAY.TIME');
    var cyclePromise = $translate('PROPERTY.DELAY.CYCLE');
    var impclassPromise = $translate('PROPERTY.DELAY.IMP_CLASS');
    
    $q.all([delaytypePromise, timePromise, cyclePromise, impclassPromise]).then(function(results) { 
    	$scope.labels.delaytypeLabel = results[0];
    	$scope.labels.timeLabel = results[1];
        $scope.labels.cycleLabel = results[2];
        $scope.labels.impclassLabel = results[3];
        $scope.translationsRetrieved = true;
        
    	// Config for grid
        $scope.gridOptions = {
            data: 'delayProperties',
            enableRowReordering: true,
            headerRowHeight: 28,
            multiSelect: false,
            keepLastSelected : false,
            selectedItems: $scope.selectedProperties,
            columnDefs: [{ field: 'delayType', displayName: $scope.labels.delaytypeLabel },
                         { field: 'time', displayName: $scope.labels.timeLabel },
                         { field: 'cycle', displayName: $scope.labels.cycleLabel},
                         { field: 'impclass', displayName: $scope.labels.impclassLabel}]
        };
    });

    // Click handler for add button
    $scope.addNewProperty = function() {
        $scope.delayProperties.push({ delayTime:'',
        	time : '',
            cycle : '',
            impclass:''});
        
        $timeout(function(){
        	$scope.gridOptions.selectItem($scope.delayProperties.length - 1, true);
        });
    };

    // Click handler for remove button
    $scope.removeProperty = function() {
        if ($scope.selectedProperties.length > 0) {
            var index = $scope.delayProperties.indexOf($scope.selectedProperties[0]);
            $scope.gridOptions.selectItem(index, false);
            $scope.delayProperties.splice(index, 1);

            $scope.selectedProperties.length = 0;
            if (index < $scope.delayProperties.length) {
                $scope.gridOptions.selectItem(index + 1, true);
            } else if ($scope.delayProperties.length > 0) {
                $scope.gridOptions.selectItem(index - 1, true);
            }
        }
    };

    // Click handler for save button
    $scope.save = function() {

        if ($scope.delayProperties.length > 0) {
            $scope.property.value = {};
            $scope.property.value.delayProperties = $scope.delayProperties;
        } else {
            $scope.property.value = null;
        }

        $scope.updatePropertyInModel($scope.property);
        $scope.close();
    };

    $scope.cancel = function() {
    	$scope.$hide();
    	$scope.property.mode = 'read';
    };

    // Close button handler
    $scope.close = function() {
    	$scope.$hide();
    	$scope.property.mode = 'read';
    };

}];