<%@page language="java" pageEncoding="UTF-8"%>
<%@include file="/common/header.jsp"%>
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>信息内容管理</title>
		<%@include file="/common/jsLib.jsp"%>
		<script>
        function addNew(){
        	createSimpleWindow("infoWindow","添加信息内容","${ctx}/jsp/information/contentInformationsInitEdit.action?flag=add", 1050, 350);
        }
        function edit(row_Id){
        	createSimpleWindow("infoWindow","修改信息内容","${ctx}/jsp/information/contentInformationsInitEdit.action?flag=mod&contentInformations.id="+row_Id, 1050, 550);
        }
        function view(row_Id){
        	createSimpleWindow("infoWindow","查看信息内容","${ctx}/jsp/information/contentInformationsView.action?contentInformations.id="+row_Id, 1050, 550);
        }
        function inactive_info(id){
        	$.messager.confirm('禁用信息', '确定要禁用该信息？', function(result){
				if (result){
	                $.ajax({
	                	url : "inactiveInfo.action",
	                	type: 'post',
	                    dataType: 'json',
	                    async : false,
	                    data:{ 
	                    	"contentInformations.id" : id
	                    },
	                    error: function(){
	                    	$.messager.alert('错误','禁用信息时出错！');
	                    },
	                    success: function(data){
	                        if(data.result){
	                        	$.messager.alert('提示','禁用信息成功！');
	                        	search_contentInformations();
	                        }else{
	                        	$.messager.alert('错误','禁用信息时出错！');
	                        }
	                    }
	                });					
				}
			});
        }
        function active_info(id){
        	$.messager.confirm('激活信息', '确定要激活该信息？', function(result){
				if (result){
	                $.ajax({
	                	url : "activeInfo.action",
	                	type: 'post',
	                    dataType: 'json',
	                    async : false,
	                    data:{ 
	                    	"contentInformations.id" : id
	                    },
	                    error: function(){
	                    	$.messager.alert('错误','激活信息时出错！');
	                    },
	                    success: function(data){
	                        if(data.result){
	                        	$.messager.alert('提示','激活信息成功！');
	                        	search_contentInformations();
	                        }else{
	                        	$.messager.alert('错误','激活信息时出错！');
	                        }
	                    }
	                });					
				}
			});
        }
        function expire_info(id){
        	$.messager.confirm('设置信息过期', '确定要设置该信息过期？', function(result){
				if (result){
	                $.ajax({
	                	url : "expireInfo.action",
	                	type: 'post',
	                    dataType: 'json',
	                    async : false,
	                    data:{ 
	                    	"contentInformations.id" : id
	                    },
	                    error: function(){
	                    	$.messager.alert('错误','设置信息过期时出错！');
	                    },
	                    success: function(data){
	                        if(data.result){
	                        	$.messager.alert('提示','设置信息过期成功！');
	                        	search_contentInformations();
	                        }else{
	                        	$.messager.alert('错误','设置信息过期时出错！');
	                        }
	                    }
	                });					
				}
			});
        }
        function inexpire_info(id){
        	$.messager.confirm('设置信息使用', '确定要设置该信息使用？', function(result){
				if (result){
	                $.ajax({
	                	url : "inexpireInfo.action",
	                	type: 'post',
	                    dataType: 'json',
	                    async : false,
	                    data:{ 
	                    	"contentInformations.id" : id
	                    },
	                    error: function(){
	                    	$.messager.alert('错误','设置信息使用时出错！');
	                    },
	                    success: function(data){
	                        if(data.result){
	                        	$.messager.alert('提示','设置信息使用成功！');
	                        	search_contentInformations();
	                        }else{
	                        	$.messager.alert('错误','设置信息使用时出错！');
	                        }
	                    }
	                });					
				}
			});
        }
        function search_contentInformations(){
        	var queryParams = {
					"contentInformations.infoTitle": $("#infoTitle").val(),
					"contentInformations.infoType": $("#infoType").val(),
					"isDelshow":$("#isDelshow").val(),
					"isExpireshow":$("#isExpireshow").val(),
					"contentInformations.topFlag": $("#topFlag").val(),
					"username": $("#username").val(),
					"queryPublicDateStart" :$("#queryPublicDateStart").val(),
					"queryPublicDateEnd" :$("#queryPublicDateEnd").val()
			};        	
        	$('#pagination').datagrid('options').queryParams = queryParams;
        	$('#pagination').datagrid('clearSelections');
        	$("#pagination").datagrid('load'); 
        }
        $(function(){
			$('#pagination').datagrid($.extend(window.dg_cm_pp,{
				title:'信息内容列表',
				url:'contentInformationsQuery.action',
				toolbar:[{
					text:'新建',
					iconCls:'icon-add',
					handler:addNew
				}],
				columns:[[
				    {field:'infoTitle',title:'标题',width:fixWidth(0.1),formatter:function(value,rec){
			             if(rec.infoTitle.length>20){
			                var temp=rec.infoTitle.substr(0,20)+'...';
			             	return "<span title="+rec.infoTitle+">"+temp+"</span>";
			             }	
			             else{
			                var temp1=rec.infoTitle;
			              	return "<span title="+rec.infoTitle+">"+temp1+"</span>";
			             }  
				    }},
					{field:'infoType',title:'信息类型',width:fixWidth(0.1),formatter:function(value,rec){
					 	var temp = '';
					    $.ajax({
						    url: '${ctx}/jsp/admin/code/findCodeValue.action',
						    type: 'post',
						    dataType: 'json',
						    async : false,
						    data:{ 
						    	"codeValue.itemValue" : rec.infoType,
								"codeValue.codeId" : "0464f1a63362fccd013362fe3a390004"
						    },
						    error: function(){
						        $.messager.alert('提示','获取一维代码错误！');
						    },
						    success: function(data){
						        temp = data.itemText;
						 	}
						});
					    return temp;
					}},
					{field:'topFlag',title:'是否置顶',width:fixWidth(0.1),formatter:function(value,rec){
						if(rec.topFlag=='1')
							return "置顶";
						else 
							return "非置顶";
					}},
					{field:'expireFlag',title:'是否过期',width:fixWidth(0.1),formatter:function(value,rec){
						if(rec.expireFlag=='1')
							return "已过期";
						else 
							return "未过期";
					}},
					{field:'userId',title:'发布人',width:fixWidth(0.1),formatter:function(value,rec){
						return rec.user.displayName;
					}},
					{field:'deptId',title:'所属部门',width:fixWidth(0.1),formatter:function(value,rec){
						return rec.dept.deptName;
					}},
					{field:'publicDate',title:'发布日期',width:fixWidth(0.2),formatter:function(value,rec){
						if(rec.publicDate==null) return;
						var date = new Date(rec.publicDate.time);
						var retStr = date.format("yyyy-MM-dd hh:mm:ss");
						return retStr;						
					}},
		            {field:'op',title:'操作',width:fixWidth(0.2),formatter:function(value,rec){
		            
                        var restr="<a href='#' onclick=\"view('"+rec.id+"')\" class='btn_01_mini'>查看<b></b></a><a href='#' onclick=\"edit('"+rec.id+"')\" class='btn_01_mini'>修改<b></b></a>";
                        if(rec.delFlag=='0')
                        	restr+="<a href='#' onclick=\"inactive_info('"+rec.id+"')\" class='btn_01_mini'>禁用<b></b></a>";
                        else
                        	restr+="<a href='#' onclick=\"active_info('"+rec.id+"')\" class='btn_01_mini'>激活<b></b></a>";
                        if(rec.expireFlag=='0')
                        	restr+="<a href='#' onclick=\"expire_info('"+rec.id+"')\" class='btn_01_mini'>设置过期<b></b></a>";
                        else
                        	restr+="<a href='#' onclick=\"inexpire_info('"+rec.id+"')\" class='btn_01_mini'>设置使用<b></b></a>";
                        return restr;
                    }}
				]]
				
			}));
		});
    </script>
	</head>

	<body>
		<div class="page_content">
			<div class="box_01 submitdata">
				<div class="inner12px">
					<form name="myform" method="post">
						<div class="cell boxBmargin12">
							<table>
								<tbody>
									<tr>
										<th width="15%">
											标题
										</th>
										<td width="35%">
											<input name="contentInformations.infoTitle" id="infoTitle"
												class="form_text" value="${contentInformations.infoTitle}"
												type="text">
										</td>
										<th width="15%">
											信息类型
										</th>
										<td width="35%">
											<cus:SelectOneTag property="contentInformations.infoType"
												defaultText='请选择' codeName="信息类型"
												value="${contentInformations.infoType}"
												style="width: 136px;" />
										</td>
									</tr>
									<tr>
										<th width="15%">
											是否显示禁用信息
										</th>
										<td width="35%">
											<select id="isDelshow" onchange="" name="isDelshow"
												style="width: 136px;">
												<option value="0"
													<c:if test="${isDelshow==0}">selected</c:if>>
													否
												</option>
												<option value="1"
													<c:if test="${isDelshow==1}">selected</c:if>>
													是
												</option>
											</select>
										</td>
										<th width="15%">
											是否显示过期信息
										</th>
										<td width="35%">
											<select id="isExpireshow" onchange="" name="isExpireshow"
												style="width: 136px;">
												<option value="0"
													<c:if test="${isExpireshow==0}">selected</c:if>>
													否
												</option>
												<option value="1"
													<c:if test="${isExpireshow==1}">selected</c:if>>
													是
												</option>
											</select>
										</td>
									<tr>
										<th width="15%">
											发布人
										</th>
										<td width="35%">
											<input name="username" id="username" value="${username}"
												class="form_text" type="text">
										</td>
										<th width="15%">
											发布日期
										</th>
										<td width="35%">
											<input name="queryPublicDateStart" id="queryPublicDateStart"
												value="<fmt:formatDate type='both' value='${queryPublicDateStart}' />"
												type="text" class="Wdate"
												onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',maxDate:'#F{$dp.$D(\'queryPublicDateEnd\')}'})">
											-
											<input name="queryPublicDateEnd" id="queryPublicDateEnd"
												value="<fmt:formatDate type='both' value='${queryPublicDateEnd}' />"
												type="text" class="Wdate"
												onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',minDate:'#F{$dp.$D(\'queryPublicDateStart\')}'})">
										</td>
									</tr>
									<tr>
										<td colspan="4">
											<div class="btn_area_setc">
												<a href="###" class="btn_01"
													onclick="search_contentInformations()">查询<b></b> </a>
												<a href="###" class="btn_01"
													onclick="clear_form(document.myform);">清空<b></b> </a>
											</div>
										</td>
									</tr>
								</tbody>
							</table>
						</div>
						<div id="pagination">
						</div>
					</form>
				</div>
				
			</div>
		</div>
		</div>
	</body>
</html>
