<%@page language="java" pageEncoding="UTF-8" %>
<%@include file="/common/header.jsp" %>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>我的流程</title>
    <%@include file="/common/jsLib.jsp" %>
    <script type="text/javascript">
        var freeFlowData = null;

        $(function () {
            $('#deptTree').tree({
                url: 'findChildDept.action',
                onBeforeExpand: function (node) {
                    $('#deptTree').tree('options').url = "findChildDept.action?selDept=" + node.id;
                },
                onClick: function (node) {
                    if (node.attributes == "last") { //判断是否为叶节点
                        $('#inputStr').val(node.text);
                        $('#inputUserId').val(node.id);
                        $('#inputPhoneNum').val(node.phoneNum);
                    }
                    else {
                        $(this).tree(node.state == 'closed' ? 'expand' : 'collapse', node.target);
                    }
                },
                onDblClick: function (node) {
                    $(this).tree(node.state == 'closed' ? 'expand' : 'collapse', node.target);
                }

            });
        });

        function reloadDate() {
            doQuery();
        }
        function close_win() {
            $("#newWindow").window("close");
        }
        function doTerminate(id) {
            $.messager.confirm('终止流程', '确定要终止流程？', function (result) {
                if (result) {
                    $.ajax({
                        url: "terminateProcessInstance.action",
                        type: 'post',
                        dataType: 'json',
                        async: false,
                        data: {
                            "processInstanceId": id
                        },
                        error: function () {
                            $.messager.alert('错误', '终止流程出错！');
                        },
                        success: function (data) {
                            if (data.result) {
                                $.messager.alert('提示', '已终止！', 'info', function () {
                                    doQuery();
                                });
                            } else {
                                $.messager.alert('错误', '终止流程时出错！');
                            }
                        }
                    });
                }
            });
        }
        function doQuery() {
            var queryParams = {
            	"processInstanceId" : $("#processInstanceId").val(),
                "startDate" :$("#startDate").val(),
                "endDate" :$("#endDate").val()
            };
            $('#pagination').datagrid('options').queryParams = queryParams;
            $('#pagination').datagrid('clearSelections');
            $("#pagination").datagrid('load');
        }

        function reAssignment(processInstanceId) {

            $.ajax({
                url: "${ctx}/jsp/activiti/getProcessInfo.action",
                data: {
                    fprocessInstanceId: processInstanceId
                },
                dataType: "json",
                type: "post",
                success: function (data) {
                    if (data.result) {
                        freeFlowData = data;
                        var tableDom = $('#showTask');
                        var html = '';
                        html += '<img id="graph" src="showDiagram.action?processDefinitionId=' + data.procDefId + '" style="position:absolute; left:0px; top:0px;">';
                        for (var i = 0; i < data.total; i++) {
                            html += '<div style="position:absolute; border:2.5px solid red; border-radius:8px; left:' + (data.rows[i].x - 1) + 'px;top:' + (data.rows[i].y - 1) + 'px;width:' + data.rows[i].width + 'px;height:' + data.rows[i].height + 'px;"></div>';
                            html += '<div style="position:absolute; color:blue;left:' + (data.rows[i].x + 3) + 'px;top:' + (data.rows[i].y + 1) + 'px;">' + data.rows[i].assignee + '</div>';
                        }
                        html += '<div id="getTask"></div>';
                        tableDom.html(html);
                        $("#showMapWindow").window("open");

                    }
                    else {
                        $.messager.alert("错误", "获取出错");
                    }
                },
                error: function () {
                    $.messager.alert("错误", "获取出错");
                }
            });

        }

        function getCoordinate(ev) {

            var imgX = $('#graph').offset().left;//图片相对窗口的X轴偏移
            var imgY = $('#graph').offset().top; //图片相对窗口的Y轴偏移

            var oEvent = ev || event;
            var oLeft = oEvent.clientX - imgX;//鼠标单击位置相对图片的X轴偏移
            var oTop = oEvent.clientY - imgY;

            if (freeFlowData != null) {
                var TaskDom = $('#getTask');
                for (var i = 0; i <= freeFlowData.total; i++) {
                    var html = '';
                    var x = freeFlowData.rows[i].x;
                    var y = freeFlowData.rows[i].y;
                    var width = freeFlowData.rows[i].width;
                    var height = freeFlowData.rows[i].height;

                    if (oLeft > x && oTop > y && oLeft < (x + width) && oTop < (y + height)) {
                        html += '<div style="position:absolute; border:2.5px solid blue; border-radius:8px; left:' + (x - 1) + 'px;top:' + (y - 1) + 'px;width:' + width + 'px;height:' + height + 'px;"></div>';
                        TaskDom.html(html);
                        chooseAgent(freeFlowData.rows[i].id, freeFlowData.rows[i].assignee);
                        break;
                    }
                }

            }
        }

        function chooseAgent(taskId, assignee) {
            window.currTaskId = taskId;
            window.assignee = assignee;

            $("#delegateWindow").window("open");
            document.getElementById("inputStr").value = "";
            document.getElementById("inputUserId").value = "";
            document.getElementById("inputPhoneNum").value = "";
        }

        function delegateTask() {
            var loginId = $("#inputUserId").val();

            if (loginId == "") {
                $.messager.alert("提示", "请选择代办人");
                return false;
            }

            if (loginId == window.assignee) {
                $.messager.alert("提示", "代办人不能是现有处理人");
                return false;
            }

            $.ajax({
                url: "${ctx}/jsp/activiti/delegateTask.action",
                data: {
                    taskId: window.currTaskId,
                    userId: loginId
                },
                dataType: "json",
                type: "post",
                success: function (data) {
                    if (data.result) {
                        $.messager.alert("成功", "改派成功");
                        document.getElementById("inputStr").value = "";
                        document.getElementById("inputUserId").value = "";
                        document.getElementById("inputPhoneNum").value = "";
                        $("#delegateWindow").window("close");
                        $("#showMapWindow").window("close");
                        doQuery();
                    }
                    else {
                        $.messager.alert("错误", "改派出错");
                    }
                },
                error: function () {
                    $.messager.alert("错误", "改派出错");
                }
            });
        }
        
        function view(row_Id){
        	var dt=new Date();
            createSimpleWindow("win_xmxxb","查看项目信息表","${ctx}/jsp/xmxxb/xmxxbView.action?xmxxb.id="+row_Id+"&dt="+dt.getTime(),800,500);
        	
        }

        $(function () {
            $('#pagination').datagrid($.extend(dg_cm_pp, {
                title: '我的流程',
                url: 'findRunningProcessInstances.action',
                /*frozenColumns:[[
                 {field:'id',checkbox:true}
                 ]],	*/
                columns: [[
                    {field: 'id', title: '编号', width: fixWidth(0.08)},
                    {field: 'name', title: '流程名称', width: fixWidth(0.1)},
                    {field: 'businessKey', title: '业务Key', width: fixWidth(0.20),formatter: function (value, rec){
                    	return "<a href='#' onclick=\"view('" + rec.businessKey + "')\"><font style='color:blue'>"+value+"</font></a>";
                    }},
                    //{field: 'proDefId', title: '流程定义ID', width: fixWidth(0.18)},
                    {
                        field: 'createTime', title: '创建时间', width: fixWidth(0.12), formatter: function (value, rec) {
                        if (rec.createTime == null) return;
                        var date = new Date(rec.createTime.time);
                        var retStr = date.format("yyyy-MM-dd hh:mm:ss");
                        return retStr;
                    }
                    },
                    {field: 'status', title: '状态', width: fixWidth(0.07)},
                    {
                        field: 'op', title: '操作', width: fixWidth(0.25), formatter: function (value, rec) {
                        var showhistory = "<a href='#' class='btn_01_mini' onclick=\"viewHistory('" + rec.id + "')\">历史任务<b></b></a>&nbsp;"
                        if ("运行中" == rec.status)
                            return "<a href='#' class='btn_01_mini' onclick=\"doTerminate('" + rec.id + "')\">终止<b></b></a>&nbsp;<a href='#' class='btn_01_mini' onclick=\"reAssignment('" + rec.id + "')\">改派<b></b></a>" + showhistory; 
//                             return "<a href='#' class='btn_01_mini' onclick=\"reAssignment('" + rec.id + "')\">改派<b></b></a>" + showhistory; 
                        else
                            return showhistory;
                    }
                    }
                ]]
            }));
        });

        function viewHistory(processInstanceId) {
            createSimpleWindow("taskHistory","查看历史任务","${ctx}/jsp/activiti/initViewHistory.action?processInstanceId="+processInstanceId, 800, 400);
        }

        function showOperLog(processInstanceId){
            createSimpleWindow("operLog","查看操作日志","${ctx}/jsp/activitoperlog/activitiOperLogList.action?processInstanceId="+processInstanceId, 800, 400);
        }
    </script>
</head>

<body>
<div class="page_content">
    <div class="box_01 submitdata">
        <div class="inner12px">
            <form name="myform" method="post">
                <div class="cell boxBmargin12">
                    <table>
                        <tr>
                        <th width="15%">编号</th>
                        <td width="35%"><input name="processInstanceId" id="processInstanceId" type="text">
                        </td>
                        <th width="15%">流程创建时间</th>
                        <td width="35%"><input name="startDate" size="20"
                                               id="startDate" value="" type="text" class="Wdate"
                                               onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',maxDate:'#F{$dp.$D(\'endDate\')}'})">
                            -<input name="endDate" id="endDate" size="20" value=""
                                    type="text" class="Wdate"
                                    onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',minDate:'#F{$dp.$D(\'startDate\')}'})">
                        </td>
                        </tr>
                        <tr>
                            <td colspan="4">
                                <div class="btn_area_setc">
                                    <a href="###" class="btn_01" onclick="doQuery()">查询<b></b></a>
                                    <a href="###" class="btn_01" onclick="clear_form(document.myform);">清空<b></b></a>
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
            </form>
            <div id="pagination"></div>
        </div>
    </div>
</div>

<div id="showMapWindow" class="easyui-window" title="流程图" data-options="closed:true"
     style="width:1000px;height:400px;padding:5px;">
    <div class="easyui-layout" data-options="fit:true" style="position:absolute;overflow:auto;">
        <p style="position:absolute;color:blue;left:5px;top:5px;">提示:双击红框内(当前流程所在节点)选择代办人</p>
        <div id="showTask" ondblclick="getCoordinate(event)"></div>
    </div>
</div>

<div id="delegateWindow" class="easyui-window" title="选择代办人" data-options="closed:true"
     style="width:300px;height:400px;padding:5px;">
    <div class="easyui-layout" data-options="fit:true">
        <div style='width: 98%;height: 200px;border: 1px solid #d5d5d5; overflow:auto;margin: 0px;'>
            <ul id="deptTree"></ul>
        </div>
        <div style='width: 98%;height: 90px;border: 1px solid #d5d5d5;margin: 5px 0px;'>
            <div style='width: 30%;height:30px;line-height:30px;float: left;background: #BEE9F0;text-align: center;'>
                <strong>姓名:</strong></div>
            <div style='width: 70%;float: right;height:30px;text-align: center;padding-top:5px;'><input id='inputStr'
                                                                                                        class='form-text'
                                                                                                        style='padding-left:5px;width: 90%;'
                                                                                                        readonly></div>
            <div style='width: 30%;height:30px;line-height:30px;float: left;background: #BEE9F0;text-align: center;'>
                <strong>登录ID:</strong></div>
            <div style='width: 70%;float: right;height:30px;text-align: center;'><input id='inputUserId'
                                                                                        class='form-text'
                                                                                        style='padding-left:5px;width: 90%;'
                                                                                        readonly></div>
            <div style='width: 30%;height:30px;line-height:30px;float: left;background: #BEE9F0;text-align: center;'>
                <strong>手机号:</strong></div>
            <div style='width: 70%;float: right;height:30px;text-align: center;'><input id='inputPhoneNum'
                                                                                        class='form-text'
                                                                                        style='padding-left:5px;width: 90%;'
                                                                                        readonly></div>
        </div>
        <div data-options="region:'south',border:false" style="text-align:right;padding:0px 0 0;">
            <a class="easyui-linkbutton" data-options="iconCls:'icon-ok'" href="javascript:void(0)"
               onclick="delegateTask()" style="width:80px">改派</a>
            <a class="easyui-linkbutton" data-options="iconCls:'icon-cancel'" href="javascript:void(0)"
               onclick='$("#delegateWindow").window("close");' style="width:80px">关闭</a>
        </div>
    </div>
</div>
</body>
</html>
