FS.MessageHelper = FS.Plugin.MessageHelper;
/**
 * 系统消息界面
 * Coder: Sean
 * Date: 14-5-2
 * Time: 下午5:42
 */
FS.SYSMSG = {
    VIEWPATTERN: {
        ALL: "all",
        UNREAD: "unread"
    },
    OPTTYPE: {
        DELETE: "delete",
        UPDATEREADED: "updateReaded",
        UPDATETOASTED: "updateToasted",
        DEAL: "deal"
    },
    //默认展示tabIndex
    DEFAULT_INDEX : 0,

    /**
     * 初始化系统消息中心页面
     */

    createTabPane: function (render, currentMsgType) {
        var self = this,
            msgPaneItems = [],
            tabCount = FS.Plugin.SystemMessageProvider.items.length;
        for(var i = tabCount - 1; i >= 0; i-- ){
            var item = FS.Plugin.SystemMessageProvider.items[i];
            if (FR.Plugin.validLevel(FS.Plugin.SystemMessageProvider, item)) {
                msgPaneItems.push(item.action.call(self, i));
            }
        }
        var displayTab = self.getDisplayTab(msgPaneItems, currentMsgType);
        self.viewPattern = self.VIEWPATTERN.ALL;
        self.count = 0;
        this.tabPane = new FS.LTabPane({
            width: '100%',
            height: '100%',
            items: msgPaneItems,
            defaultIdx: displayTab,
            style: 'blue',
            vgap: 21,
            renderEl: render,
            loadEveryTime: true,
            opAfterActions: []
        });
    },

    getDisplayTab: function (msgPaneItems, currentMsgType) {
        if(!currentMsgType){
            return this.DEFAULT_INDEX;
        }
        for (var i = 0; i < msgPaneItems.length; i++) {
            var typeArr = msgPaneItems[i].messageType;
            if(typeArr.indexOf(currentMsgType) > -1){
                return i;
            }
        }
        return this.DEFAULT_INDEX;
    },

    /**
     * 创建系统消息链接。隔一段时间向后台发送请求取数据
     * @param {Number} interval 时间间隔(毫秒)
     */
    sendSysMsgConn: function (interval) {
        var self = this;
        var fn = function () {
            var completeFn = function (res, status) {
                if (status == 'success') {
                    var result = FR.jsonDecode(res.responseText);
                    if (result && result.fresh && result.unread) {
                        // 有新消息
                        var fresh = result.fresh;
                        self.toastMsg(fresh);

                        // 消息数目发生变动
                        var unReadMsg = result.unread;
                        self.refreshMsgBox(unReadMsg);
                    }
                } else {
                    clearInterval(self.SysMsgConn);
                }
            };
            var config = {
                url: FR.servletURL + "?op=fs_main&cmd=check_toast",
                type: 'POST',
                data: {
                    messageType: []
                }
            };
            FS.Async.ajax(config, completeFn);
        };
        this.SysMsgConn = setInterval(fn, interval);
        setTimeout(fn, 2000);
    },

    /**
     * 弹出系统消息
     * @param {Array} msgs 消息内容
     */
    toastMsg: function (msgs) {
        var self = this;
        var len = msgs.length;
        if (len < 1) {
            return;
        }
        var curidx = 1;
        if (this.toastPane) {
            return;
        }
        var $body = $('body');
        this.toastPane = new FR.Panel({
            renderEl: $('<div class="fs_sysmsg_toastpane"/>').appendTo($body),
            width: 220,
            height: 120,
            title: FR.i18nText("FS-Msg-New_Message"),
            closable: true,
            border: true,
            animate: false,
            onClose: function () {
                self.ignoreMsgs(msgs);
                clearTimeout(panetime);
            },
            contentWidget: {
                type: 'border',
                widgetBackground: {
                    background: '#ffffff'
                },
                items: [
                    {
                        region: 'north',
                        height: 10,
                        el: $('<div/>')
                    }, {
                        region: 'east',
                        width: 5,
                        el: $('<div/>')
                    }, {
                        region: 'west',
                        width: 5,
                        el: $('<div/>')
                    }, {
                        region: 'center',
                        el: {
                            type: 'label',
                            widgetName: 'MSGINFO',
                            fontfamily: 'SimSun',
                            fontsize: 12,
                            value: FS.getShowText(msgs[0].message, 800, 12, 'SimSun'),
                            listeners: [
                                {
                                    eventName: FR.Events.CLICK,
                                    action: function () {
                                        self.dealSysMsg(msgs[curidx - 1]);
                                        self.refreshMsgBox(msgs);
                                        self.ignoreMsgs(msgs);
                                        self.toastPane.destroy();
                                        self.toastPane = null;
                                    }
                                }
                            ]
                        }
                    }, {
                        region: 'south',
                        height: 30,
                        el: {
                            type: 'horizontal',
                            items: [
                                {
                                    el: {
                                        type: 'iconbutton',
                                        imgsrc: 'fs_sysmsg_prev',
                                        handler: function () {
                                            clearTimeout(panetime);
                                            if (curidx <= 1) {
                                                return;
                                            }
                                            curidx--;
                                            self.jumpToastMsg(curidx, len, msgs);
                                        }
                                    }, width: 20
                                },
                                {
                                    el: {
                                        type: 'label',
                                        widgetName: 'PAGELABEL',
                                        value: curidx + '/' + len,
                                        verticalcenter: true,
                                        color: '#707070',
                                        fontsize: 11,
                                        textalign: 'center'
                                    }, width: 30
                                },
                                {
                                    el: {
                                        type: 'iconbutton',
                                        imgsrc: 'fs_sysmsg_next',
                                        handler: function () {
                                            clearTimeout(panetime);
                                            if (curidx >= len) {
                                                return;
                                            }
                                            curidx++;
                                            self.jumpToastMsg(curidx, len, msgs);
                                        }
                                    }, width: 20
                                },
                                {el: $('<div/>'), width: 30},
                                {
                                    el: {
                                        type: 'iconbutton',
                                        text: FR.i18nText("FS-System-Simple_Deal"),
                                        imgsrc: 'fs-sysmsg-deal',
                                        handler: function () {
                                            self.dealSysMsg(msgs[curidx - 1]);
                                            self.refreshMsgBox(msgs);
                                            self.ignoreMsgs(msgs);
                                            self.toastPane.destroy();
                                            self.toastPane = null;
                                        }
                                    }, width: 30
                                },
                                {el: $('<div/>'), width: 10},
                                {
                                    el: {
                                        type: 'iconbutton',
                                        imgsrc: 'fs_sysmsg_viewmsg',
                                        text: FR.i18nText("FS-Msg-View_All") + "&nbsp;&raquo;",
                                        handler: function () {
                                            clearTimeout(panetime);
                                            var currentMsgType = msgs[curidx - 1];
                                            self.dealAllMsg(msgs, currentMsgType.type);
                                            self.toastPane.destroy();
                                            self.toastPane = null;
                                        }
                                    }, width: 70
                                }
                            ]
                        }
                    }
                ]
            }
        });
        var panetime = setTimeout(function () {
            if (self.toastPane) {
                self.ignoreMsgs(msgs);
                self.toastPane.destroy();
                self.toastPane = null;
            }
        }, 10000);
    },

    /**
     * 跳转至指定索引条数的弹出的系统消息
     * @param {Number} curidx 跳转位置
     * @param {Number} len 总条数
     * @param {Array} msgs 所有信息
     */
    jumpToastMsg: function (curidx, len, msgs) {
        var pane = this.toastPane;
        pane.getWidgetByName("MSGINFO")
            .setValue(FS.getShowText(msgs[curidx - 1].message, 800, 12, 'SimSun'));
        pane.getWidgetByName("PAGELABEL").setValue(curidx + '/' + len);
    },
    /**
     * 进入系统消息处理中心
     */
    goSysMsgCenter: function (currentMsgType) {
        var self = this;
        if (!self.$container) {
            self.$container = $("<div/>").addClass('fs_design_container');
        }
        self.$container.children().remove();
        FS.tabPane.addItem({
            title: FR.i18nText("FS-Generic-RP_System_Message"),
            contentEl: self.$container,
            afterLoad: function () {
                self.createTabPane(self.$container, currentMsgType);
            }
        });
    },

    /**
     * 忽略(删除)消息
     * @param {Array} msgs 需要忽略的消息
     * @param {Boolean} needDelete 是否需要从数据库中删除消息
     * @param {Function} callback 回调函数
     */
    ignoreMsgs: function (msgs, optType, callback) {
        var self = this;
        var messages = msgs || [];
        var completeFn = function (res, status) {
            if (status == 'success') {
                var result = FR.jsonDecode(res.responseText);
                if (result.error) {
                    FR.Msg.toast(result.error);
                } else {
                    callback && callback.apply(self, arguments);
                }
            }
        };
        var config = {
            url: FR.servletURL + "?op=fs_main&cmd=click_toast",
            type: 'POST',
            data: {
                msgs: messages,
                clicked: optType
            }
        };
        FS.Async.ajax(config, completeFn);
    },

    /**
     * 处理全部消息,清空消息盒子,进入系统消息中心。
     * @param {Array} msgs 所有消息对象
     */
    dealAllMsg: function (msgs, currentMsgType) {
        var self = this;
        this.ignoreMsgs(msgs, self.OPTTYPE.UPDATETOASTED, function () {
            self.goSysMsgCenter(currentMsgType);
        });

    },

    /**
     * 刷新消息盒子
     * @param {Array} msgs 新消息
     */
    refreshMsgBox: function (msgs) {
        var self = this;
        FS.refreshMsgBox(msgs, function ($dropdown) {
            var $list = $('<div/>').appendTo($dropdown);
            if (!msgs) {
                return;
            }
            for (var i = 0, len = msgs.length; i < len; i++) {
                if (i > 4) {
                    break; //消息盒子下拉最多显示5条最新消息
                }
                var item = msgs[i];
                var $item = $('<div class="fs_sysmsg_combo_item fui-bsc"/>');
                var text = item.message;
                $('<div class="fs_sysmsg_combo_text"/>')
                    .attr('title', text)
                    .text(FS.getShowText(text, 260, 12, 'SimSun')).appendTo($item);
                $item.click(function () {
                    //处理指定的一条系统消息, 刷新下消息盒子.
                    var index = $(this).data('index');
                    self.dealSysMsg(msgs[index]);
                    msgs.splice(index, 1);
                    self.refreshMsgBox(msgs);
                    $dropdown.slideUp('fast');
                }).appendTo($list).data('index', i);
            }
        });
    },

    /**
     * 处理一条新消息
     * @param {Object} msg 一个消息对象
     */
    dealSysMsg: function (msg) {
        var self = this;
        var result = FS.Sync.ajax({
            url: FR.servletURL + "?op=fs_main&cmd=click_toast",
            type: 'POST',
            data: {
                msgs: [msg],
                clicked: this.OPTTYPE.DEAL
            }
        });
        if (result.error) {
            FR.Msg.toast(result.error);
            return;
        }
        if (result.dealInfo === "overtime") {
            self.showSysmsgDialog(FR.i18nText("FS-System-Task_Expired"));
            return;
        }
        if (result.dealInfo === "processed") {
            self.showSysmsgDialog(FR.i18nText("FS-System-Task_Completed"));
            return;
        }
        $.each(FS.Plugin.MessageHelper.items, function (i, item) {
            if (FR.Plugin.validLevel(FS.Plugin.MessageHelper, item)) {
                item.action.call(self, msg);
            }
        });
    },

    /**
     * 关闭系统消息
     */
    closeSysMsgConn: function () {
        if (this.SysMsgConn) {
            clearInterval(this.SysMsgConn);
        }
    },

    /**
     *  消息面板配置
     */
    createMsgPaneConfig: function (index ,config) {
        var self = this;
        return {
            title: config.title,
            messageType: config.messageType,
            content: {
                widgetName: 'reportMsgPane',
                type: 'panel',
                width: 1000,
                height: 500,
                doSize: true,
                contentWidget: {
                    type: 'tablepane',
                    widgetName: 'systemMsgTable' + index,
                    colSize: [20, 100, 20, 100, 165, 30, 65, 10, 200, "fill"],
                    rowSize: [28, "fill"],
                    vgap: 20,
                    items: [
                        [
                            {}, {
                            //标记为已读按钮
                            type: 'iconbutton',
                            text: FR.i18nText("FS-System-Marked_Read"),
                            baseClass: 'fs-sysmgr-mark',
                            handler: function () {
                                var msggrid = self.tabPane.getWidgetByName("MSGGRID" + index);
                                var selectedData = msggrid.getSelectedData();
                                if (selectedData.length === 0) {
                                    self.showSysmsgDialog(FR.i18nText("FS-System-Select_Tip"));
                                    return;
                                } else {
                                    FR.Msg.confirm(FR.i18nText("FS-System-Marked_Read"), FR.i18nText("FS-System-Mark_Confirm") + "?", function (result) {
                                        if (result) {
                                            self.ignoreMsgs(selectedData, self.OPTTYPE.UPDATEREADED, function () {
                                                msggrid.refresh();
                                            });
                                        }
                                    });
                                }
                            }
                        }, {}, {
                            //删除按钮
                            type: 'iconbutton',
                            text: FR.i18nText("FS-Generic-Simple_Delete"),
                            baseClass: 'fs-sysmgr-delete',
                            handler: function () {
                                var msggrid = self.tabPane.getWidgetByName("MSGGRID" + index);
                                var selectedData = msggrid.getSelectedData();
                                if (selectedData.length === 0) {
                                    self.showSysmsgDialog(FR.i18nText("FS-System-Select_Tip"));
                                    return;
                                } else {
                                    FR.Msg.confirm(FR.i18nText("FS-Frame-Delete_Data"), FR.i18nText("FS-Generic-Sure_To_Delete") + "?", function (result) {
                                        if (result) {
                                            self.ignoreMsgs(selectedData, self.OPTTYPE.DELETE, function () {
                                                msggrid.refresh();
                                            });
                                        }
                                    });
                                }

                            }
                        }, {}, {
                            type: 'llabel',
                            value: self.count + FR.i18nText("FS-System-Messages_Count"),
                            widgetName: 'count' + index
                        },
                            {
                                //查看消息
                                type: 'iconbutton',
                                text: FR.i18nText("FS-System-Unread_Messages"),
                                baseClass: 'fs-sysmgr-viewpattern',
                                widgetName: 'viewPattern' + index,
                                handler: function () {
                                    //已读和未读切换
                                    self.toggleMsgView(index);
                                }
                            }, {}, {
                            type: 'search',
                            widgetName: 'searchMsg' + index,
                            onSearch: function () {
                                var value = this.getValue();
                                var msggrid = self.tabPane.getWidgetByName("MSGGRID" + index);
                                var data = msggrid.options.async.data;
                                data.startIdx = 0;
                                data.keyword = value;
                                msggrid.activedPage = 1;
                                msggrid.refresh();
                            }
                        }, null
                        ], [
                            $('<div/>').height(1), null, null, null, null, null, null, null, self.createMsgTable(index, config.messageType)
                        ]
                    ]
                }
            }
        };
    },

    /**
     *  消息table配置
     */
    createMsgTable: function (index, type) {
        var self = this;
        return {
            type: 'quickgrid',
            widgetName: 'MSGGRID' + index,
            page: true,
            pageCount: 10,
            multiSelect: true,
            intervalColor: true,
            async: {
                url: FR.servletURL + "?op=fs_main&cmd=get_all",
                type: 'POST',
                data: {
                    serverID: FS.serverID,
                    messageType: type
                }
            },
            onAsyncSuccess: function (res, status) {
                var result = FR.jsonDecode(res);
                this.options.items = self.displayByReaded(result.toasted, self.viewPattern);
                self.refreshMsgBox(self.displayByReaded(result.toasted, self.VIEWPATTERN.UNREAD));
                var unReadCountWidget = self.tabPane.getWidgetByName("count" + index);
                unReadCountWidget.setValue(self.count + FR.i18nText("FS-System-Messages_Count"));
            },
            columnsConfig: [
                {
                    key: 'message',
                    value: FR.i18nText("FS-System-Platform_Messages"),
                    width: 300,
                    onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                        var $msgTd = $("<div/>");
                        if (item.readed) {
                            $msgTd.css("color", "grey");
                        }

                        $msgTd.html(item.message);
                        return $msgTd;
                    }
                }, {
                    key: 'datetime',
                    value: FR.i18nText("FS-System-Date_Time"),
                    width: 350,
                    onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                        var $dateTd = $("<div/>");
                        if (item.readed) {
                            $dateTd.css("color", "grey");
                        }
                        $dateTd.html(item.createTime);
                        return $dateTd;
                    }
                },
                {
                    width: 45,
                    onCellCreate: function (rowIdx, colIdx, item, colCfg) {
                        var grid = this;
                        var btn = new FR.IconButton({
                            text: FR.i18nText("FS-System-Simple_Deal"),
                            imgsrc: 'fs-sysmsg-deal',
                            width: 45,
                            height: 25,
                            handler: function () {
                                //先获取该消息最新状态
                                self.dealSysMsg(item);
                                self.refreshMsgTable(index);
                            }
                        });
                        return btn.element;
                    }
                }
            ]
        };
    },

    /**
     * 将获取到的信息区分成已读和未读展示
     * @param {Array} msgItems 全部消息
     * @param {String} viewPattern 消息查看方式
     */
    displayByReaded: function (msgItems, viewPattern) {
        var newItems = [];
        var readedItems = [];
        msgItems = msgItems ? msgItems : [];
        $.each(msgItems, function (index, item) {
            if (item.readed === false) {
                newItems.push(item);
            } else {
                readedItems.push(item);
            }
        });
        this.count = newItems.length;
        if (viewPattern === this.VIEWPATTERN.ALL) {
            return newItems.concat(readedItems);
        }
        return newItems;
    },

    /**
     *  刷新消息面板
     */
    refreshMsgTable: function (index) {
        var self = this;
        var msggrid = self.tabPane.getWidgetByName("MSGGRID" + index);
        msggrid.refresh();
    },

    /**
     *  切换消息查看方式
     */
    toggleMsgView: function (index) {
        var self = this;
        var give = {};
        var unReadCountWidget = self.tabPane.getWidgetByName("count" + index);
        var viewPatternWidget = self.tabPane.getWidgetByName("viewPattern" + index);
        if (self.viewPattern === self.VIEWPATTERN.ALL) {
            self.viewPattern = self.VIEWPATTERN.UNREAD;
            unReadCountWidget.setVisible(false);
            give = {width: Math.max(95, FR.i18nTextWidth("FS-System-View_All", 7) + 25)};
            viewPatternWidget.$btn.text(FR.i18nText("FS-System-View_All"));
        } else {
            self.viewPattern = self.VIEWPATTERN.ALL;
            unReadCountWidget.setVisible(true);
            give = {width: 65};
            viewPatternWidget.$btn.text(FR.i18nText("FS-System-Unread_Messages"));
        }
        viewPatternWidget.doResize(give);
        self.refreshMsgTable(index);
    },

    /**
     *  弹出对话框
     */
    showSysmsgDialog: function (args) {
        var content;
        if (typeof args === 'string') {
            content = args;
        }
        var dlg = new FR.Dialog({
            title: FR.i18nText("FS-System-Dialog_Title"),
            height: 190,
            width: Math.max(320, FR.byteLength(content) * 6.5 + 80),
            widgetName: 'customdialog',
            contentWidget: {
                type: 'absolute',
                items: [
                    {
                        el: $('<div>' + content + '</div>').css({
                            'left': 30,
                            'right': 30,
                            'top': 55,
                            'font-size': '13px',
                            'text-align': 'center'
                        })
                    },
                    {
                        type: 'quickbutton',
                        text: FR.i18nText("FS-System-Dialog_Ok"),
                        width: 60,
                        height: 30,
                        x: 235,
                        y: 120,
                        handler: function () {
                            //关闭dialog窗口
                            dlg.getWidgetByName('customdialog').doClose();
                        }
                    }
                ]
            }
        });
        dlg.setVisible(true);
        return dlg;
    }

};