/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jshx.smgp.message;

import cn.com.jshx.smgp.bean.Deliver;
import cn.com.jshx.smgp.message.Message;
import cn.com.jshx.smgp.protocol.RequestId;
import cn.com.jshx.smgp.protocol.Tlv;
import cn.com.jshx.smgp.protocol.TlvId;
import cn.com.jshx.smgp.protocol.TlvUtil;
import cn.com.jshx.util.Hex;
import cn.com.jshx.util.TypeConvert;
import java.util.Vector;

public class DeliverMessage
extends Message {
    public byte[] MsgID_BCD;
    public String MsgID;
    public int IsReport;
    public int MsgFormat;
    public String RecvTime;
    public String SrcTermID;
    public String DestTermID;
    public int MsgLength;
    public byte[] MsgContent;
    public byte[] Reserve;
    public String LinkID;
    public int TP_udhi;
    public String ReportMsgID;
    public Tlv[] OtherTlv;

    public DeliverMessage(Deliver deliver) {
        this.MsgID = deliver.MsgID;
        this.IsReport = deliver.IsReport;
        this.MsgFormat = deliver.MsgFormat;
        this.RecvTime = deliver.RecvTime;
        this.SrcTermID = deliver.SrcTermID;
        this.DestTermID = deliver.DestTermID;
        this.MsgLength = deliver.MsgLength;
        this.MsgContent = deliver.MsgContent;
        this.Reserve = deliver.Reserve;
        this.LinkID = deliver.LinkID;
        this.TP_udhi = deliver.TP_udhi;
        this.OtherTlv = deliver.OtherTlv;
        int len = 89 + deliver.MsgLength;
        int tlvlength = 0;
        Vector<Tlv> tlvV = new Vector<Tlv>();
        if (this.LinkID != null) {
            tlvV.add(new Tlv(TlvId.LinkID, this.LinkID));
        }
        if (this.TP_udhi != 0) {
            tlvV.add(new Tlv(TlvId.TP_udhi, String.valueOf(this.TP_udhi)));
        }
        if (this.OtherTlv != null) {
            int i = 0;
            while (i < this.OtherTlv.length) {
                tlvV.add(this.OtherTlv[i]);
                ++i;
            }
        }
        Tlv[] tlvarray = new Tlv[tlvV.size()];
        int i = 0;
        while (i < tlvV.size()) {
            tlvarray[i] = (Tlv)tlvV.get(i);
            tlvlength += tlvarray[i].TlvBuf.length;
            ++i;
        }
        this.buf = new byte[len += tlvlength];
        TypeConvert.int2byte(len, this.buf, 0);
        TypeConvert.int2byte(RequestId.Deliver, this.buf, 4);
        TypeConvert.int2byte(this.sequence_Id, this.buf, 8);
        System.arraycopy(Hex.rstr(this.MsgID), 0, this.buf, 12, 10);
        this.buf[22] = (byte)this.IsReport;
        this.buf[23] = (byte)this.MsgFormat;
        System.arraycopy(this.RecvTime.getBytes(), 0, this.buf, 24, this.RecvTime.length());
        System.arraycopy(this.SrcTermID.getBytes(), 0, this.buf, 38, this.SrcTermID.length());
        System.arraycopy(this.DestTermID.getBytes(), 0, this.buf, 59, this.DestTermID.length());
        this.buf[80] = (byte)this.MsgLength;
        System.arraycopy(this.MsgContent, 0, this.buf, 81, this.MsgLength);
        if (this.Reserve != null) {
            System.arraycopy(this.Reserve, 0, this.buf, 81 + this.MsgLength, this.Reserve.length);
        }
        int cur = 81 + this.MsgLength + 8;
        int i2 = 0;
        while (i2 < tlvarray.length) {
            System.arraycopy(tlvarray[i2].TlvBuf, 0, this.buf, cur, tlvarray[i2].TlvBuf.length);
            cur += tlvarray[i2].TlvBuf.length;
            ++i2;
        }
    }

    public DeliverMessage(byte[] buffer) {
        this.sequence_Id = TypeConvert.byte2int(buffer, 0);
        this.MsgID_BCD = new byte[10];
        System.arraycopy(buffer, 4, this.MsgID_BCD, 0, this.MsgID_BCD.length);
        this.MsgID = TypeConvert.getHexString(buffer, 4, 0, 10);
        this.IsReport = buffer[14];
        this.MsgFormat = buffer[15];
        this.RecvTime = TypeConvert.getString(buffer, 16, 0, 14);
        this.SrcTermID = TypeConvert.getString(buffer, 30, 0, 21);
        this.DestTermID = TypeConvert.getString(buffer, 51, 0, 21);
        this.MsgLength = buffer[72] & 0xFF;
        this.MsgContent = new byte[this.MsgLength];
        System.arraycopy(buffer, 73, this.MsgContent, 0, this.MsgLength);
        if (this.IsReport == 1) {
            byte[] tmpmsgid = new byte[10];
            System.arraycopy(this.MsgContent, 3, tmpmsgid, 0, 10);
            this.ReportMsgID = Hex.rhex(tmpmsgid);
        }
        this.Reserve = new byte[8];
        System.arraycopy(buffer, 73 + this.MsgLength, this.Reserve, 0, this.Reserve.length);
        byte[] tlv = new byte[buffer.length - 73 - this.MsgLength - 8];
        System.arraycopy(buffer, this.MsgLength + 73 + 8, tlv, 0, tlv.length);
        Tlv[] otherTlv = TlvUtil.TlvAnalysis(tlv);
        this.OtherTlv = otherTlv;
        int i = 0;
        while (i < otherTlv.length) {
            if (otherTlv[i].Tag == TlvId.LinkID) {
                this.LinkID = otherTlv[i].Value;
            } else if (otherTlv[i].Tag == TlvId.TP_udhi) {
                this.TP_udhi = Integer.parseInt(otherTlv[i].Value);
            }
            ++i;
        }
    }
}

