/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.trigger;

import com.fr.base.FRContext;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.fs.schedule.trigger.ITrigger;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.third.org.quartz.CronTrigger;
import com.fr.third.org.quartz.Trigger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class CronExpressionITrigger
extends ITrigger {
    public static final String TABLE_NAME = "fr_cronexpression_itrigger";
    public static final int TYPE = 4;
    private static final int IMMEDIATE = 1;
    private static final int SET_TIME = 2;
    public static final String NAME = "cronexpression";
    public static final ObjectTableMapper OBJECT_MAPPER = new ObjectTableMapper(CronExpressionITrigger.class, new Table("fr_cronexpression_itrigger"), (FieldColumnMapper[])ArrayUtils.addAll((Object[])ITrigger.ITRIGGER_FIELDMAPPER, (Object[])new FieldColumnMapper[]{ITrigger.EndTimeFieldMapper, new CommonFieldColumnMapper("cronExpression", 12, "cron_expression", new ColumnSize(255), true)}));
    private String cronExpression = "";
    private static final long serialVersionUID = 1L;

    public Trigger createTrigger() {
        CronTrigger cronTrigger = new CronTrigger("trigger_" + this.getId() + "_" + this.getITriggerIdPrefix(), "ReportJobs");
        if (this.getStartType() != 1L) {
            if (this.getStartType() == 2L && this.getStartTime() != null) {
                cronTrigger.setStartTime(this.getStartTime());
            } else {
                throw new IllegalStateException("When build the cronExpression, The statemenet is illegal:" + this.cronExpression);
            }
        }
        if (this.getEndTime() != null) {
            cronTrigger.setEndTime(this.getEndTime());
        }
        try {
            cronTrigger.setCronExpression(this.cronExpression);
        }
        catch (ParseException parseException) {
            FRContext.getLogger().error(parseException.getMessage(), (Throwable)parseException);
        }
        cronTrigger.setTimeZone(TimeZone.getTimeZone(this.getTimeZoneID()));
        cronTrigger.setMisfireInstruction(2);
        return cronTrigger;
    }

    public int getITriggerIdPrefix() {
        return 4;
    }

    public String getCroExpression() {
        return this.cronExpression;
    }

    public void setCroExpression(String string) {
        this.cronExpression = string;
    }

    public ITrigger analyzeJSON(JSONObject jSONObject) {
        try {
            CronExpressionITrigger cronExpressionITrigger = new CronExpressionITrigger();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.parseStartTime(jSONObject, cronExpressionITrigger, simpleDateFormat);
            if (jSONObject.has("id")) {
                cronExpressionITrigger.setId(jSONObject.optLong("id"));
            }
            if (jSONObject.has("cronExpression")) {
                cronExpressionITrigger.setCroExpression(jSONObject.getString("cronExpression"));
            }
            this.parseEndTime(jSONObject, cronExpressionITrigger, simpleDateFormat);
            return cronExpressionITrigger;
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private CronExpressionITrigger parseStartTime(JSONObject jSONObject, CronExpressionITrigger cronExpressionITrigger, DateFormat dateFormat) throws Exception {
        long l = jSONObject.getLong("startType");
        Date date = null;
        if (l == 2L) {
            String string = jSONObject.getString("startTime");
            date = dateFormat.parse(string);
        }
        cronExpressionITrigger.setStartType(l);
        cronExpressionITrigger.setStartTime(date);
        return cronExpressionITrigger;
    }

    private void parseEndTime(JSONObject jSONObject, CronExpressionITrigger cronExpressionITrigger, DateFormat dateFormat) throws Exception {
        if (jSONObject.has("endTime")) {
            String string = jSONObject.getString("endTime");
            Date date = dateFormat.parse(string);
            cronExpressionITrigger.setEndTime(date);
        }
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = super.createJSONConfig();
        jSONObject.put("recurrenceType", (Object)NAME);
        if (this.getEndTime() != null) {
            Date date = this.getEndTime();
            String string = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
            jSONObject.put("endTime", (Object)string);
        }
        jSONObject.put("cronExpression", (Object)this.cronExpression);
        return jSONObject;
    }
}

