/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.job;

import com.fr.base.BaseXMLUtils;
import com.fr.base.ConfigManager;
import com.fr.base.EmailManager;
import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.mobile.push.MobileMessagePushManager;
import com.fr.base.mobile.push.MobilePushMessage;
import com.fr.base.platform.msg.Message;
import com.fr.file.DefaultClusterServerProcessor;
import com.fr.fs.base.entity.UserEntryNotification;
import com.fr.fs.control.UserControl;
import com.fr.fs.dao.FSDAOManager;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.schedule.ScheduleLinkOutput;
import com.fr.fs.schedule.ScheduleLinkOutputDAO;
import com.fr.fs.schedule.ScheduleUserAndCPRFile;
import com.fr.fs.schedule.ViewScheduleSavedInfo;
import com.fr.fs.schedule.job.DoFileActionJob;
import com.fr.fs.schedule.job.ReportletJob;
import com.fr.fs.web.ShowType;
import com.fr.fs.web.service.FSSetAuthGetEntryUsersAction;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.main.TemplateWorkBook;
import com.fr.main.workbook.PageWorkBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.plugin.ExtraClassManager;
import com.fr.privilege.PrivilegeManager;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.ReportHelper;
import com.fr.report.fun.ScheduleTemplateModifyProvider;
import com.fr.schedule.output.AbstractOutputFileAction;
import com.fr.schedule.output.EmailException;
import com.fr.schedule.output.EmailNotification;
import com.fr.schedule.output.FileActionList;
import com.fr.schedule.output.FileRepository;
import com.fr.schedule.output.PushOutputFileAction;
import com.fr.schedule.output.ScheduledOutput;
import com.fr.schedule.plugin.CallBack;
import com.fr.schedule.plugin.ExtraPlatformScheduleClassManager;
import com.fr.schedule.plugin.ResultOfFormula;
import com.fr.schedule.plugin.ScheduleFastUserNameProcessor;
import com.fr.schedule.task.ScheduleTask;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.schedule.util.ScheduleUtils;
import com.fr.script.Calculator;
import com.fr.stable.ActorFactory;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.cluster.ScheduleResultWorkBookProvider;
import com.fr.stable.cluster.ScheduleTemplateWorkBookProvider;
import com.fr.stable.fun.ClusterServerProcessor;
import com.fr.stable.script.NameSpace;
import com.fr.stable.xml.XMLWriter;
import com.fr.web.WebletException;
import com.fr.web.request.ReportletRequest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewReportletJob
extends ReportletJob {
    private static final ShowType SHOWTYPE = ShowType.PAGE;
    private ViewScheduleSavedInfo viewScheduleSavedInfo;
    private File saveDirectory;
    private String currentUserName;
    private HashMap userBookMap = new HashMap();

    @Override
    protected void executeReport() {
        this.record_list = new ArrayList();
        this.arrayParaList = new ArrayList();
        FileRepository fileRepository = this.scheduleTask.getScheduledOutput().getFileRepository();
        this.saveDirectory = ScheduleUtils.getTaskTimeDirFile(fileRepository, this.scheduleTask.getName(), this.scheduledFireTime);
        if (!this.saveDirectory.exists()) {
            StableUtils.mkdirs((File)this.saveDirectory);
        }
        try {
            this.reportlet = ReportHelper.generateReportlet((String)this.reportPath);
            File file = new File(StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), "reportlets", this.reportPath}));
            if (!file.exists()) {
                this.log.error("[Schedule] Not found reportlet: " + this.reportPath);
                return;
            }
            ScheduleUtils.calculatorParameters(this.getExecuteParameter(), this.record_list, this.arrayParaList);
            this.viewScheduleSavedInfo = new ViewScheduleSavedInfo();
            this.viewScheduleSavedInfo.setShowType(SHOWTYPE);
            if (!this.arrayParaList.isEmpty()) {
                this.viewScheduleSavedInfo.setFArrayParameters(this.arrayParaList.toArray(new Parameter[this.arrayParaList.size()]));
            }
            this.executeScheduledOutput();
        }
        catch (Exception exception) {
            this.dealWithException(exception);
        }
    }

    private void executeScheduledOutput() throws Exception {
        String[] stringArray = new String[this.arrayParaList.size()];
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((Parameter)this.arrayParaList.get(i)).getName();
        }
        ScheduledOutput scheduledOutput = this.scheduleTask.getScheduledOutput();
        ScheduleUserAndCPRFile scheduleUserAndCPRFile = new ScheduleUserAndCPRFile();
        if (scheduledOutput.isSendEmailByUsername()) {
            scheduleUserAndCPRFile = this.sendEmailByUserName(this.record_list, stringArray);
        }
        if (scheduledOutput.isCreateCPRByUsername()) {
            this.createCRPByUsername(stringArray, scheduledOutput, scheduleUserAndCPRFile);
        } else {
            this.currentUserName = null;
            String string = this.executeReportByUsername(this.record_list, stringArray, false, true);
            if (StringUtils.isNotBlank((String)string)) {
                this.pushMessage();
            }
        }
        if (!scheduleUserAndCPRFile.isEmpty()) {
            this.writeUserCprXML(scheduleUserAndCPRFile);
        }
        this.log.info("[Schedule] The Task '" + this.scheduleTask.getName() + "' of " + this.reportPath + " has finished!");
    }

    private void createCRPByUsername(String[] stringArray, ScheduledOutput scheduledOutput, ScheduleUserAndCPRFile scheduleUserAndCPRFile) throws Exception {
        String string = scheduledOutput.getUsernames();
        String[] stringArray2 = new String[]{};
        if (StringUtils.isNotBlank((String)string)) {
            stringArray2 = string.split(",");
        }
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            this.currentUserName = stringArray2[i];
            if (scheduleUserAndCPRFile.hasUser(this.currentUserName)) {
                PushOutputFileAction pushOutputFileAction;
                FileActionList fileActionList;
                object = (ResultWorkBook)this.userBookMap.get(this.currentUserName);
                if (object != null && (fileActionList = this.scheduleTask.getScheduledOutput().getOutputFileActionList()) != null && (pushOutputFileAction = fileActionList.getPushOutputFileAction()) != null) {
                    pushOutputFileAction.setBook((ResultWorkBook)object);
                }
                if (!StringUtils.isNotEmpty((String)scheduleUserAndCPRFile.getPath(this.currentUserName))) continue;
                this.pushMessage();
                continue;
            }
            object = this.executeReportByUsername(this.record_list, stringArray, false, false);
            scheduleUserAndCPRFile.addPath(this.currentUserName, (String)object);
            if (StringUtils.isNotEmpty((String)scheduleUserAndCPRFile.getPath(this.currentUserName))) {
                this.pushMessage();
            }
            if (i != n - 1) continue;
            scheduledOutput.getOutputFileActionList().resetPushOutputFileAction();
        }
        this.userBookMap.clear();
        this.sendOffAttach(stringArray, scheduledOutput);
    }

    private void sendOffAttach(String[] stringArray, ScheduledOutput scheduledOutput) throws Exception {
        if (scheduledOutput.getOutputFileActionList().isEmpty()) {
            scheduledOutput.synFileActionList();
        }
        if (!scheduledOutput.getOutputFileActionList().isEmpty()) {
            this.currentUserName = null;
            this.executeReportByUsername(this.record_list, stringArray, false, true);
        }
    }

    private void addParameterAndResultBook(Map map, ResultWorkBook resultWorkBook) {
        if (map == null || map.isEmpty()) {
            return;
        }
        ScheduledOutput scheduledOutput = this.scheduleTask.getScheduledOutput();
        if (scheduledOutput.getOutputFileActionList() == null || scheduledOutput.getOutputFileActionList().size() == 0) {
            scheduledOutput.synFileActionList();
        }
        FileActionList fileActionList = scheduledOutput.getOutputFileActionList();
        int n = fileActionList.size();
        for (int i = 0; i < n; ++i) {
            AbstractOutputFileAction abstractOutputFileAction = (AbstractOutputFileAction)fileActionList.get(i);
            abstractOutputFileAction.setParameters(map);
            abstractOutputFileAction.setBook(resultWorkBook);
        }
    }

    private ScheduleUserAndCPRFile sendEmailByUserName(List list, String[] stringArray) throws Exception {
        ScheduleUserAndCPRFile scheduleUserAndCPRFile = new ScheduleUserAndCPRFile();
        FileActionList fileActionList = this.scheduleTask.getScheduledOutput().getOutputFileActionList();
        EmailNotification emailNotification = fileActionList.getEmailNotification();
        String string = emailNotification.getNeedMailUser();
        for (String this.currentUserName : this.getUserNameFromAddress(string)) {
            String string2 = this.executeReportByUsername(list, stringArray, true, false);
            scheduleUserAndCPRFile.addPath(this.currentUserName, string2);
        }
        fileActionList.remove(fileActionList.getEmailNotification());
        fileActionList.setEmailNotification(null);
        return scheduleUserAndCPRFile;
    }

    private String[] getUserNameFromAddress(String string) {
        if (StringUtils.isBlank((String)string)) {
            return new String[0];
        }
        String[] stringArray = string.split(",");
        String[] stringArray2 = new String[stringArray.length];
        block0: for (String string2 : stringArray) {
            EmailManager emailManager = ConfigManager.getProviderInstance().getEmailManager();
            Map map = emailManager.getAllUsersMap();
            for (String string3 : map.keySet()) {
                if (!ComparatorUtils.equals((Object)string2, map.get(string3))) continue;
                stringArray2[var4_4] = string3;
                continue block0;
            }
        }
        return stringArray2;
    }

    private String executeReportByUsername(List list, String[] stringArray, boolean bl, boolean bl2) throws Exception {
        File file;
        String string = this.scheduleTask.getReportletPath();
        String string2 = string.substring(string.lastIndexOf("/") + 1, string.lastIndexOf("."));
        ScheduledOutput scheduledOutput = this.scheduleTask.getScheduledOutput();
        ArrayList arrayList = new ArrayList();
        File file2 = file = StringUtils.isBlank((String)this.currentUserName) ? this.saveDirectory : new File(this.saveDirectory.getAbsolutePath() + File.separator + this.currentUserName);
        if (!file.exists()) {
            StableUtils.mkdirs((File)file);
        }
        File[] fileArray = new File[]{};
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Map map = (Map)list.get(i);
            this.addUserName(map);
            TemplateWorkBook templateWorkBook = null;
            try {
                templateWorkBook = this.reportlet.createReport((ReportletRequest)new ScheduleReportletRequestImpl(map));
            }
            catch (WebletException webletException) {
                this.log.error(ScheduleLogUtils.combineByColon("Not_Found_Reportlet", string));
            }
            if (templateWorkBook == null) {
                this.log.error(ScheduleLogUtils.combineByColon("Not_Found_Reportlet", string));
                return null;
            }
            Calculator.putThreadSavedNameSpace((NameSpace)ParameterMapNameSpace.create((Map)map));
            this.modifyBookBeforeExecute(templateWorkBook);
            PageWorkBook pageWorkBook = this.fastUserNameFilter(map, templateWorkBook, bl2);
            if (pageWorkBook == null) {
                return null;
            }
            if (StringUtils.isNotBlank((String)this.currentUserName)) {
                this.userBookMap.put(this.currentUserName, pageWorkBook);
            }
            this.addParameterAndResultBook(map, (ResultWorkBook)pageWorkBook);
            String string3 = ScheduleUtils.createOutputReportName(string2, i, stringArray);
            fileArray = scheduledOutput.exportReportFiles(pageWorkBook, string3, file);
            this.dealWithInfo(this.scheduleTask, fileArray, map, arrayList, this.currentUserName);
        }
        this.exportViewScheduleSavedInfo(this.saveDirectory, this.viewScheduleSavedInfo);
        if (bl) {
            return this.excuteSendMailByUserName(scheduledOutput, arrayList, fileArray);
        }
        if (bl2) {
            DoFileActionJob.doFileAction(this.scheduleTask, Arrays.asList(fileArray));
        }
        return fileArray[0].getAbsolutePath();
    }

    private PageWorkBook fastUserNameFilter(Map map, TemplateWorkBook templateWorkBook, boolean bl) {
        CallBack callBack;
        ResultOfFormula resultOfFormula = ResultOfFormula.REGULAR;
        ScheduleFastUserNameProcessor scheduleFastUserNameProcessor = (ScheduleFastUserNameProcessor)ExtraPlatformScheduleClassManager.getInstance().getSingle("ScheduleFastUserNameProcessor");
        if (scheduleFastUserNameProcessor != null) {
            if (!bl && (resultOfFormula = scheduleFastUserNameProcessor.needFastUserNameExtra(this.scheduleTask, map, this.currentUserName, callBack = new CallBack(){

                public void userFilterProcessor() {
                    ViewReportletJob.this.restartTask();
                }

                public String userFilterProcessorForString() {
                    return ViewReportletJob.this.getExecuteFailLog();
                }
            })) == ResultOfFormula.FASTNOPASS) {
                return null;
            }
        } else {
            PageWorkBook pageWorkBook = this.executeWorkBookAsPage(map, templateWorkBook);
            if (!this.checkExecuteFormula(map, (ResultWorkBook)pageWorkBook)) {
                return null;
            }
            return pageWorkBook;
        }
        callBack = this.executeWorkBookAsPage(map, templateWorkBook);
        if (resultOfFormula == ResultOfFormula.REGULAR && !this.checkExecuteFormula(map, (ResultWorkBook)callBack)) {
            return null;
        }
        return callBack;
    }

    private PageWorkBook executeWorkBookAsPage(Map<String, Object> map, TemplateWorkBook templateWorkBook) {
        ClusterServerProcessor clusterServerProcessor = (ClusterServerProcessor)ExtraClassManager.getInstance().getSingle("ClusterServerProcessor", DefaultClusterServerProcessor.class);
        ScheduleResultWorkBookProvider scheduleResultWorkBookProvider = clusterServerProcessor.scheduleRemoteExecute(map, "page", (ScheduleTemplateWorkBookProvider)templateWorkBook);
        if (scheduleResultWorkBookProvider != null) {
            return (PageWorkBook)scheduleResultWorkBookProvider;
        }
        return (PageWorkBook)templateWorkBook.execute(map, ActorFactory.getActor((String)"page"));
    }

    private void addUserName(Map map) {
        if (StringUtils.isNotEmpty((String)this.currentUserName)) {
            map.put("fr_username", this.currentUserName);
        } else {
            map.put("fr_username", "");
        }
    }

    private void modifyBookBeforeExecute(TemplateWorkBook templateWorkBook) {
        ScheduleTemplateModifyProvider scheduleTemplateModifyProvider = (ScheduleTemplateModifyProvider)ExtraReportClassManager.getInstance().getSingle("ScheduleTemplateModifyProvider");
        if (scheduleTemplateModifyProvider == null) {
            return;
        }
        scheduleTemplateModifyProvider.modifyScheduleTemplate(templateWorkBook);
    }

    private void pushMessage() throws Exception {
        ScheduledOutput scheduledOutput = this.scheduleTask.getScheduledOutput();
        if (scheduledOutput.getFolderEntryId() != -1L) {
            String string = this.getPushContent();
            List list = ScheduleLinkOutputDAO.getInstance().findByOutputId(scheduledOutput.getId());
            if (list.isEmpty()) {
                return;
            }
            ScheduleLinkOutput scheduleLinkOutput = (ScheduleLinkOutput)list.get(list.size() - 1);
            long l = scheduleLinkOutput.getFileEntryId();
            String string2 = "1" + l;
            String[] stringArray = null;
            JSONObject jSONObject = null;
            if (StringUtils.isNotBlank((String)string)) {
                jSONObject = new JSONObject();
                jSONObject.put("entryid", (Object)string2);
                jSONObject.put("filename", (Object)scheduledOutput.getBaseFileName());
            }
            if (StringUtils.isNotBlank((String)this.currentUserName)) {
                long l2 = UserControl.getInstance().getUser(this.currentUserName);
                boolean bl = UserControl.getInstance().hasEntryPrivilege(l2, 1, l);
                if (bl) {
                    stringArray = new String[]{this.currentUserName};
                    if (jSONObject != null) {
                        MobileMessagePushManager.getInstance().push((Message)new MobilePushMessage("", "", string, jSONObject), stringArray);
                    }
                }
            } else {
                stringArray = this.pushToAllUsers(string2, string, jSONObject);
            }
            if (stringArray != null) {
                this.saveUserEntryNeedUpdate(stringArray, string2 + "");
            }
        }
    }

    private String[] pushToAllUsers(String string, String string2, JSONObject jSONObject) throws Exception {
        FSSetAuthGetEntryUsersAction fSSetAuthGetEntryUsersAction = new FSSetAuthGetEntryUsersAction();
        JSONArray jSONArray = FSPrivilegeTools.getInstance().getEntryUsers(string);
        String[] stringArray = new String[jSONArray.length() + 1];
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            Long l = (Long)jSONArray.getJSONObject(i).get("id");
            stringArray[i] = UserControl.getInstance().getUser(l).getUsername();
        }
        if (stringArray.length > 0) {
            stringArray[stringArray.length - 1] = PrivilegeManager.getProviderInstance().getRootManagerName();
        }
        if (jSONObject != null) {
            MobileMessagePushManager.getInstance().push((Message)new MobilePushMessage("", "", string2, jSONObject), stringArray);
        }
        return stringArray;
    }

    private String getPushContent() throws Exception {
        FileActionList fileActionList = this.scheduleTask.getScheduledOutput().getOutputFileActionList();
        PushOutputFileAction pushOutputFileAction = fileActionList.getPushOutputFileAction();
        if (pushOutputFileAction != null) {
            String string = pushOutputFileAction.getContent();
            return pushOutputFileAction.dealWithParameter(string);
        }
        return "";
    }

    private String excuteSendMailByUserName(ScheduledOutput scheduledOutput, List list, File[] fileArray) throws Exception {
        EmailNotification emailNotification = scheduledOutput.getOutputFileActionList().getEmailNotification();
        String string = ConfigManager.getProviderInstance().getEmailManager().getAddress(this.currentUserName);
        if (StringUtils.isNotBlank((String)string)) {
            try {
                File[] fileArray2 = emailNotification.getFilesToDealWith(list.toArray(new File[list.size()]));
                emailNotification.doFileAction(fileArray2, string);
                DoFileActionJob.recordSuccess(this.scheduleTask, this.currentUserName);
            }
            catch (EmailException emailException) {
                this.log.error(emailException.getMessage());
                DoFileActionJob.recordError(this.scheduleTask, emailException, list, this.currentUserName);
            }
        }
        return fileArray[0].getAbsolutePath();
    }

    private void saveUserEntryNeedUpdate(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            UserEntryNotification userEntryNotification = new UserEntryNotification(string2, string);
            FSDAOManager.createSession().saveOrUpdate((Object)userEntryNotification);
        }
    }

    private void dealWithInfo(ScheduleTask scheduleTask, File[] fileArray, Map map, List list, String string) {
        String string2 = Inter.getLocText((String)"FS-Schedule-CPR_SUCCESS");
        if (scheduleTask.getCounts() > 0) {
            string2 = string2 + ScheduleLogUtils.combineByBrackets("RESTART", scheduleTask.getCounts());
        }
        if (StringUtils.isNotBlank((String)string)) {
            string2 = string2 + ScheduleLogUtils.combineByBrackets("User", string);
        }
        this.log.scheduleInfo(scheduleTask.getName(), string2);
        scheduleTask.setCounts(0);
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            this.viewScheduleSavedInfo.addMapTemplateFileName(map, fileArray[i].getName());
            if (fileArray[i].getName().endsWith(".cpr")) continue;
            list.add(fileArray[i]);
        }
    }

    @Override
    protected void dealWithException(Exception exception) {
        String string = Inter.getLocText((String)"FS-Schedule-CPR_FAILED");
        if (this.scheduleTask.getCounts() > 0) {
            string = string + ScheduleLogUtils.combineByBrackets("RESTART", this.scheduleTask.getCounts());
        }
        if (StringUtils.isNotBlank((String)this.currentUserName)) {
            string = string + ScheduleLogUtils.combineByBrackets("User", this.currentUserName);
        }
        this.log.scheduleError(this.scheduleTask.getName(), string, (Throwable)exception);
        this.restartTask();
        ScheduleLogUtils.error(exception);
    }

    private void writeUserCprXML(ScheduleUserAndCPRFile scheduleUserAndCPRFile) throws FileNotFoundException {
        BaseXMLUtils.writeXMLFile((OutputStream)new FileOutputStream(new File(this.saveDirectory, "usercpr.xml")), (XMLWriter)scheduleUserAndCPRFile);
    }

    private class ScheduleReportletRequestImpl
    implements ReportletRequest {
        private Map map = null;

        public ScheduleReportletRequestImpl(Map map) {
            this.map = map;
        }

        public Object getParameter(String string) {
            return this.map.get(string);
        }
    }
}

