/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.data.dao.DAOHashSet;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.DatabaseAction;
import com.fr.data.dao.RelationFCMapper;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.EntityDAOConstants;
import com.fr.fs.control.dao.DepartmentDAO;
import com.fr.fs.dao.PlatformDataAccessObject;
import com.fr.general.ComparatorUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class HSQLDepartmentDAO
extends PlatformDataAccessObject
implements DepartmentDAO {
    private static HSQLDepartmentDAO SC;

    public static HSQLDepartmentDAO getInstance() {
        if (SC == null) {
            SC = new HSQLDepartmentDAO();
        }
        return SC;
    }

    private HSQLDepartmentDAO() {
    }

    public void save(Department department) throws Exception {
        this.createSession().save((Object)department);
    }

    public void transfer(Department department) throws Exception {
        this.createSession(DatabaseAction.TRANSFER).transfer((Object)department);
    }

    public boolean delete(Department department) throws Exception {
        if (department == null) {
            return false;
        }
        return this.deleteByID(department.getId());
    }

    public boolean deleteByID(long l) throws Exception {
        if (l < 0L) {
            return false;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            dataAccessObjectSession.setForeignKeyChecks(0);
            boolean bl = dataAccessObjectSession.deleteByPrimaryKey(Department.class, l);
            dataAccessObjectSession.commit();
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            if (dataAccessObjectSession != null) {
                dataAccessObjectSession.setForeignKeyChecks(1);
            }
            this.closeSession(dataAccessObjectSession);
        }
    }

    public Department findByID(long l) throws Exception {
        return (Department)((Object)this.createSession().load(Department.class, l));
    }

    public List findAll() throws Exception {
        return this.createSession().list(Department.class);
    }

    public boolean updateDepartmentName(long l, String string) throws Exception {
        if (l < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", string);
        return this.createSession().update(Department.class, l, hashMap);
    }

    public boolean updateDepartment(Department department) throws Exception {
        if (department == null) {
            return false;
        }
        if (this.findByID(department.getId()) == null) {
            return false;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>(1);
        hashMap.put("id", department.getId());
        return this.createSession().updateByFields((Object)department, hashMap);
    }

    public Department findByNameAndPid(String string, long l) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", string);
        hashMap.put("pid", l);
        List list = this.createSession().listByFieldValues(Department.class, hashMap);
        if (!list.isEmpty()) {
            return (Department)((Object)list.get(0));
        }
        return null;
    }

    public Iterator getUserAndPostIterator(long l, boolean bl) throws Exception {
        if (l < 0L) {
            return null;
        }
        DAOHashSet dAOHashSet = new DAOHashSet(this.createSession(), (RelationFCMapper)EntityDAOConstants.DEPARTMENT.USER_POST_RELATION_MAPPER, Department.class, (Object)new Long(l));
        return dAOHashSet.iterator(bl);
    }

    public Department findDepartmentByName(String string) throws Exception {
        if (string == null) {
            return null;
        }
        List list = this.findAll();
        if (list == null) {
            return null;
        }
        for (Department department : list) {
            if (!ComparatorUtils.equals((String)string, (String)(department.getName() + department.getPid()))) continue;
            return department;
        }
        return null;
    }

    public Department findDepartmentByNameAndParentName(String string, String string2) throws Exception {
        List list = this.findAll();
        if (list == null) {
            return null;
        }
        for (Department department : list) {
            if (!ComparatorUtils.equals((String)string, (String)department.getName()) || !ComparatorUtils.equals((String)string2, (String)department.getParentName())) continue;
            return department;
        }
        return null;
    }
}

