/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.data.dao.DAOHashSet;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.DatabaseAction;
import com.fr.data.dao.OToMRelationFCMapper;
import com.fr.data.dao.RelationFCMapper;
import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.CustomRoleDataConnectionPrivilege;
import com.fr.fs.base.entity.CustomRoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.CustomRoleESPrivilege;
import com.fr.fs.base.entity.CustomRoleEntryPrivilege;
import com.fr.fs.base.entity.CustomRoleHomePagePrivilege;
import com.fr.fs.base.entity.CustomRoleModulePrivilege;
import com.fr.fs.base.entity.CustomRoleTemplatePrivilege;
import com.fr.fs.base.entity.EntityDAOConstants;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.CustomRoleCacheImpl;
import com.fr.fs.control.dao.CustomRoleDAO;
import com.fr.fs.control.dao.hsqldb.HSQLRoleDAO;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSQLCustomRoleDAO
extends HSQLRoleDAO
implements CustomRoleDAO {
    public static final String FIELD_ROLENAME = "rolename";
    private static HSQLCustomRoleDAO SC;

    public static HSQLCustomRoleDAO getInstance() {
        if (SC == null) {
            SC = new HSQLCustomRoleDAO();
        }
        return SC;
    }

    private HSQLCustomRoleDAO() {
    }

    @Override
    public void save(CustomRole customRole) throws Exception {
        this.createSession().save((Object)customRole);
    }

    @Override
    public boolean update(CustomRole customRole) throws Exception {
        if (customRole == null) {
            return false;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>(1);
        hashMap.put("id", customRole.getId());
        return this.createSession().updateByFields((Object)customRole, hashMap);
    }

    @Override
    public boolean resetSortIndex() throws Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(1);
        hashMap.put("sortindex", 0);
        return this.createSession().update(CustomRole.class, hashMap);
    }

    @Override
    public void transfer(CustomRole customRole) throws Exception {
        this.createSession(DatabaseAction.TRANSFER).transfer((Object)customRole);
    }

    @Override
    public boolean delete(CustomRole customRole) throws Exception {
        if (customRole == null) {
            return false;
        }
        return this.deleteByID(customRole.getId());
    }

    @Override
    public boolean deleteByID(long l) throws Exception {
        if (l < 0L) {
            return false;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            dataAccessObjectSession.setForeignKeyChecks(0);
            boolean bl = dataAccessObjectSession.deleteByPrimaryKey(CustomRole.class, l);
            dataAccessObjectSession.commit();
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            if (dataAccessObjectSession != null) {
                dataAccessObjectSession.setForeignKeyChecks(1);
            }
            this.closeSession(dataAccessObjectSession);
        }
    }

    @Override
    public CustomRole findByID(long l) throws Exception {
        return (CustomRole)((Object)this.createSession().load(CustomRole.class, l));
    }

    @Override
    public boolean updateRoleName(long l, String string) throws Exception {
        if (l < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FIELD_ROLENAME, string);
        return this.createSession().update(CustomRole.class, l, hashMap);
    }

    @Override
    public List findAll() throws Exception {
        return this.createSession().list(CustomRole.class);
    }

    @Override
    public CustomRole findByRoleName(String string) throws Exception {
        List list = this.createSession().listByFieldValue(CustomRole.class, FIELD_ROLENAME, (Object)string);
        if (!list.isEmpty()) {
            return (CustomRole)((Object)list.get(0));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserInRole(long l, long l2) {
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            boolean bl = dataAccessObjectSession.hasRelation((Object)new User(l), CustomRole.class, (Object)new Long(l2), EntityDAOConstants.CUSTOMROLECONSTANTS.RELATION_USER);
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
        return false;
    }

    @Override
    public Set getUserSet(long l, boolean bl) throws Exception {
        if (l < 0L) {
            return null;
        }
        DAOHashSet dAOHashSet = new DAOHashSet(this.createSession(), EntityDAOConstants.CUSTOMROLECONSTANTS.RELATION_USER, CustomRole.class, (Object)new Long(l));
        return dAOHashSet.toSet(bl);
    }

    public void addUsers(long l, Set set) throws Exception {
        this.addOrRemoveUsers(l, set, true, DatabaseAction.NORMAL);
    }

    @Override
    public void transferUsers(long l, Set<User> set) throws Exception {
        this.addOrRemoveUsers(l, set, true, DatabaseAction.TRANSFER);
    }

    public void removeUsers(long l, Set set) throws Exception {
        this.addOrRemoveUsers(l, set, false, DatabaseAction.NORMAL);
    }

    private void addOrRemoveUsers(long l, Set set, boolean bl, DatabaseAction databaseAction) throws Exception {
        if (l < 0L || set == null) {
            return;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession(databaseAction);
            dataAccessObjectSession.beginTransaction();
            CustomRole customRole = (CustomRole)((Object)dataAccessObjectSession.load(CustomRole.class, l));
            if (customRole == null) {
                throw new RuntimeException("The role don't exist!");
            }
            DAOHashSet dAOHashSet = new DAOHashSet(dataAccessObjectSession, EntityDAOConstants.CUSTOMROLECONSTANTS.RELATION_USER, CustomRole.class, (Object)new Long(l));
            if (bl) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    dAOHashSet.add(iterator.next());
                }
            } else {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    dAOHashSet.remove(iterator.next());
                }
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    @Override
    protected RelationFCMapper getEntryRelation() {
        return EntityDAOConstants.CUSTOMROLECONSTANTS.RELATION_ENTRY;
    }

    @Override
    protected RelationFCMapper getESRelation() {
        return new OToMRelationFCMapper("ESPrivileges", CustomRoleESPrivilege.class, "roleid");
    }

    @Override
    protected RelationFCMapper getDepAndCroleRelation() {
        return new OToMRelationFCMapper("depandcrolePrivileges", CustomRoleDepAndCRolePrivilege.class, "roleid");
    }

    @Override
    protected RelationFCMapper getModuleRelation() {
        return new OToMRelationFCMapper("modulePrivileges", CustomRoleModulePrivilege.class, "roleid");
    }

    @Override
    protected RelationFCMapper getHomePageRelation() {
        return new OToMRelationFCMapper("homePagePrivileges", CustomRoleHomePagePrivilege.class, "roleid");
    }

    @Override
    protected RelationFCMapper getTemplateRelation() {
        return new OToMRelationFCMapper("templatePrivileges", CustomRoleTemplatePrivilege.class, "roleId");
    }

    @Override
    protected RelationFCMapper getDataConnectionRelation() {
        return new OToMRelationFCMapper("dataConnectionPrivileges", CustomRoleDataConnectionPrivilege.class, "roleId");
    }

    @Override
    protected RelationFCMapper getRelationFCMapperWithPlateName(String string) {
        return PlateFactory.getRelationFCMapper4Custom(string);
    }

    @Override
    protected Class getRoleClass() {
        return CustomRole.class;
    }

    @Override
    protected Class getRoleEntryPrivilegeClass() {
        return CustomRoleEntryPrivilege.class;
    }

    @Override
    protected Class getRoleESPrivilegeClass() {
        return CustomRoleESPrivilege.class;
    }

    @Override
    protected Class getRoleDepAndCrolePrivilegeClass() {
        return CustomRoleDepAndCRolePrivilege.class;
    }

    @Override
    protected Class getRoleModulePrivilegeClass() {
        return CustomRoleModulePrivilege.class;
    }

    @Override
    protected Class getRoleHomePagePrivilegeClass() {
        return CustomRoleHomePagePrivilege.class;
    }

    @Override
    protected Class getRoleTemplatePrivilegeClass() {
        return CustomRoleTemplatePrivilege.class;
    }

    @Override
    protected Class getRoleDataConnectionPrivilegeClass() {
        return CustomRoleDataConnectionPrivilege.class;
    }

    @Override
    protected void cache4Sort(long l, int n, long l2, long l3) {
        CustomRoleCacheImpl.getInstance().refreshEntryPrivileges(l, n, l2, l3);
    }
}

