/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.Post;
import com.fr.fs.cache.PostCacheImpl;
import com.fr.fs.cache.UserCacheImpl;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostControl {
    private static PostControl pc;

    public static PostControl getInstance() {
        if (pc == null) {
            pc = new PostControl();
        }
        return pc;
    }

    public Post getPost(long l) throws Exception {
        return PostCacheImpl.getInstance().getPost(l);
    }

    public Post getPostByName(String string) throws Exception {
        return PostCacheImpl.getInstance().getPostByName(string);
    }

    public String getPostName(long l) throws Exception {
        return PostCacheImpl.getInstance().getPostName(l);
    }

    public List getAllPost(boolean bl) throws Exception {
        List list = PostCacheImpl.getInstance().getAllPost();
        if (!bl && list != null) {
            list.remove((Object)new Post(CompanyRoleControl.getInstance().getPostAllID()));
        }
        return list;
    }

    public JSONArray getAllPostInfo(boolean bl) throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = this.getAllPost(bl);
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Post post = (Post)((Object)list.get(i));
                JSONObject jSONObject = post.createJSONConfig();
                jSONObject.put("value", (Object)post.createJSONConfig());
                jSONArray.put((Object)jSONObject);
            }
        }
        return jSONArray;
    }

    public boolean addPost(Post post) throws Exception {
        if (post == null) {
            return false;
        }
        post.setId(-1L);
        FSConfig.getProviderInstance().getControl().getPostDAO().save(post);
        try {
            PostCacheImpl.getInstance().cache(post);
        }
        catch (Exception exception) {
            PostCacheImpl.getInstance().reInit();
        }
        return post.getId() >= 0L;
    }

    public boolean addPostWithID(Post post) throws Exception {
        if (post == null) {
            return false;
        }
        FSConfig.getProviderInstance().getControl().getPostDAO().save(post);
        try {
            PostCacheImpl.getInstance().cache(post);
        }
        catch (Exception exception) {
            PostCacheImpl.getInstance().reInit();
        }
        return post.getId() >= 0L;
    }

    public boolean deletePost(long l) throws Exception {
        boolean bl = FSConfig.getProviderInstance().getControl().getPostDAO().deleteByID(l);
        if (bl) {
            try {
                PostCacheImpl.getInstance().removeCache(l);
            }
            catch (Exception exception) {
                PostCacheImpl.getInstance().reInit();
            }
            try {
                UserCacheImpl.getInstance().refreshAfterDelPost(l);
            }
            catch (Exception exception) {
                UserCacheImpl.getInstance().removeAllCache();
            }
        }
        return bl;
    }

    public boolean updatePost(Post post) throws Exception {
        if (FSConfig.getProviderInstance().getControl().getPostDAO().update(post)) {
            try {
                PostCacheImpl.getInstance().cacheNewName(post.getId(), post.getPostname());
            }
            catch (Exception exception) {
                PostCacheImpl.getInstance().reInit();
            }
            return true;
        }
        return false;
    }

    public List<Post> getAllPost() throws Exception {
        return FSConfig.getProviderInstance().getControl().getPostDAO().findAll();
    }
}

