/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.cluster.rpc.RPC;
import com.fr.data.dao.RelationObject;
import com.fr.file.BaseClusterHelper;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.CustomRoleCache;
import com.fr.fs.cache.CustomRoleCacheProvider;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.general.GeneralContext;
import com.fr.json.JSONException;
import com.fr.stable.EnvChangedListener;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomRoleCacheImpl
implements CustomRoleCacheProvider {
    private static CustomRoleCacheProvider customRoleCacheProvider;

    public static CustomRoleCacheProvider getInstance() {
        if (customRoleCacheProvider == null) {
            CustomRoleCacheImpl.initCacheImpl();
        }
        return customRoleCacheProvider;
    }

    private static synchronized void initCacheImpl() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                customRoleCacheProvider = new CustomRoleCacheImpl();
                RPC.registerSkeleton((Object)customRoleCacheProvider);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                customRoleCacheProvider = (CustomRoleCacheProvider)RPC.getProxy(CustomRoleCacheImpl.class, (String)string);
                break;
            }
            default: {
                customRoleCacheProvider = new CustomRoleCacheImpl();
            }
        }
    }

    @Override
    public boolean containCache(long l) {
        return CustomRoleCache.containCache(l);
    }

    @Override
    public void initCache() throws Exception {
        CustomRoleCache.initCache();
    }

    @Override
    public void cacheNew(CustomRole customRole) throws Exception {
        CustomRoleCache.cacheNew(customRole);
    }

    @Override
    public void cacheUpdate(CustomRole customRole) throws Exception {
        CustomRoleCache.cacheUpdate(customRole);
    }

    @Override
    public String getSRoleName(long l) {
        return CustomRoleCache.getSRoleName(l);
    }

    @Override
    public void reInitCache() throws Exception {
        CustomRoleCache.reInitCache();
    }

    @Override
    public void clearCache() {
        CustomRoleCache.clearCache();
    }

    @Override
    public void removeCache(long l) {
        CustomRoleCache.removeCache(l);
    }

    @Override
    public List<EntryTypeAndID> getAllEntryPrivileges(long l) {
        return CustomRoleCache.getAllEntryPrivileges(l);
    }

    @Override
    public Set<RoleDataConnectionPrivilege> getAllDataConnectionPrivileges(long l) {
        return CustomRoleCache.getAllDataConnectionPrivileges(l);
    }

    @Override
    public List<RoleTemplatePrivilege> getAllTemplatePrivileges(long l) {
        return CustomRoleCache.getAllTemplatePrivileges(l);
    }

    @Override
    public List<String> getAllDepAndCRolePrivilegeDescriptions(long l) {
        return CustomRoleCache.getAllDepAndCRolePrivilegeDescriptions(l);
    }

    @Override
    public List<RoleDepAndCRolePrivilege> getAllDepAndCRolePrivileges(long l) {
        return CustomRoleCache.getAllDepAndCRolePrivileges(l);
    }

    @Override
    public List getAllDepAndCRolePrivileges(long l, boolean bl) throws JSONException {
        return CustomRoleCache.getAllDepAndCRolePrivileges(l, bl);
    }

    @Override
    public List<String> getAllESPrivilegeDescriptions(long l) {
        return CustomRoleCache.getAllESPrivilegeDescriptions(l);
    }

    @Override
    public List<RoleModulePrivilege> getAllModulePrivileges(long l) {
        return CustomRoleCache.getAllModulePrivileges(l);
    }

    @Override
    public List<RoleHomePagePrivilege> getAllHomePagePrivileges(long l) {
        return CustomRoleCache.getAllHomePagePrivileges(l);
    }

    @Override
    public List<String> getAllPrivilegesWithPlateName(long l, String string) {
        return CustomRoleCache.getAllPrivilegesWithPlateName(l, string);
    }

    @Override
    public List<CustomRole> getAllCustomRole() {
        return CustomRoleCache.getAllCustomRole();
    }

    @Override
    public void refreshCustomRoleName(long l, String string) {
        CustomRoleCache.refreshCustomRoleName(l, string);
    }

    @Override
    public void refreshModulePrivileges(long l, Set<RoleModulePrivilege> set) {
        CustomRoleCache.refreshModulePrivileges(l, set);
    }

    @Override
    public void refreshModulePrivileges(String string, Set<RoleModulePrivilege> set) {
        CustomRoleCache.refreshModulePrivileges(string, set);
    }

    @Override
    public void refreshHomePagePrivileges(long l, Set<RoleHomePagePrivilege> set) {
        CustomRoleCache.refreshHomePagePrivileges(l, set);
    }

    @Override
    public void refreshHomePagePrivileges(String string, Set<RoleHomePagePrivilege> set) {
        CustomRoleCache.refreshHomePagePrivileges(string, set);
    }

    @Override
    public void refreshPrivilegesWithPlateName(long l, Set<RelationObject> set, String string) {
        CustomRoleCache.refreshPrivilegesWithPlateName(l, set, string);
    }

    @Override
    public void refreshEntryPrivileges(long l, Set<RoleEntryPrivilege> set) {
        CustomRoleCache.refreshEntryPrivileges(l, set);
    }

    @Override
    public void refreshEntryPrivileges(String string, Set<RoleEntryPrivilege> set) {
        CustomRoleCache.refreshEntryPrivileges(string, set);
    }

    @Override
    public void refreshTemplatePrivileges(long l, Set<RoleTemplatePrivilege> set) {
        CustomRoleCache.refreshTemplatePrivileges(l, set);
    }

    @Override
    public void refreshTemplatePrivileges(String string, Set<RoleTemplatePrivilege> set) {
        CustomRoleCache.refreshTemplatePrivileges(string, set);
    }

    @Override
    public void refreshDepAndCRolePrivileges(long l, Set<RoleDepAndCRolePrivilege> set) {
        CustomRoleCache.refreshDepAndCRolePrivileges(l, set);
    }

    @Override
    public void refreshDepAndCRolePrivileges(String string, Set<RoleDepAndCRolePrivilege> set) {
        CustomRoleCache.refreshDepAndCRolePrivileges(string, set);
    }

    @Override
    public void refreshDataConnectionPrivileges(long l, Set<RoleDataConnectionPrivilege> set) {
        CustomRoleCache.refreshDataConnectionPrivileges(l, set);
    }

    @Override
    public void refreshDataConnectionPrivileges(String string, Set<RoleDataConnectionPrivilege> set) {
        CustomRoleCache.refreshDataConnectionPrivileges(string, set);
    }

    @Override
    public void refreshESPrivileges(long l, Set<RoleESPrivilege> set) {
        CustomRoleCache.refreshESPrivileges(l, set);
    }

    @Override
    public boolean containModulePrivilege(long l, long l2) {
        return CustomRoleCache.containModulePrivilege(l, l2);
    }

    @Override
    public boolean containHomePagePrivilege(long l, long l2) {
        return CustomRoleCache.containHomePagePrivilege(l, l2);
    }

    @Override
    public boolean containPlatePrivilege(long l, long l2, String string) {
        return CustomRoleCache.containPlatePrivilege(l, l2, string);
    }

    @Override
    public boolean containEntryPrivilege(long l, int n, long l2) {
        return CustomRoleCache.containEntryPrivilege(l, n, l2);
    }

    @Override
    public void refreshEntryPrivileges(long l, int n, long l2, long l3) {
        CustomRoleCache.refreshEntryPrivileges(l, n, l2, l3);
    }

    @Override
    public void resetSortIndex() {
        CustomRoleCache.resetSortIndex();
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                CustomRoleCacheImpl.customRoleCacheProvider = null;
            }
        });
    }
}

