/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.fs.evt.EarlyVerifyListener;
import com.fr.fs.evt.PasswordModifyListener;
import java.util.ArrayList;
import java.util.List;

public class FSMonitor {
    private static FSMonitor instance = null;
    private List<PasswordModifyListener> passwordModifyListeners = null;
    private List<EarlyVerifyListener> earlyVerifyListeners = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSMonitor getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<FSMonitor> clazz = FSMonitor.class;
        synchronized (FSMonitor.class) {
            if (instance == null) {
                instance = new FSMonitor();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private FSMonitor() {
    }

    public void addPasswordModifyListener(PasswordModifyListener passwordModifyListener) {
        if (this.passwordModifyListeners == null) {
            this.passwordModifyListeners = new ArrayList<PasswordModifyListener>();
        }
        this.passwordModifyListeners.add(passwordModifyListener);
    }

    public void firePasswordModify(String string, String string2, String string3) {
        if (this.passwordModifyListeners == null) {
            return;
        }
        for (PasswordModifyListener passwordModifyListener : this.passwordModifyListeners) {
            passwordModifyListener.modify(string, string2, string3);
        }
    }

    public void addEarlyVerifyListener(EarlyVerifyListener earlyVerifyListener) {
        if (this.earlyVerifyListeners == null) {
            this.earlyVerifyListeners = new ArrayList<EarlyVerifyListener>();
        }
        this.earlyVerifyListeners.add(earlyVerifyListener);
    }

    public boolean doEarlyVerify(String string, String string2, boolean bl) {
        if (this.earlyVerifyListeners == null) {
            return true;
        }
        for (EarlyVerifyListener earlyVerifyListener : this.earlyVerifyListeners) {
            if (earlyVerifyListener.verify(string, string2, bl)) continue;
            return false;
        }
        return true;
    }
}

