/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.data.load.LazyExecutionJob;
import com.fr.data.load.LazyExecutionManager;
import com.fr.fs.FSBridge;
import com.fr.fs.FSConfig;
import com.fr.fs.FSContext;
import com.fr.fs.PlateFactory;
import com.fr.fs.fun.PlateProvider;
import com.fr.fs.plugin.ExtraPlatformClassManager;
import com.fr.fs.privilege.base.AuthErrorHandler;
import com.fr.fs.privilege.base.AuthTimeoutHandler;
import com.fr.fs.privilege.base.EncryptSignInHandler;
import com.fr.fs.privilege.base.RoleErrorHandler;
import com.fr.fs.web.service.EmailService;
import com.fr.fs.web.service.FSEntryService;
import com.fr.fs.web.service.FSLoadService;
import com.fr.fs.web.service.FSMainService;
import com.fr.fs.web.service.FSManagerService;
import com.fr.fs.web.service.FSOpenEntryService;
import com.fr.fs.web.service.FSSetService;
import com.fr.fs.web.service.FSSystemExamineService;
import com.fr.fs.web.service.LoginOutService;
import com.fr.fs.web.service.PlatFormTouchService;
import com.fr.fs.web.service.PlatformEntryService;
import com.fr.fs.web.service.ProductImprovementService;
import com.fr.fs.web.service.ServerConfigService;
import com.fr.plugin.PluginLoader;
import com.fr.privilege.PrivilegeHandler;
import com.fr.privilege.PrivilegeHandlerFactory;
import com.fr.report.module.EngineModule;
import com.fr.stable.ArrayUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.bridge.event.StableFactoryProducer;
import com.fr.stable.bridge.event.StableFactoryResourceType;
import com.fr.stable.fun.JavaScriptFileHandler;
import com.fr.stable.fun.Service;
import com.fr.stable.plugin.event.AutoRegisterPluginActiveListener;
import com.fr.stable.plugin.event.PluginActiveListener;
import com.fr.stable.plugin.event.PluginChangeEvent;
import com.fr.stable.plugin.event.PluginChangeTransponder;
import com.fr.write.ProcessProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSModule
extends EngineModule {
    private PluginActiveListener pluginActiveListener;

    public Service[] service4Register() {
        return (Service[])ArrayUtils.addAll((Object[])super.service4Register(), (Object[])new Service[]{new FSOpenEntryService(), new FSEntryService(), new FSMainService(), new FSSetService(), new FSManagerService(), new FSSystemExamineService(), new FSLoadService(), new PlatformEntryService(), new PlatFormTouchService(), new EmailService(), new ServerConfigService(), new LoginOutService(), new ProductImprovementService()});
    }

    public String[] filterParameters4BaseSession() {
        return new String[]{"fr_fs_auth_key"};
    }

    public void startFinish() {
        super.startFinish();
        this.registerPlateJsAndCss();
        StableFactory.registerMarkedObject((String)"PlatformProvider", (Object)FSBridge.getInstance());
        StableFactory.registerMarkedClass((String)"ExtraPlatformClassManagerProvider", ExtraPlatformClassManager.class);
        PluginLoader.getLoader().readPluginsWaitForRead();
        this.registerExtraJS();
        this.init();
    }

    private void registerExtraJS() {
        this.registerStableFactoryProducer(new StableFactoryProducer(){

            public void reInject(StableFactoryResourceType stableFactoryResourceType) {
                StableFactory.registerJavaScriptFiles((String)"finereport.fs.js", (String[])FSModule.this.getFSJavaScriptFiles4WebClient());
            }
        }, new StableFactoryResourceType[]{StableFactoryResourceType.TYPE_JS});
        StableFactory.registerJavaScriptFiles((String)"finereport.fs.js", (String[])this.getExtraJavaScriptFiles());
    }

    private void registerPlateJsAndCss() {
        this.registerStableFactoryProducer(new StableFactoryProducer(){

            public void reInject(StableFactoryResourceType stableFactoryResourceType) {
                if (StableFactoryResourceType.TYPE_JS.equals((Object)stableFactoryResourceType)) {
                    StableFactory.registerJavaScriptFiles((String)"finereport.fs.js", (String[])FSModule.this.getFSJavaScriptFiles4WebClient());
                } else if (StableFactoryResourceType.TYPE_CSS.equals((Object)stableFactoryResourceType)) {
                    StableFactory.registerStyleFiles((String)"finereport.fs.css", (String[])FSModule.this.getFSCssFiles4WebClient());
                }
            }
        }, new StableFactoryResourceType[]{StableFactoryResourceType.TYPE_JS, StableFactoryResourceType.TYPE_CSS});
        StableFactory.registerJavaScriptFiles((String)"finereport.fs.js", (String[])this.getFSJavaScriptFiles4WebClient());
        StableFactory.registerStyleFiles((String)"finereport.fs.css", (String[])this.getFSCssFiles4WebClient());
    }

    private void init() {
        this.registerAndStartPlate();
        if (FSContext.isUseFS()) {
            FSContext.initData();
        }
        this.registerPrivilegeHandler();
        ProcessProvider processProvider = (ProcessProvider)StableFactory.getMarkedInstanceObjectFromClass((String)"processBridge", ProcessProvider.class);
        if (processProvider != null) {
            LazyExecutionManager.addJob((LazyExecutionJob)processProvider);
        }
        FSConfig.getProviderInstance().transferDeviceInfo();
    }

    private String[] getFSJavaScriptFiles4WebClient() {
        return new String[]{"/com/fr/fs/web/frame/fs.base.js", "/com/fr/fs/web/frame/fs.bridge.js", "/com/fr/fs/web/frame/fs.realize.js", "/com/fr/fs/web/js/third/slimscroll.js", "/com/fr/fs/web/js/fstools.js", "/com/fr/fs/web/frame/fs.frame.js", "/com/fr/fs/web/frame/fs.tabpane.js", "/com/fr/fs/web/js/widget/fs_widget.js", "/com/fr/fs/web/js/widget/fs.tabletree.js", "/com/fr/fs/web/frame/fs.menutree.js"};
    }

    private String[] getExtraJavaScriptFiles() {
        Set set = ExtraPlatformClassManager.getInstance().getArray("JavaScriptFileHandler");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (JavaScriptFileHandler javaScriptFileHandler : set) {
            linkedHashSet.addAll(Arrays.asList(javaScriptFileHandler.pathsForFiles()));
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private String[] getFSCssFiles4WebClient() {
        return new String[]{"/com/fr/fs/web/css/fs.all.css", "/com/fr/fs/web/css/fs.widget.css"};
    }

    private void registerAndStartPlate() {
        this.pluginActiveListener = new AutoRegisterPluginActiveListener(){

            protected AutoRegisterPluginActiveListener.RegisterInfo registerInfo() {
                return new AutoRegisterPluginActiveListener.RegisterInterface(new String[]{"PlateProvider"});
            }

            public void pluginActiveStateChanged(PluginChangeEvent pluginChangeEvent) {
                PlateFactory.stopPlates();
                FSModule.this.startPlate();
            }

            public int priority() {
                return 20001;
            }
        };
        this.startPlate();
    }

    private void startPlate() {
        Map<String, String> map = this.platesForStart();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            PlateFactory.startPlate(string, string2);
        }
        FSContext.fireAllPlateStartFinish();
    }

    private void registerPrivilegeHandler() {
        PrivilegeHandlerFactory.registerAuthErrorHandler((PrivilegeHandler)AuthErrorHandler.getInstance());
        PrivilegeHandlerFactory.registerRoleErrorHandler((PrivilegeHandler)RoleErrorHandler.getInstance());
        PrivilegeHandlerFactory.registerAuthTimeoutHandler((PrivilegeHandler)AuthTimeoutHandler.getInstance());
        PrivilegeHandlerFactory.registerEncryptSignInHandler((PrivilegeHandler)EncryptSignInHandler.getInstance());
    }

    public String[] getLocaleFile() {
        Object[] objectArray = super.getLocaleFile();
        return (String[])ArrayUtils.add((Object[])objectArray, (Object)"com/fr/fs/locale/fs");
    }

    private Map<String, String> platesForStart() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Set set = ExtraPlatformClassManager.getInstance().getArray("PlateProvider");
        ArrayList<PlateProvider> arrayList = new ArrayList<PlateProvider>();
        for (PlateProvider plateProvider : set) {
            if (plateProvider.isAppendToLast()) {
                arrayList.add(plateProvider);
                continue;
            }
            linkedHashMap.put(plateProvider.mark(), plateProvider.classForPlate().getName());
        }
        linkedHashMap.put("schedule", "com.fr.schedule.SchedulePlate");
        linkedHashMap.put("mobile", "com.fr.mobile.FMobilePlate");
        linkedHashMap.put("reportprocess", "com.fr.fs.process.ReportProcessPlate");
        linkedHashMap.put("monitor", "com.fr.fs.systemmonitor.SystemMonitorPlate");
        linkedHashMap.put("fsconfigprocess", "com.fr.fs.process.FSConfigBackupRestoreProcessPlate");
        linkedHashMap.put("pluginoperate", "com.fr.fs.plugin.op.PluginOperatePlate");
        linkedHashMap.put("customstyle", "com.fr.fs.plugin.customstyle.CustomStylePlate");
        linkedHashMap.put("preventsqlinject", "com.fr.fs.process.FSPreventSqlInjectPlate");
        linkedHashMap.put("bi", "com.fr.bi.BIPlate");
        for (PlateProvider plateProvider : arrayList) {
            linkedHashMap.put(plateProvider.mark(), plateProvider.classForPlate().getName());
        }
        return linkedHashMap;
    }

    public void stop() {
        super.stop();
        PluginChangeTransponder.getInstance().removeListener(this.pluginActiveListener);
    }
}

