/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearShape2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.point.PointArray2D;
import math.geom2d.point.PointSet2D;
import math.geom2d.point.PointShape2D;
import math.geom2d.transform.CircleInversion2D;
import math.utils.EqualUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Point2D
implements GeometricObject2D,
PointShape2D,
Cloneable,
CirculinearShape2D {
    protected double x;
    protected double y;

    @Deprecated
    public static Point2D create(double x, double y) {
        return new Point2D(x, y);
    }

    @Deprecated
    public static Point2D create(java.awt.geom.Point2D point) {
        return new Point2D(point.getX(), point.getY());
    }

    public static Point2D create(Point2D point) {
        return new Point2D(point.x, point.y);
    }

    public static Point2D createPolar(double rho, double theta) {
        return new Point2D(rho * Math.cos(theta), rho * Math.sin(theta));
    }

    public static Point2D createPolar(Point2D point, double rho, double theta) {
        return new Point2D(point.x + rho * Math.cos(theta), point.y + rho * Math.sin(theta));
    }

    public static Point2D createPolar(double x0, double y0, double rho, double theta) {
        return new Point2D(x0 + rho * Math.cos(theta), y0 + rho * Math.sin(theta));
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.hypot(x2 - x1, y2 - y1);
    }

    public static double distance(Point2D p1, Point2D p2) {
        return Math.hypot(p1.x - p2.x, p1.y - p2.y);
    }

    public static boolean isColinear(Point2D p1, Point2D p2, Point2D p3) {
        double dx1 = p2.x - p1.x;
        double dy2 = p3.y - p1.y;
        double dy1 = p2.y - p1.y;
        double dx2 = p3.x - p1.x;
        return Math.abs(dx1 * dy2 - dy1 * dx2) < 1.0E-12;
    }

    public static int ccw(Point2D p0, Point2D p1, Point2D p2) {
        double x0 = p0.x;
        double dx1 = p1.x - x0;
        double y0 = p0.y;
        double dy2 = p2.y - y0;
        double dy1 = p1.y - y0;
        double dx2 = p2.x - x0;
        if (dx1 * dy2 > dy1 * dx2) {
            return 1;
        }
        if (dx1 * dy2 < dy1 * dx2) {
            return -1;
        }
        if (dx1 * dx2 < 0.0 || dy1 * dy2 < 0.0) {
            return -1;
        }
        if (Math.hypot(dx1, dy1) < Math.hypot(dx2, dy2)) {
            return 1;
        }
        return 0;
    }

    public static Point2D midPoint(Point2D p1, Point2D p2) {
        return new Point2D((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0);
    }

    public static Point2D centroid(Point2D[] points) {
        int n = points.length;
        double sx = 0.0;
        double sy = 0.0;
        int i = 0;
        while (i < n) {
            sx += points[i].x;
            sy += points[i].y;
            ++i;
        }
        return new Point2D(sx / (double)n, sy / (double)n);
    }

    public static Point2D centroid(Point2D[] points, double[] weights) {
        int n = points.length;
        if (n != weights.length) {
            throw new RuntimeException("Arrays must have the same size");
        }
        double sx = 0.0;
        double sy = 0.0;
        double sw = 0.0;
        int i = 0;
        while (i < n) {
            double w = weights[i];
            sx += points[i].x * w;
            sy += points[i].y * w;
            sw += w;
            ++i;
        }
        return new Point2D(sx / sw, sy / sw);
    }

    public static Point2D centroid(Collection<? extends Point2D> points) {
        int n = points.size();
        double sx = 0.0;
        double sy = 0.0;
        for (Point2D point2D : points) {
            sx += point2D.x;
            sy += point2D.y;
        }
        return new Point2D(sx / (double)n, sy / (double)n);
    }

    public static Point2D centroid(Point2D pt1, Point2D pt2, Point2D pt3) {
        return new Point2D((pt1.x + pt2.x + pt3.x) / 3.0, (pt1.y + pt2.y + pt3.y) / 3.0);
    }

    public Point2D() {
    }

    public Point2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point2D(java.awt.geom.Point2D point) {
        this(point.getX(), point.getY());
    }

    public Point2D(Point2D point) {
        this(point.x, point.y);
    }

    public Point2D plus(Point2D p) {
        return new Point2D(this.x + p.x, this.y + p.y);
    }

    public Point2D plus(Vector2D v) {
        return new Point2D(this.x + v.x, this.y + v.y);
    }

    public Point2D minus(Point2D p) {
        return new Point2D(this.x - p.x, this.y - p.y);
    }

    public Point2D minus(Vector2D v) {
        return new Point2D(this.x - v.x, this.y - v.y);
    }

    public Point2D translate(double tx, double ty) {
        return new Point2D(this.x + tx, this.y + ty);
    }

    public Point2D scale(double kx, double ky) {
        return new Point2D(this.x * kx, this.y * ky);
    }

    public Point2D scale(double k) {
        return new Point2D(this.x * k, this.y * k);
    }

    public Point2D rotate(double theta) {
        double cot = Math.cos(theta);
        double sit = Math.sin(theta);
        return new Point2D(this.x * cot - this.y * sit, this.x * sit + this.y * cot);
    }

    public Point2D rotate(Point2D center, double theta) {
        double cx = center.x;
        double cy = center.y;
        double cot = Math.cos(theta);
        double sit = Math.sin(theta);
        return new Point2D(this.x * cot - this.y * sit + (1.0 - cot) * cx + sit * cy, this.x * sit + this.y * cot + (1.0 - cot) * cy - sit * cx);
    }

    public Point getAsInt() {
        return new Point((int)this.x, (int)this.y);
    }

    public Point2D.Double getAsDouble() {
        return new Point2D.Double(this.x, this.y);
    }

    public Point2D.Float getAsFloat() {
        return new Point2D.Float((float)this.x, (float)this.y);
    }

    public double x() {
        return this.x;
    }

    @Deprecated
    public double getX() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    @Deprecated
    public double getY() {
        return this.y;
    }

    @Override
    public CirculinearDomain2D buffer(double dist) {
        return new GenericCirculinearDomain2D(new Circle2D(this, Math.abs(dist), dist > 0.0));
    }

    @Override
    public Point2D transform(CircleInversion2D inv) {
        Point2D center = inv.center();
        double r = inv.radius();
        double d = r * r / Point2D.distance(this, center);
        double theta = Angle2D.horizontalAngle(center, this);
        return Point2D.createPolar(center, d, theta);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Collection<Point2D> points() {
        ArrayList<Point2D> array = new ArrayList<Point2D>(1);
        array.add(this);
        return array;
    }

    @Override
    public double distance(Point2D point) {
        return this.distance(point.x, point.y);
    }

    @Override
    public double distance(double x, double y) {
        return Math.hypot(this.x - x, this.y - y);
    }

    @Override
    public boolean isBounded() {
        if (Double.isInfinite(this.x)) {
            return false;
        }
        if (Double.isInfinite(this.y)) {
            return false;
        }
        if (Double.isNaN(this.x)) {
            return false;
        }
        return !Double.isNaN(this.y);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.equals(new Point2D(x, y));
    }

    @Override
    public boolean contains(Point2D p) {
        return this.equals(p);
    }

    @Override
    public PointSet2D clip(Box2D box) {
        PointArray2D set = new PointArray2D(0);
        if (this.x < box.getMinX()) {
            return set;
        }
        if (this.y < box.getMinY()) {
            return set;
        }
        if (this.x > box.getMaxX()) {
            return set;
        }
        if (this.y > box.getMaxY()) {
            return set;
        }
        set.add(this);
        return set;
    }

    @Override
    public Box2D boundingBox() {
        return new Box2D(this.x, this.x, this.y, this.y);
    }

    @Override
    public Point2D transform(AffineTransform2D trans) {
        double[] tab = trans.coefficients();
        return new Point2D(this.x * tab[0] + this.y * tab[1] + tab[2], this.x * tab[3] + this.y * tab[4] + tab[5]);
    }

    @Override
    public void draw(Graphics2D g2) {
        this.draw(g2, 1.0);
    }

    public void draw(Graphics2D g2, double r) {
        g2.fill(new Ellipse2D.Double(this.x - r, this.y - r, 2.0 * r, 2.0 * r));
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Point2D)) {
            return false;
        }
        Point2D p = (Point2D)obj;
        if (Math.abs(this.x - p.x) > eps) {
            return false;
        }
        return !(Math.abs(this.y - p.y) > eps);
    }

    @Override
    public Iterator<Point2D> iterator() {
        return this.points().iterator();
    }

    public String toString() {
        return new String("Point2D(" + this.x + ", " + this.y + ")");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Point2D)) {
            return false;
        }
        Point2D that = (Point2D)obj;
        if (!EqualUtils.areEqual(this.x, that.x)) {
            return false;
        }
        return EqualUtils.areEqual(this.y, that.y);
    }

    public Point2D clone() {
        return new Point2D(this.x, this.y);
    }
}

