/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PSSParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.misc.CAST5CBCParameters;
import org.bouncycastle.asn1.oiw.ElGamalParameter;
import org.bouncycastle.asn1.pkcs.DHParameter;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.RC2CBCParameter;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.bouncycastle.jce.spec.GOST3410ParameterSpec;
import org.bouncycastle.jce.spec.IESParameterSpec;

public abstract class JDKAlgorithmParameters
extends AlgorithmParametersSpi {
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$RC2ParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$PBEParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$DHParameterSpec;
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;
    static /* synthetic */ Class class$org$bouncycastle$jce$spec$GOST3410PublicKeyParameterSetSpec;
    static /* synthetic */ Class class$org$bouncycastle$jce$spec$ElGamalParameterSpec;
    static /* synthetic */ Class class$org$bouncycastle$jce$spec$IESParameterSpec;
    static /* synthetic */ Class class$java$security$spec$PSSParameterSpec;

    protected boolean isASN1FormatString(String format) {
        return format == null || format.equals("ASN.1");
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == null) {
            throw new NullPointerException("argument to getParameterSpec must not be null");
        }
        return this.localEngineGetParameterSpec(paramSpec);
    }

    protected abstract AlgorithmParameterSpec localEngineGetParameterSpec(Class var1) throws InvalidParameterSpecException;

    public static class PBKDF2
    extends JDKAlgorithmParameters {
        PBKDF2Params params;

        protected byte[] engineGetEncoded() {
            try {
                return this.params.getEncoded("DER");
            }
            catch (IOException e) {
                throw new RuntimeException("Oooops! " + e.toString());
            }
        }

        protected byte[] engineGetEncoded(String format) {
            if (this.isASN1FormatString(format)) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == (class$javax$crypto$spec$PBEParameterSpec == null ? (class$javax$crypto$spec$PBEParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.PBEParameterSpec")) : class$javax$crypto$spec$PBEParameterSpec)) {
                return new PBEParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue());
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to PKCS12 PBE parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PKCS12 PBE parameters algorithm parameters object");
            }
            PBEParameterSpec pbeSpec = (PBEParameterSpec)paramSpec;
            this.params = new PBKDF2Params(pbeSpec.getSalt(), pbeSpec.getIterationCount());
        }

        protected void engineInit(byte[] params) throws IOException {
            this.params = PBKDF2Params.getInstance(ASN1Object.fromByteArray(params));
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                this.engineInit(params);
                return;
            }
            throw new IOException("Unknown parameters format in PWRIKEK parameters object");
        }

        protected String engineToString() {
            return "PBKDF2 Parameters";
        }
    }

    public static class PSS
    extends JDKAlgorithmParameters {
        PSSParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            PSSParameterSpec pssSpec = this.currentSpec;
            RSASSAPSSparams pssP = new RSASSAPSSparams(RSASSAPSSparams.DEFAULT_HASH_ALGORITHM, RSASSAPSSparams.DEFAULT_MASK_GEN_FUNCTION, new DERInteger(pssSpec.getSaltLength()), RSASSAPSSparams.DEFAULT_TRAILER_FIELD);
            try {
                dOut.writeObject(pssP);
                dOut.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error encoding PSSParameters");
            }
            return bOut.toByteArray();
        }

        protected byte[] engineGetEncoded(String format) {
            if (format.equalsIgnoreCase("X.509") || format.equalsIgnoreCase("ASN.1")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == (class$java$security$spec$PSSParameterSpec == null ? (class$java$security$spec$PSSParameterSpec = JDKAlgorithmParameters.class$("java.security.spec.PSSParameterSpec")) : class$java$security$spec$PSSParameterSpec) && this.currentSpec instanceof PSSParameterSpec) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to PSS parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof PSSParameterSpec)) {
                throw new InvalidParameterSpecException("PSSParameterSpec required to initialise an PSS algorithm parameters object");
            }
            this.currentSpec = (PSSParameterSpec)paramSpec;
        }

        protected void engineInit(byte[] params) throws IOException {
            ASN1InputStream aIn = new ASN1InputStream(params);
            try {
                RSASSAPSSparams pssP = new RSASSAPSSparams((ASN1Sequence)aIn.readObject());
                this.currentSpec = new PSSParameterSpec(pssP.getSaltLength().getValue().intValue());
            }
            catch (ClassCastException e) {
                throw new IOException("Not a valid PSS Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Not a valid PSS Parameter encoding.");
            }
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (!format.equalsIgnoreCase("X.509") && !format.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown parameter format " + format);
            }
            this.engineInit(params);
        }

        protected String engineToString() {
            return "PSS Parameters";
        }
    }

    public static class IES
    extends JDKAlgorithmParameters {
        IESParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            try {
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add(new DEROctetString(this.currentSpec.getDerivationV()));
                v.add(new DEROctetString(this.currentSpec.getEncodingV()));
                v.add(new DERInteger(this.currentSpec.getMacKeySize()));
                dOut.writeObject(new DERSequence(v));
                dOut.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error encoding IESParameters");
            }
            return bOut.toByteArray();
        }

        protected byte[] engineGetEncoded(String format) {
            if (this.isASN1FormatString(format) || format.equalsIgnoreCase("X.509")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == (class$org$bouncycastle$jce$spec$IESParameterSpec == null ? (class$org$bouncycastle$jce$spec$IESParameterSpec = JDKAlgorithmParameters.class$("org.bouncycastle.jce.spec.IESParameterSpec")) : class$org$bouncycastle$jce$spec$IESParameterSpec)) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to ElGamal parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof IESParameterSpec)) {
                throw new InvalidParameterSpecException("IESParameterSpec required to initialise a IES algorithm parameters object");
            }
            this.currentSpec = (IESParameterSpec)paramSpec;
        }

        protected void engineInit(byte[] params) throws IOException {
            ASN1InputStream aIn = new ASN1InputStream(params);
            try {
                ASN1Sequence s = (ASN1Sequence)aIn.readObject();
                this.currentSpec = new IESParameterSpec(((ASN1OctetString)s.getObjectAt(0)).getOctets(), ((ASN1OctetString)s.getObjectAt(0)).getOctets(), ((DERInteger)s.getObjectAt(0)).getValue().intValue());
            }
            catch (ClassCastException e) {
                throw new IOException("Not a valid IES Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Not a valid IES Parameter encoding.");
            }
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (!this.isASN1FormatString(format) && !format.equalsIgnoreCase("X.509")) {
                throw new IOException("Unknown parameter format " + format);
            }
            this.engineInit(params);
        }

        protected String engineToString() {
            return "IES Parameters";
        }
    }

    public static class ElGamal
    extends JDKAlgorithmParameters {
        ElGamalParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            ElGamalParameter elP = new ElGamalParameter(this.currentSpec.getP(), this.currentSpec.getG());
            try {
                dOut.writeObject(elP);
                dOut.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error encoding ElGamalParameters");
            }
            return bOut.toByteArray();
        }

        protected byte[] engineGetEncoded(String format) {
            if (this.isASN1FormatString(format) || format.equalsIgnoreCase("X.509")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == (class$org$bouncycastle$jce$spec$ElGamalParameterSpec == null ? (class$org$bouncycastle$jce$spec$ElGamalParameterSpec = JDKAlgorithmParameters.class$("org.bouncycastle.jce.spec.ElGamalParameterSpec")) : class$org$bouncycastle$jce$spec$ElGamalParameterSpec)) {
                return this.currentSpec;
            }
            if (paramSpec == (class$javax$crypto$spec$DHParameterSpec == null ? (class$javax$crypto$spec$DHParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.DHParameterSpec")) : class$javax$crypto$spec$DHParameterSpec)) {
                return new DHParameterSpec(this.currentSpec.getP(), this.currentSpec.getG());
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to ElGamal parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof ElGamalParameterSpec) && !(paramSpec instanceof DHParameterSpec)) {
                throw new InvalidParameterSpecException("DHParameterSpec required to initialise a ElGamal algorithm parameters object");
            }
            if (paramSpec instanceof ElGamalParameterSpec) {
                this.currentSpec = (ElGamalParameterSpec)paramSpec;
            } else {
                DHParameterSpec s = (DHParameterSpec)paramSpec;
                this.currentSpec = new ElGamalParameterSpec(s.getP(), s.getG());
            }
        }

        protected void engineInit(byte[] params) throws IOException {
            ASN1InputStream aIn = new ASN1InputStream(params);
            try {
                ElGamalParameter elP = new ElGamalParameter((ASN1Sequence)aIn.readObject());
                this.currentSpec = new ElGamalParameterSpec(elP.getP(), elP.getG());
            }
            catch (ClassCastException e) {
                throw new IOException("Not a valid ElGamal Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Not a valid ElGamal Parameter encoding.");
            }
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (!this.isASN1FormatString(format) && !format.equalsIgnoreCase("X.509")) {
                throw new IOException("Unknown parameter format " + format);
            }
            this.engineInit(params);
        }

        protected String engineToString() {
            return "ElGamal Parameters";
        }
    }

    public static class GOST3410
    extends JDKAlgorithmParameters {
        GOST3410ParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            GOST3410PublicKeyAlgParameters gost3410P = new GOST3410PublicKeyAlgParameters(new DERObjectIdentifier(this.currentSpec.getPublicKeyParamSetOID()), new DERObjectIdentifier(this.currentSpec.getDigestParamSetOID()), new DERObjectIdentifier(this.currentSpec.getEncryptionParamSetOID()));
            try {
                dOut.writeObject(gost3410P);
                dOut.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error encoding GOST3410Parameters");
            }
            return bOut.toByteArray();
        }

        protected byte[] engineGetEncoded(String format) {
            if (this.isASN1FormatString(format) || format.equalsIgnoreCase("X.509")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == (class$org$bouncycastle$jce$spec$GOST3410PublicKeyParameterSetSpec == null ? (class$org$bouncycastle$jce$spec$GOST3410PublicKeyParameterSetSpec = JDKAlgorithmParameters.class$("org.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec")) : class$org$bouncycastle$jce$spec$GOST3410PublicKeyParameterSetSpec)) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to GOST3410 parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof GOST3410ParameterSpec)) {
                throw new InvalidParameterSpecException("GOST3410ParameterSpec required to initialise a GOST3410 algorithm parameters object");
            }
            this.currentSpec = (GOST3410ParameterSpec)paramSpec;
        }

        protected void engineInit(byte[] params) throws IOException {
            ASN1InputStream dIn = new ASN1InputStream(params);
            try {
                GOST3410PublicKeyAlgParameters gost3410P = new GOST3410PublicKeyAlgParameters((ASN1Sequence)dIn.readObject());
                this.currentSpec = new GOST3410ParameterSpec(gost3410P.getPublicKeyParamSet().getId(), gost3410P.getDigestParamSet().getId(), gost3410P.getEncryptionParamSet().getId());
            }
            catch (ClassCastException e) {
                throw new IOException("Not a valid GOST3410 Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Not a valid GOST3410 Parameter encoding.");
            }
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (!this.isASN1FormatString(format) && !format.equalsIgnoreCase("X.509")) {
                throw new IOException("Unknown parameter format " + format);
            }
            this.engineInit(params);
        }

        protected String engineToString() {
            return "GOST3410 Parameters";
        }
    }

    public static class DSA
    extends JDKAlgorithmParameters {
        DSAParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            DSAParameter dsaP = new DSAParameter(this.currentSpec.getP(), this.currentSpec.getQ(), this.currentSpec.getG());
            try {
                dOut.writeObject(dsaP);
                dOut.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error encoding DSAParameters");
            }
            return bOut.toByteArray();
        }

        protected byte[] engineGetEncoded(String format) {
            if (this.isASN1FormatString(format)) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == (class$java$security$spec$DSAParameterSpec == null ? (class$java$security$spec$DSAParameterSpec = JDKAlgorithmParameters.class$("java.security.spec.DSAParameterSpec")) : class$java$security$spec$DSAParameterSpec)) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to DSA parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof DSAParameterSpec)) {
                throw new InvalidParameterSpecException("DSAParameterSpec required to initialise a DSA algorithm parameters object");
            }
            this.currentSpec = (DSAParameterSpec)paramSpec;
        }

        protected void engineInit(byte[] params) throws IOException {
            ASN1InputStream aIn = new ASN1InputStream(params);
            try {
                DSAParameter dsaP = new DSAParameter((ASN1Sequence)aIn.readObject());
                this.currentSpec = new DSAParameterSpec(dsaP.getP(), dsaP.getQ(), dsaP.getG());
            }
            catch (ClassCastException e) {
                throw new IOException("Not a valid DSA Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Not a valid DSA Parameter encoding.");
            }
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (!this.isASN1FormatString(format) && !format.equalsIgnoreCase("X.509")) {
                throw new IOException("Unknown parameter format " + format);
            }
            this.engineInit(params);
        }

        protected String engineToString() {
            return "DSA Parameters";
        }
    }

    public static class DH
    extends JDKAlgorithmParameters {
        DHParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            DHParameter dhP = new DHParameter(this.currentSpec.getP(), this.currentSpec.getG(), this.currentSpec.getL());
            try {
                dOut.writeObject(dhP);
                dOut.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error encoding DHParameters");
            }
            return bOut.toByteArray();
        }

        protected byte[] engineGetEncoded(String format) {
            if (this.isASN1FormatString(format)) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == (class$javax$crypto$spec$DHParameterSpec == null ? (class$javax$crypto$spec$DHParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.DHParameterSpec")) : class$javax$crypto$spec$DHParameterSpec)) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to DH parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof DHParameterSpec)) {
                throw new InvalidParameterSpecException("DHParameterSpec required to initialise a Diffie-Hellman algorithm parameters object");
            }
            this.currentSpec = (DHParameterSpec)paramSpec;
        }

        protected void engineInit(byte[] params) throws IOException {
            ASN1InputStream aIn = new ASN1InputStream(params);
            try {
                DHParameter dhP = new DHParameter((ASN1Sequence)aIn.readObject());
                this.currentSpec = dhP.getL() != null ? new DHParameterSpec(dhP.getP(), dhP.getG(), dhP.getL().intValue()) : new DHParameterSpec(dhP.getP(), dhP.getG());
            }
            catch (ClassCastException e) {
                throw new IOException("Not a valid DH Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Not a valid DH Parameter encoding.");
            }
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (!this.isASN1FormatString(format)) {
                throw new IOException("Unknown parameter format " + format);
            }
            this.engineInit(params);
        }

        protected String engineToString() {
            return "Diffie-Hellman Parameters";
        }
    }

    public static class PKCS12PBE
    extends JDKAlgorithmParameters {
        PKCS12PBEParams params;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            try {
                dOut.writeObject(this.params);
            }
            catch (IOException e) {
                throw new RuntimeException("Oooops! " + e.toString());
            }
            return bOut.toByteArray();
        }

        protected byte[] engineGetEncoded(String format) {
            if (this.isASN1FormatString(format)) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == (class$javax$crypto$spec$PBEParameterSpec == null ? (class$javax$crypto$spec$PBEParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.PBEParameterSpec")) : class$javax$crypto$spec$PBEParameterSpec)) {
                return new PBEParameterSpec(this.params.getIV(), this.params.getIterations().intValue());
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to PKCS12 PBE parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PKCS12 PBE parameters algorithm parameters object");
            }
            PBEParameterSpec pbeSpec = (PBEParameterSpec)paramSpec;
            this.params = new PKCS12PBEParams(pbeSpec.getSalt(), pbeSpec.getIterationCount());
        }

        protected void engineInit(byte[] params) throws IOException {
            ASN1InputStream aIn = new ASN1InputStream(params);
            this.params = PKCS12PBEParams.getInstance(aIn.readObject());
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                this.engineInit(params);
                return;
            }
            throw new IOException("Unknown parameters format in PKCS12 PBE parameters object");
        }

        protected String engineToString() {
            return "PKCS12 PBE Parameters";
        }
    }

    public static class CAST5AlgorithmParameters
    extends JDKAlgorithmParameters {
        private byte[] iv;
        private int keyLength = 128;

        protected byte[] engineGetEncoded() {
            byte[] tmp = new byte[this.iv.length];
            System.arraycopy(this.iv, 0, tmp, 0, this.iv.length);
            return tmp;
        }

        protected byte[] engineGetEncoded(String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                return new CAST5CBCParameters(this.engineGetEncoded(), this.keyLength).getEncoded();
            }
            if (format.equals("RAW")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == (class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec)) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to CAST5 parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof IvParameterSpec)) {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a CAST5 parameters algorithm parameters object");
            }
            this.iv = ((IvParameterSpec)paramSpec).getIV();
        }

        protected void engineInit(byte[] params) throws IOException {
            this.iv = new byte[params.length];
            System.arraycopy(params, 0, this.iv, 0, this.iv.length);
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                ASN1InputStream aIn = new ASN1InputStream(params);
                CAST5CBCParameters p = CAST5CBCParameters.getInstance(aIn.readObject());
                this.keyLength = p.getKeyLength();
                this.iv = p.getIV();
                return;
            }
            if (format.equals("RAW")) {
                this.engineInit(params);
                return;
            }
            throw new IOException("Unknown parameters format in IV parameters object");
        }

        protected String engineToString() {
            return "CAST5 Parameters";
        }
    }

    public static class RC2AlgorithmParameters
    extends JDKAlgorithmParameters {
        private short[] table = new short[]{189, 86, 234, 242, 162, 241, 172, 42, 176, 147, 209, 156, 27, 51, 253, 208, 48, 4, 182, 220, 125, 223, 50, 75, 247, 203, 69, 155, 49, 187, 33, 90, 65, 159, 225, 217, 74, 77, 158, 218, 160, 104, 44, 195, 39, 95, 128, 54, 62, 238, 251, 149, 26, 254, 206, 168, 52, 169, 19, 240, 166, 63, 216, 12, 120, 36, 175, 35, 82, 193, 103, 23, 245, 102, 144, 231, 232, 7, 184, 96, 72, 230, 30, 83, 243, 146, 164, 114, 140, 8, 21, 110, 134, 0, 132, 250, 244, 127, 138, 66, 25, 246, 219, 205, 20, 141, 80, 18, 186, 60, 6, 78, 236, 179, 53, 17, 161, 136, 142, 43, 148, 153, 183, 113, 116, 211, 228, 191, 58, 222, 150, 14, 188, 10, 237, 119, 252, 55, 107, 3, 121, 137, 98, 198, 215, 192, 210, 124, 106, 139, 34, 163, 91, 5, 93, 2, 117, 213, 97, 227, 24, 143, 85, 81, 173, 31, 11, 94, 133, 229, 194, 87, 99, 202, 61, 108, 180, 197, 204, 112, 178, 145, 89, 13, 71, 32, 200, 79, 88, 224, 1, 226, 22, 56, 196, 111, 59, 15, 101, 70, 190, 126, 45, 123, 130, 249, 64, 181, 29, 115, 248, 235, 38, 199, 135, 151, 37, 84, 177, 40, 170, 152, 157, 165, 100, 109, 122, 212, 16, 129, 68, 239, 73, 214, 174, 46, 221, 118, 92, 47, 167, 28, 201, 9, 105, 154, 131, 207, 41, 57, 185, 233, 76, 255, 67, 171};
        private short[] ekb = new short[]{93, 190, 155, 139, 17, 153, 110, 77, 89, 243, 133, 166, 63, 183, 131, 197, 228, 115, 107, 58, 104, 90, 192, 71, 160, 100, 52, 12, 241, 208, 82, 165, 185, 30, 150, 67, 65, 216, 212, 44, 219, 248, 7, 119, 42, 202, 235, 239, 16, 28, 22, 13, 56, 114, 47, 137, 193, 249, 128, 196, 109, 174, 48, 61, 206, 32, 99, 254, 230, 26, 199, 184, 80, 232, 36, 23, 252, 37, 111, 187, 106, 163, 68, 83, 217, 162, 1, 171, 188, 182, 31, 152, 238, 154, 167, 45, 79, 158, 142, 172, 224, 198, 73, 70, 41, 244, 148, 138, 175, 225, 91, 195, 179, 123, 87, 209, 124, 156, 237, 135, 64, 140, 226, 203, 147, 20, 201, 97, 46, 229, 204, 246, 94, 168, 92, 214, 117, 141, 98, 149, 88, 105, 118, 161, 74, 181, 85, 9, 120, 51, 130, 215, 221, 121, 245, 27, 11, 222, 38, 33, 40, 116, 4, 151, 86, 223, 60, 240, 55, 57, 220, 255, 6, 164, 234, 66, 8, 218, 180, 113, 176, 207, 18, 122, 78, 250, 108, 29, 132, 0, 200, 127, 145, 69, 170, 43, 194, 177, 143, 213, 186, 242, 173, 25, 178, 103, 54, 247, 15, 10, 146, 125, 227, 157, 233, 144, 62, 35, 39, 102, 19, 236, 129, 21, 189, 34, 191, 159, 126, 169, 81, 75, 76, 251, 2, 211, 112, 134, 49, 231, 59, 5, 3, 84, 96, 72, 101, 24, 210, 205, 95, 50, 136, 14, 53, 253};
        private byte[] iv;
        private int parameterVersion = 58;

        protected byte[] engineGetEncoded() {
            byte[] tmp = new byte[this.iv.length];
            System.arraycopy(this.iv, 0, tmp, 0, this.iv.length);
            return tmp;
        }

        protected byte[] engineGetEncoded(String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                if (this.parameterVersion == -1) {
                    return new RC2CBCParameter(this.engineGetEncoded()).getEncoded();
                }
                return new RC2CBCParameter(this.parameterVersion, this.engineGetEncoded()).getEncoded();
            }
            if (format.equals("RAW")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == (class$javax$crypto$spec$RC2ParameterSpec == null ? (class$javax$crypto$spec$RC2ParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.RC2ParameterSpec")) : class$javax$crypto$spec$RC2ParameterSpec) && this.parameterVersion != -1) {
                if (this.parameterVersion < 256) {
                    return new RC2ParameterSpec(this.ekb[this.parameterVersion], this.iv);
                }
                return new RC2ParameterSpec(this.parameterVersion, this.iv);
            }
            if (paramSpec == (class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec)) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to RC2 parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (paramSpec instanceof IvParameterSpec) {
                this.iv = ((IvParameterSpec)paramSpec).getIV();
            } else if (paramSpec instanceof RC2ParameterSpec) {
                int effKeyBits = ((RC2ParameterSpec)paramSpec).getEffectiveKeyBits();
                if (effKeyBits != -1) {
                    this.parameterVersion = effKeyBits < 256 ? this.table[effKeyBits] : effKeyBits;
                }
                this.iv = ((RC2ParameterSpec)paramSpec).getIV();
            } else {
                throw new InvalidParameterSpecException("IvParameterSpec or RC2ParameterSpec required to initialise a RC2 parameters algorithm parameters object");
            }
        }

        protected void engineInit(byte[] params) throws IOException {
            this.iv = new byte[params.length];
            System.arraycopy(params, 0, this.iv, 0, this.iv.length);
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                ASN1InputStream aIn = new ASN1InputStream(params);
                RC2CBCParameter p = RC2CBCParameter.getInstance(aIn.readObject());
                if (p.getRC2ParameterVersion() != null) {
                    this.parameterVersion = p.getRC2ParameterVersion().intValue();
                }
                this.iv = p.getIV();
                return;
            }
            if (format.equals("RAW")) {
                this.engineInit(params);
                return;
            }
            throw new IOException("Unknown parameters format in IV parameters object");
        }

        protected String engineToString() {
            return "RC2 Parameters";
        }
    }

    public static class IVAlgorithmParameters
    extends JDKAlgorithmParameters {
        private byte[] iv;

        protected byte[] engineGetEncoded() throws IOException {
            return this.engineGetEncoded("ASN.1");
        }

        protected byte[] engineGetEncoded(String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                return new DEROctetString(this.engineGetEncoded("RAW")).getEncoded();
            }
            if (format.equals("RAW")) {
                byte[] tmp = new byte[this.iv.length];
                System.arraycopy(this.iv, 0, tmp, 0, this.iv.length);
                return tmp;
            }
            return null;
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == (class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec)) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to IV parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof IvParameterSpec)) {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
            }
            this.iv = ((IvParameterSpec)paramSpec).getIV();
        }

        protected void engineInit(byte[] params) throws IOException {
            if (params.length % 8 != 0 && params[0] == 4 && params[1] == params.length - 2) {
                ASN1InputStream aIn = new ASN1InputStream(params);
                ASN1OctetString oct = (ASN1OctetString)aIn.readObject();
                params = oct.getOctets();
            }
            this.iv = new byte[params.length];
            System.arraycopy(params, 0, this.iv, 0, this.iv.length);
        }

        protected void engineInit(byte[] params, String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                ASN1InputStream aIn = new ASN1InputStream(params);
                try {
                    ASN1OctetString oct = (ASN1OctetString)aIn.readObject();
                    this.engineInit(oct.getOctets());
                }
                catch (Exception e) {
                    throw new IOException("Exception decoding: " + e);
                }
                return;
            }
            if (format.equals("RAW")) {
                this.engineInit(params);
                return;
            }
            throw new IOException("Unknown parameters format in IV parameters object");
        }

        protected String engineToString() {
            return "IV Parameters";
        }
    }
}

