/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.util.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;

public class ListVirtualStack
extends VirtualStack
implements PlugIn {
    private static boolean virtual;
    private String[] list;
    private String[] labels;
    private int nImages;
    private int imageWidth;
    private int imageHeight;

    public void run(String arg) {
        File f;
        OpenDialog od = new OpenDialog("Open Image List", arg);
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String dir = od.getDirectory();
        this.list = this.open(String.valueOf(dir) + name);
        if (this.list == null) {
            return;
        }
        this.nImages = this.list.length;
        this.labels = new String[this.nImages];
        if (this.list.length == 0) {
            IJ.error("Stack From List", "The file path list is empty");
            return;
        }
        if (!this.list[0].startsWith("http://") && !(f = new File(this.list[0])).exists()) {
            IJ.error("Stack From List", "The first file on the list does not exist:\n \n" + this.list[0]);
            return;
        }
        ImagePlus imp = IJ.openImage(this.list[0]);
        if (imp == null) {
            return;
        }
        this.imageWidth = imp.getWidth();
        this.imageHeight = imp.getHeight();
        this.setBitDepth(imp.getBitDepth());
        ImageStack stack = this;
        if (!this.showDialog(imp)) {
            return;
        }
        if (!virtual) {
            stack = this.convertToRealStack(imp);
        }
        ImagePlus imp2 = new ImagePlus(name, stack);
        imp2.setCalibration(imp.getCalibration());
        imp2.show();
    }

    boolean showDialog(ImagePlus imp) {
        double bytesPerPixel = 1.0;
        switch (imp.getType()) {
            case 1: {
                bytesPerPixel = 2.0;
                break;
            }
            case 2: 
            case 4: {
                bytesPerPixel = 4.0;
            }
        }
        double size = (double)(this.imageWidth * this.imageHeight) * bytesPerPixel / 1048576.0;
        int digits = size * (double)this.getSize() < 10.0 ? 1 : 0;
        String size1 = String.valueOf(IJ.d2s(size * (double)this.getSize(), digits)) + " MB";
        String size2 = String.valueOf(IJ.d2s(size, 1)) + " MB";
        GenericDialog gd = new GenericDialog("Open Stack From List");
        gd.addCheckbox("Use Virtual Stack", virtual);
        gd.addMessage("This " + this.imageWidth + "x" + this.imageHeight + "x" + this.getSize() + " stack will require " + size1 + ",\n or " + size2 + " if opened as a virtual stack.");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        virtual = gd.getNextBoolean();
        return true;
    }

    ImageStack convertToRealStack(ImagePlus imp) {
        ImageStack stack2 = new ImageStack(this.imageWidth, this.imageHeight, imp.getProcessor().getColorModel());
        int n = this.getSize();
        int i = 1;
        while (i <= this.getSize()) {
            IJ.showProgress(i, n);
            IJ.showStatus("Opening: " + i + "/" + n);
            ImageProcessor ip2 = this.getProcessor(i);
            if (ip2 != null) {
                stack2.addSlice(this.getSliceLabel(i), ip2);
            }
            ++i;
        }
        return stack2;
    }

    String[] open(String path) {
        if (path.startsWith("http://")) {
            return this.openUrl(path);
        }
        Vector<String> v = new Vector<String>();
        File file = new File(path);
        try {
            String s;
            BufferedReader r = new BufferedReader(new FileReader(file));
            while ((s = r.readLine()) != null && !s.equals("") && !s.startsWith(" ")) {
                v.addElement(s);
            }
            r.close();
            Object[] list = new String[v.size()];
            v.copyInto(list);
            return list;
        }
        catch (Exception e) {
            IJ.error("Open List Error \n\"" + e.getMessage() + "\"\n");
            return null;
        }
    }

    String[] openUrl(String url) {
        String str = IJ.openUrlAsString(url);
        if (str.startsWith("<Error: ")) {
            IJ.error("Stack From List", str);
            return null;
        }
        return Tools.split(str, "\n");
    }

    public void deleteSlice(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.nImages < 1) {
            return;
        }
        int i = n;
        while (i < this.nImages) {
            this.list[i - 1] = this.list[i];
            ++i;
        }
        this.list[this.nImages - 1] = null;
        --this.nImages;
    }

    public ImageProcessor getProcessor(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        IJ.redirectErrorMessages(true);
        String url = this.list[n - 1];
        ImagePlus imp = null;
        if (url.length() > 0) {
            imp = IJ.openImage(url);
        }
        if (imp != null) {
            this.labels[n - 1] = String.valueOf(new File(this.list[n - 1]).getName()) + "\n" + (String)imp.getProperty("Info");
            ImageProcessor ip = imp.getProcessor();
            int bitDepth = this.getBitDepth();
            if (imp.getBitDepth() != bitDepth) {
                switch (bitDepth) {
                    case 8: {
                        ip = ip.convertToByte(true);
                        break;
                    }
                    case 16: {
                        ip = ip.convertToShort(true);
                        break;
                    }
                    case 24: {
                        ip = ip.convertToRGB();
                        break;
                    }
                    case 32: {
                        ip = ip.convertToFloat();
                    }
                }
            }
            if (ip.getWidth() != this.imageWidth || ip.getHeight() != this.imageHeight) {
                ip = ip.resize(this.imageWidth, this.imageHeight);
            }
            IJ.redirectErrorMessages(false);
            return ip;
        }
        ImageProcessor ip = null;
        switch (this.getBitDepth()) {
            case 8: {
                ip = new ByteProcessor(this.imageWidth, this.imageHeight);
                break;
            }
            case 16: {
                ip = new ShortProcessor(this.imageWidth, this.imageHeight);
                break;
            }
            case 24: {
                ip = new ColorProcessor(this.imageWidth, this.imageHeight);
                break;
            }
            case 32: {
                ip = new FloatProcessor(this.imageWidth, this.imageHeight);
            }
        }
        IJ.redirectErrorMessages(false);
        return ip;
    }

    public int getSize() {
        return this.nImages;
    }

    public String getSliceLabel(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.labels[n - 1] != null) {
            return this.labels[n - 1];
        }
        return new File(this.list[n - 1]).getName();
    }

    public int getWidth() {
        return this.imageWidth;
    }

    public int getHeight() {
        return this.imageHeight;
    }
}

