/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.SBChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class TinyFrameBorder
extends AbstractBorder
implements UIResource {
    private static HashMap cache = new HashMap();
    public static Color buttonUpperColor;
    public static Color buttonLowerColor;
    private static TinyFrameBorder onlyInstance;
    private static Robot robot;
    private static boolean robotsSupported;
    private Window window;
    private int titleHeight;
    private boolean isActive;

    public static TinyFrameBorder getInstance() {
        if (onlyInstance == null) {
            onlyInstance = new TinyFrameBorder();
            if (robot == null && robotsSupported) {
                try {
                    robot = new Robot();
                }
                catch (Exception ex) {
                    robotsSupported = false;
                }
            }
        }
        return onlyInstance;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        this.window = SwingUtilities.getWindowAncestor(c);
        this.isActive = this.window.isActive();
        this.titleHeight = this.window instanceof JFrame ? Theme.frameTitleHeight[Theme.derivedStyle[Theme.style]] : Theme.frameInternalTitleHeight[Theme.derivedStyle[Theme.style]];
        if (this.isActive) {
            g.setColor(Theme.frameBorderColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.frameBorderDisabledColor[Theme.style].getColor());
        }
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyBorder(g, x, y, w, h);
                break;
            }
            case 1: {
                this.drawWinBorder(g, x, y, w, h);
                break;
            }
            case 2: {
                this.drawXpBorder(g, x, y, w, h);
            }
        }
        ColorUIResource col = null;
        col = this.isActive ? Theme.frameCaptionColor[Theme.style].getColor() : Theme.frameCaptionDisabledColor[Theme.style].getColor();
        g.setColor(col);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyCaption(g, x, y, w, h, col);
                break;
            }
            case 1: {
                this.drawWinCaption(g, x, y, w, h, col);
                break;
            }
            case 2: {
                if (TinyLookAndFeel.controlPanelInstantiated) {
                    this.drawXpCaptionNoCache(g, x, y, w, h, col);
                    break;
                }
                this.drawXpCaption(g, x, y, w, h, col);
            }
        }
    }

    private void drawTinyBorder(Graphics g, int x, int y, int w, int h) {
    }

    private void drawWinBorder(Graphics g, int x, int y, int w, int h) {
        g.drawLine(x, y, x + w - 2, y);
        g.drawLine(x, y + 1, x, y + h - 2);
        g.drawRect(x + 2, y + 2, w - 5, h - 5);
        g.drawRect(x + 3, y + 3, w - 7, h - 7);
        g.setColor(Color.WHITE);
        g.drawLine(x + 1, y + 1, x + w - 3, y + 1);
        g.drawLine(x + 1, y + 2, x + 1, y + h - 3);
        g.setColor(Theme.frameDarkColor[Theme.style].getColor());
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        g.setColor(Theme.frameLightColor[Theme.style].getColor());
        g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        g.drawLine(w - 2, y + 1, x + w - 2, y + h - 2);
    }

    private void drawXpBorder(Graphics g, int x, int y, int w, int h) {
        g.drawLine(x, y + 6, x, y + h - 1);
        g.drawLine(x + 2, y + this.titleHeight, x + 2, y + h - 3);
        g.drawLine(x + w - 1, y + 6, x + w - 1, y + h - 1);
        g.drawLine(x + w - 3, y + this.titleHeight, x + w - 3, y + h - 3);
        g.drawLine(x + 2, y + h - 3, x + w - 3, y + h - 3);
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        if (robot != null) {
            int wx = this.window.getLocationOnScreen().x - 4;
            int wy = this.window.getLocationOnScreen().y;
            Rectangle screenRect = new Rectangle(wx, wy, 4, 4);
            g.drawImage(robot.createScreenCapture(screenRect), x, y, null);
            wx = this.window.getLocationOnScreen().x + this.window.getWidth() + 1;
            screenRect = new Rectangle(wx, wy, 4, 4);
            g.drawImage(robot.createScreenCapture(screenRect), x + w - 4, y, null);
        } else {
            g.setColor(Theme.backColor[Theme.style].getColor());
            g.fillRect(0, 0, w, 3);
        }
        if (this.isActive) {
            g.setColor(Theme.frameCaptionColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.frameCaptionDisabledColor[Theme.style].getColor());
        }
        g.drawLine(x + 1, y + this.titleHeight, x + 1, y + h - 2);
        g.drawLine(x + w - 2, y + this.titleHeight, x + w - 2, y + h - 2);
        g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        ColorUIResource c = null;
        c = this.isActive ? Theme.frameBorderColor[Theme.style].getColor() : Theme.frameBorderDisabledColor[Theme.style].getColor();
        g.setColor(ColorRoutines.getAlphaColor(c, 82));
        g.drawLine(x, y + 3, x, y + 3);
        g.drawLine(x + w - 1, y + 3, x + w - 1, y + 3);
        g.setColor(ColorRoutines.getAlphaColor(c, 156));
        g.drawLine(x, y + 4, x, y + 4);
        g.drawLine(x + w - 1, y + 4, x + w - 1, y + 4);
        g.setColor(ColorRoutines.getAlphaColor(c, 215));
        g.drawLine(x, y + 5, x, y + 5);
        g.drawLine(x + w - 1, y + 5, x + w - 1, y + 5);
    }

    private void drawTinyCaption(Graphics g, int x, int y, int w, int h, Color c) {
    }

    private void drawWinCaption(Graphics g, int x, int y, int w, int h, Color c) {
        int y2 = y + this.titleHeight - 2;
        int tw = w - 8;
        int maxSat = 56;
        int maxBri = 78;
        if (!this.isActive) {
            maxSat = 0;
            maxBri = 50;
        }
        int sat = 0;
        int bri = 0;
        int memSat = 0;
        int memBri = 0;
        Color col = c;
        for (int i = 0; i < tw; ++i) {
            g.setColor(col);
            g.drawLine(x + 4 + i, y + 4, x + 4 + i, y2);
            sat = maxSat * i / tw;
            bri = maxBri * i / tw;
            if (sat == memSat && bri == memBri) continue;
            memSat = sat;
            memBri = bri;
            col = SBChooser.getAdjustedColor(c, sat, bri);
        }
        g.setColor(Theme.frameBorderColor[Theme.style].getColor());
        g.drawLine(x + 4, y + this.titleHeight - 1, x + w - 5, y + this.titleHeight - 1);
    }

    private void drawXpCaption(Graphics g, int x, int y, int w, int h, Color c) {
        if (this.titleHeight == Theme.frameInternalTitleHeight[Theme.derivedStyle[Theme.style]]) {
            this.drawXpInternalCaption(g, x, y, w, h, c);
            return;
        }
        int spread1 = Theme.frameSpreadDarkDisabled[Theme.style];
        int spread2 = Theme.frameSpreadLightDisabled[Theme.style];
        int y2 = y;
        ColorUIResource borderColor = null;
        if (this.isActive) {
            borderColor = Theme.frameBorderColor[Theme.style].getColor();
            spread1 = Theme.frameSpreadDark[Theme.style];
            spread2 = Theme.frameSpreadLight[Theme.style];
        } else {
            borderColor = Theme.frameBorderDisabledColor[Theme.style].getColor();
        }
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 82));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 156));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 215));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        Color c2 = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(c2);
        g.drawLine(x + 3, ++y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 23));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 4, ++y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 5, y2);
        g.setColor(c);
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        c2 = ColorRoutines.darken(c, 6 * spread1);
        g.setColor(c2);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(c);
        g.drawLine(x + 2, ++y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.lighten(c, 7 * spread2));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.lighten(c, 3 * spread2));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        g.setColor(c);
        g.drawLine(x + 6, y2, x + 6, y2);
        g.drawLine(x + w - 7, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 5, ++y2, x + 6, y2);
        g.drawLine(x + x + w - 7, y2, x + w - 6, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(c);
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 1, ++y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        CaptionKey key = new CaptionKey(this.isActive, this.titleHeight);
        Object value = cache.get(key);
        if (value != null) {
            g.drawImage((Image)value, x + 6, y, x + w - 6, y + 5, 0, 0, 1, 5, this.window);
            g.drawImage((Image)value, x + 1, y + 5, x + w - 1, y + this.titleHeight, 0, 5, 1, this.titleHeight, this.window);
            buttonUpperColor = ColorRoutines.darken(c, 4 * spread1);
            buttonLowerColor = ColorRoutines.lighten(c, 10 * spread2);
            return;
        }
        BufferedImage img = new BufferedImage(1, this.titleHeight, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        imgGraphics.setColor(borderColor);
        imgGraphics.drawLine(0, 0, 1, 0);
        imgGraphics.setColor(ColorRoutines.darken(c, 4 * spread1));
        imgGraphics.drawLine(0, 1, 1, 1);
        imgGraphics.setColor(ColorRoutines.lighten(c, 10 * spread2));
        imgGraphics.drawLine(0, 2, 1, 2);
        imgGraphics.setColor(c);
        imgGraphics.drawLine(0, 3, 1, 3);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 4, 1, 4);
        buttonUpperColor = ColorRoutines.darken(c, 4 * spread1);
        imgGraphics.setColor(buttonUpperColor);
        imgGraphics.drawLine(0, 5, 1, 5);
        imgGraphics.setColor(ColorRoutines.darken(c, 4 * spread1));
        imgGraphics.drawLine(0, 6, 1, 6);
        imgGraphics.drawLine(0, 7, 1, 7);
        imgGraphics.setColor(ColorRoutines.darken(c, 3 * spread1));
        imgGraphics.drawLine(0, 8, 1, 8);
        imgGraphics.drawLine(0, 9, 1, 9);
        imgGraphics.drawLine(0, 10, 1, 10);
        imgGraphics.drawLine(0, 11, 1, 11);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 12, 1, 12);
        imgGraphics.drawLine(0, 13, 1, 13);
        imgGraphics.drawLine(0, 14, 1, 14);
        imgGraphics.setColor(ColorRoutines.darken(c, spread1));
        imgGraphics.drawLine(0, 15, 1, 15);
        imgGraphics.drawLine(0, 16, 1, 16);
        imgGraphics.setColor(c);
        imgGraphics.drawLine(0, 17, 1, 17);
        imgGraphics.drawLine(0, 18, 1, 18);
        imgGraphics.setColor(ColorRoutines.lighten(c, 2 * spread2));
        imgGraphics.drawLine(0, 19, 1, 19);
        imgGraphics.setColor(ColorRoutines.lighten(c, 4 * spread2));
        imgGraphics.drawLine(0, 20, 1, 20);
        imgGraphics.setColor(ColorRoutines.lighten(c, 5 * spread2));
        imgGraphics.drawLine(0, 21, 1, 21);
        imgGraphics.setColor(ColorRoutines.lighten(c, 6 * spread2));
        imgGraphics.drawLine(0, 22, 1, 22);
        imgGraphics.setColor(ColorRoutines.lighten(c, 8 * spread2));
        imgGraphics.drawLine(0, 23, 1, 23);
        imgGraphics.setColor(ColorRoutines.lighten(c, 9 * spread2));
        imgGraphics.drawLine(0, 24, 1, 24);
        imgGraphics.setColor(ColorRoutines.lighten(c, 10 * spread2));
        imgGraphics.drawLine(0, 25, 1, 25);
        imgGraphics.setColor(ColorRoutines.lighten(c, 4 * spread2));
        imgGraphics.drawLine(0, 26, 1, 26);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 27, 1, 27);
        if (this.isActive) {
            imgGraphics.setColor(Theme.frameLightColor[Theme.style].getColor());
        } else {
            imgGraphics.setColor(Theme.frameLightDisabledColor[Theme.style].getColor());
        }
        imgGraphics.drawLine(0, 28, 1, 28);
        imgGraphics.dispose();
        g.drawImage(img, x + 6, y, x + w - 6, y + 5, 0, 0, 1, 5, this.window);
        g.drawImage(img, x + 1, y + 5, x + w - 1, y + this.titleHeight, 0, 5, 1, this.titleHeight, this.window);
        cache.put(key, img);
    }

    private void drawXpCaptionNoCache(Graphics g, int x, int y, int w, int h, Color c) {
        if (this.titleHeight == Theme.frameInternalTitleHeight[Theme.derivedStyle[Theme.style]]) {
            this.drawXpInternalCaptionNoCache(g, x, y, w, h, c);
            return;
        }
        int y2 = y;
        int spread1 = Theme.frameSpreadDarkDisabled[Theme.style];
        int spread2 = Theme.frameSpreadLightDisabled[Theme.style];
        ColorUIResource borderColor = null;
        if (this.isActive) {
            borderColor = Theme.frameBorderColor[Theme.style].getColor();
            spread1 = Theme.frameSpreadDark[Theme.style];
            spread2 = Theme.frameSpreadLight[Theme.style];
        } else {
            borderColor = Theme.frameBorderDisabledColor[Theme.style].getColor();
        }
        g.setColor(borderColor);
        g.drawLine(x + 6, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 82));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 156));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 215));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        Color c2 = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(c2);
        g.drawLine(x + 3, ++y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 23));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 4, ++y2, x + w - 5, y2);
        g.setColor(c);
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        c2 = ColorRoutines.darken(c, 6 * spread1);
        g.setColor(c2);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(c);
        g.drawLine(x + 7, ++y2, x + w - 8, y2);
        g.setColor(c);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.lighten(c, 7 * spread2));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.lighten(c, 3 * spread2));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        g.setColor(c);
        g.drawLine(x + 6, y2, x + 6, y2);
        g.drawLine(x + w - 7, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 5, ++y2, x + w - 6, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(c);
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        buttonUpperColor = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(buttonUpperColor);
        g.drawLine(x + 2, ++y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 2);
        g.setColor(ColorRoutines.darken(c, 3 * spread1));
        g.fillRect(x + 1, y2 += 2, w - 2, 4);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.fillRect(x + 1, y2 += 4, w - 2, 3);
        g.setColor(ColorRoutines.darken(c, 1 * spread1));
        g.fillRect(x + 1, y2 += 3, w - 2, 2);
        g.setColor(c);
        g.fillRect(x + 1, y2 += 2, w - 2, 2);
        g.setColor(ColorRoutines.lighten(c, 2 * spread2));
        g.drawLine(x + 1, y2 += 2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 6 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 8 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 9 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        buttonLowerColor = ColorRoutines.lighten(c, 10 * spread2);
        g.setColor(buttonLowerColor);
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        ++y2;
        if (this.isActive) {
            g.setColor(Theme.frameLightColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.frameLightDisabledColor[Theme.style].getColor());
        }
        g.drawLine(x + 1, y2, x + w - 2, y2);
    }

    private void drawXpInternalCaption(Graphics g, int x, int y, int w, int h, Color c) {
        int spread1 = Theme.frameSpreadDarkDisabled[Theme.style];
        int spread2 = Theme.frameSpreadLightDisabled[Theme.style];
        int y2 = y;
        ColorUIResource borderColor = null;
        if (this.isActive) {
            borderColor = Theme.frameBorderColor[Theme.style].getColor();
            spread1 = Theme.frameSpreadDark[Theme.style];
            spread2 = Theme.frameSpreadLight[Theme.style];
        } else {
            borderColor = Theme.frameBorderDisabledColor[Theme.style].getColor();
        }
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 82));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 156));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 215));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        Color c2 = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(c2);
        g.drawLine(x + 3, ++y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 23));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 4, ++y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 5, y2);
        g.setColor(c);
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        c2 = ColorRoutines.darken(c, 6 * spread1);
        g.setColor(c2);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(c);
        g.drawLine(x + 2, ++y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.lighten(c, 7 * spread2));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.lighten(c, 3 * spread2));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        g.setColor(c);
        g.drawLine(x + 6, y2, x + 6, y2);
        g.drawLine(x + w - 7, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 5, ++y2, x + 6, y2);
        g.drawLine(x + x + w - 7, y2, x + w - 6, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(c);
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 1, ++y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        CaptionKey key = new CaptionKey(this.isActive, this.titleHeight);
        Object value = cache.get(key);
        if (value != null) {
            g.drawImage((Image)value, x + 6, y, x + w - 6, y + 5, 0, 0, 1, 5, this.window);
            g.drawImage((Image)value, x + 1, y + 5, x + w - 1, y + this.titleHeight, 0, 5, 1, this.titleHeight, this.window);
            buttonUpperColor = ColorRoutines.darken(c, 4 * spread1);
            buttonLowerColor = ColorRoutines.lighten(c, 10 * spread2);
            return;
        }
        BufferedImage img = new BufferedImage(1, this.titleHeight, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        imgGraphics.setColor(borderColor);
        imgGraphics.drawLine(0, 0, 1, 0);
        imgGraphics.setColor(ColorRoutines.darken(c, 4 * spread1));
        imgGraphics.drawLine(0, 1, 1, 1);
        imgGraphics.setColor(ColorRoutines.lighten(c, 10 * spread2));
        imgGraphics.drawLine(0, 2, 1, 2);
        imgGraphics.setColor(c);
        imgGraphics.drawLine(0, 3, 1, 3);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 4, 1, 4);
        imgGraphics.setColor(ColorRoutines.darken(c, 4 * spread1));
        imgGraphics.drawLine(0, 5, 1, 5);
        imgGraphics.setColor(ColorRoutines.darken(c, 4 * spread1));
        imgGraphics.drawLine(0, 6, 1, 6);
        imgGraphics.setColor(ColorRoutines.darken(c, 3 * spread1));
        imgGraphics.drawLine(0, 7, 1, 7);
        imgGraphics.drawLine(0, 8, 1, 8);
        imgGraphics.drawLine(0, 9, 1, 9);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 10, 1, 10);
        imgGraphics.drawLine(0, 11, 1, 11);
        imgGraphics.setColor(ColorRoutines.darken(c, spread1));
        imgGraphics.drawLine(0, 12, 1, 12);
        imgGraphics.setColor(c);
        imgGraphics.drawLine(0, 13, 1, 13);
        imgGraphics.drawLine(0, 14, 1, 14);
        imgGraphics.setColor(ColorRoutines.lighten(c, 2 * spread2));
        imgGraphics.drawLine(0, 15, 1, 15);
        imgGraphics.setColor(ColorRoutines.lighten(c, 4 * spread2));
        imgGraphics.drawLine(0, 16, 1, 16);
        imgGraphics.setColor(ColorRoutines.lighten(c, 5 * spread2));
        imgGraphics.drawLine(0, 17, 1, 17);
        imgGraphics.setColor(ColorRoutines.lighten(c, 6 * spread2));
        imgGraphics.drawLine(0, 18, 1, 18);
        imgGraphics.setColor(ColorRoutines.lighten(c, 8 * spread2));
        imgGraphics.drawLine(0, 19, 1, 19);
        imgGraphics.setColor(ColorRoutines.lighten(c, 9 * spread2));
        imgGraphics.drawLine(0, 20, 1, 20);
        imgGraphics.setColor(ColorRoutines.lighten(c, 10 * spread2));
        imgGraphics.drawLine(0, 21, 1, 21);
        imgGraphics.setColor(ColorRoutines.lighten(c, 4 * spread2));
        imgGraphics.drawLine(0, 22, 1, 22);
        imgGraphics.setColor(ColorRoutines.darken(c, 2 * spread1));
        imgGraphics.drawLine(0, 23, 1, 23);
        if (this.isActive) {
            imgGraphics.setColor(Theme.frameLightColor[Theme.style].getColor());
        } else {
            imgGraphics.setColor(Theme.frameLightDisabledColor[Theme.style].getColor());
        }
        imgGraphics.drawLine(0, 24, 1, 24);
        imgGraphics.dispose();
        g.drawImage(img, x + 6, y, x + w - 6, y + 5, 0, 0, 1, 5, this.window);
        g.drawImage(img, x + 1, y + 5, x + w - 1, y + this.titleHeight, 0, 5, 1, this.titleHeight, this.window);
        cache.put(key, img);
    }

    private void drawXpInternalCaptionNoCache(Graphics g, int x, int y, int w, int h, Color c) {
        int y2 = y;
        int spread1 = Theme.frameSpreadDarkDisabled[Theme.style];
        int spread2 = Theme.frameSpreadLightDisabled[Theme.style];
        ColorUIResource borderColor = null;
        if (this.isActive) {
            borderColor = Theme.frameBorderColor[Theme.style].getColor();
            spread1 = Theme.frameSpreadDark[Theme.style];
            spread2 = Theme.frameSpreadLight[Theme.style];
        } else {
            borderColor = Theme.frameBorderDisabledColor[Theme.style].getColor();
        }
        g.setColor(borderColor);
        g.drawLine(x + 6, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 82));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 156));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.getAlphaColor(borderColor, 215));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        Color c2 = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(c2);
        g.drawLine(x + 3, ++y2, x + w - 4, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 23));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 4, ++y2, x + w - 5, y2);
        g.setColor(c);
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        c2 = ColorRoutines.darken(c, 6 * spread1);
        g.setColor(c2);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(c);
        g.drawLine(x + 7, ++y2, x + w - 8, y2);
        g.setColor(c);
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(ColorRoutines.lighten(c, 7 * spread2));
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.lighten(c, 3 * spread2));
        g.drawLine(x + 5, y2, x + 5, y2);
        g.drawLine(x + w - 6, y2, x + w - 6, y2);
        g.setColor(c);
        g.drawLine(x + 6, y2, x + 6, y2);
        g.drawLine(x + w - 7, y2, x + w - 7, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 5, ++y2, x + w - 6, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 3, y2, x + 3, y2);
        g.drawLine(x + w - 4, y2, x + w - 4, y2);
        g.setColor(c);
        g.drawLine(x + 4, y2, x + 4, y2);
        g.drawLine(x + w - 5, y2, x + w - 5, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 2, ++y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 1);
        g.setColor(ColorRoutines.darken(c, 3 * spread1));
        g.fillRect(x + 1, ++y2, w - 2, 3);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.fillRect(x + 1, y2 += 3, w - 2, 2);
        g.setColor(ColorRoutines.darken(c, 1 * spread1));
        g.fillRect(x + 1, y2 += 2, w - 2, 1);
        g.setColor(c);
        g.fillRect(x + 1, ++y2, w - 2, 2);
        g.setColor(ColorRoutines.lighten(c, 2 * spread2));
        g.drawLine(x + 1, y2 += 2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 6 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 8 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 9 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 1, ++y2, x + w - 2, y2);
        ++y2;
        if (this.isActive) {
            g.setColor(Theme.frameLightColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.frameLightDisabledColor[Theme.style].getColor());
        }
        g.drawLine(x + 1, y2, x + w - 2, y2);
    }

    public Insets getBorderInsets(Component c) {
        Frame f;
        Window w = SwingUtilities.getWindowAncestor(c);
        if (w != null && w instanceof Frame && (f = (Frame)w).getExtendedState() == (f.getExtendedState() | 6)) {
            return new Insets(0, 0, 0, 0);
        }
        return new Insets(0, Theme.frameBorderWidth[Theme.derivedStyle[Theme.style]], Theme.frameBorderWidth[Theme.derivedStyle[Theme.style]], Theme.frameBorderWidth[Theme.derivedStyle[Theme.style]]);
    }

    static {
        robotsSupported = true;
    }

    static class CaptionKey {
        private boolean isActive;
        private int titleHeight;

        CaptionKey(boolean isActive, int titleHeight) {
            this.isActive = isActive;
            this.titleHeight = titleHeight;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof CaptionKey)) {
                return false;
            }
            CaptionKey other = (CaptionKey)o;
            return this.isActive == other.isActive && this.titleHeight == other.titleHeight;
        }

        public int hashCode() {
            return (this.isActive ? 1 : 2) * this.titleHeight;
        }
    }
}

