/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.usermodel;

import com.fr.third.v2.org.apache.poi.ss.usermodel.ConditionalFormattingThreshold;
import com.fr.third.v2.org.apache.poi.ss.usermodel.IconMultiStateFormatting;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFConditionalFormattingThreshold;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfvo;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTIconSet;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.STIconSetType;

public class XSSFIconMultiStateFormatting
implements IconMultiStateFormatting {
    CTIconSet _iconset;

    XSSFIconMultiStateFormatting(CTIconSet iconset) {
        this._iconset = iconset;
    }

    public IconMultiStateFormatting.IconSet getIconSet() {
        String set = this._iconset.getIconSet().toString();
        return IconMultiStateFormatting.IconSet.byName(set);
    }

    public void setIconSet(IconMultiStateFormatting.IconSet set) {
        STIconSetType.Enum xIconSet = STIconSetType.Enum.forString(set.name);
        this._iconset.setIconSet(xIconSet);
    }

    public boolean isIconOnly() {
        if (this._iconset.isSetShowValue()) {
            return !this._iconset.getShowValue();
        }
        return false;
    }

    public void setIconOnly(boolean only) {
        this._iconset.setShowValue(!only);
    }

    public boolean isReversed() {
        if (this._iconset.isSetReverse()) {
            return this._iconset.getReverse();
        }
        return false;
    }

    public void setReversed(boolean reversed) {
        this._iconset.setReverse(reversed);
    }

    public XSSFConditionalFormattingThreshold[] getThresholds() {
        CTCfvo[] cfvos = this._iconset.getCfvoArray();
        XSSFConditionalFormattingThreshold[] t = new XSSFConditionalFormattingThreshold[cfvos.length];
        for (int i = 0; i < cfvos.length; ++i) {
            t[i] = new XSSFConditionalFormattingThreshold(cfvos[i]);
        }
        return t;
    }

    public void setThresholds(ConditionalFormattingThreshold[] thresholds) {
        CTCfvo[] cfvos = new CTCfvo[thresholds.length];
        for (int i = 0; i < thresholds.length; ++i) {
            cfvos[i] = ((XSSFConditionalFormattingThreshold)thresholds[i]).getCTCfvo();
        }
        this._iconset.setCfvoArray(cfvos);
    }

    public XSSFConditionalFormattingThreshold createThreshold() {
        return new XSSFConditionalFormattingThreshold(this._iconset.addNewCfvo());
    }
}

