/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.usermodel;

import com.fr.third.v2.org.apache.poi.POIXMLException;
import com.fr.third.v2.org.apache.poi.POIXMLTypeLoader;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackagePart;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackageRelationship;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFSheet;
import com.fr.third.v2.org.apache.xmlbeans.XmlException;
import com.fr.third.v2.org.apache.xmlbeans.XmlOptions;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTChartsheet;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDrawing;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTLegacyDrawing;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.ChartsheetDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;

public class XSSFChartSheet
extends XSSFSheet {
    private static final byte[] BLANK_WORKSHEET = XSSFChartSheet.blankWorksheet();
    protected CTChartsheet chartsheet;

    protected XSSFChartSheet(PackagePart part) {
        super(part);
    }

    @Deprecated
    protected XSSFChartSheet(PackagePart part, PackageRelationship rel) {
        this(part);
    }

    protected void read(InputStream is) throws IOException {
        super.read(new ByteArrayInputStream(BLANK_WORKSHEET));
        try {
            this.chartsheet = ChartsheetDocument.Factory.parse(is, POIXMLTypeLoader.DEFAULT_XML_OPTIONS).getChartsheet();
        }
        catch (XmlException e) {
            throw new POIXMLException(e);
        }
    }

    public CTChartsheet getCTChartsheet() {
        return this.chartsheet;
    }

    protected CTDrawing getCTDrawing() {
        return this.chartsheet.getDrawing();
    }

    protected CTLegacyDrawing getCTLegacyDrawing() {
        return this.chartsheet.getLegacyDrawing();
    }

    protected void write(OutputStream out) throws IOException {
        XmlOptions xmlOptions = new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTChartsheet.type.getName().getNamespaceURI(), "chartsheet"));
        this.chartsheet.save(out, xmlOptions);
    }

    private static byte[] blankWorksheet() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            new XSSFSheet().write(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }
}

