/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.streaming;

import com.fr.third.v2.org.apache.poi.util.TempFile;
import com.fr.third.v2.org.apache.poi.xssf.model.SharedStringsTable;
import com.fr.third.v2.org.apache.poi.xssf.streaming.SheetDataWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZIPSheetDataWriter
extends SheetDataWriter {
    public GZIPSheetDataWriter() throws IOException {
    }

    public GZIPSheetDataWriter(SharedStringsTable sharedStringsTable) throws IOException {
        super(sharedStringsTable);
    }

    public File createTempFile() throws IOException {
        return TempFile.createTempFile("poi-sxssf-sheet-xml", ".gz");
    }

    public Writer createWriter(File fd) throws IOException {
        return new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(fd)), "UTF-8");
    }

    public InputStream getWorksheetXMLInputStream() throws IOException {
        File fd = this.getTempFile();
        return new GZIPInputStream(new FileInputStream(fd));
    }
}

