/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.util;

import com.fr.third.v2.org.apache.poi.util.Internal;
import com.fr.third.v2.org.apache.poi.util.NullLogger;
import com.fr.third.v2.org.apache.poi.util.POILogger;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class POILogFactory {
    private static Map<String, POILogger> _loggers = new HashMap<String, POILogger>();
    private static final POILogger _nullLogger = new NullLogger();
    static String _loggerClassName = null;

    private POILogFactory() {
    }

    public static POILogger getLogger(Class<?> theclass) {
        return POILogFactory.getLogger(theclass.getName());
    }

    public static POILogger getLogger(String cat) {
        POILogger logger = null;
        if (_loggerClassName == null) {
            try {
                _loggerClassName = System.getProperty("org.apache.poi.util.POILogger");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (_loggerClassName == null) {
                _loggerClassName = _nullLogger.getClass().getName();
            }
        }
        if (_loggerClassName.equals(_nullLogger.getClass().getName())) {
            return _nullLogger;
        }
        logger = _loggers.get(cat);
        if (logger == null) {
            try {
                Class<?> loggerClass = Class.forName(_loggerClassName);
                logger = (POILogger)loggerClass.newInstance();
                logger.initialize(cat);
            }
            catch (Exception e) {
                logger = _nullLogger;
                _loggerClassName = _nullLogger.getClass().getName();
            }
            _loggers.put(cat, logger);
        }
        return logger;
    }
}

