/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.ss.formula.functions;

import com.fr.third.v2.org.apache.poi.ss.formula.OperationEvaluationContext;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.ErrorEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.EvaluationException;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.NumberEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.OperandResolver;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.ValueEval;
import com.fr.third.v2.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import com.fr.third.v2.org.apache.poi.ss.formula.functions.FreeRefFunction;
import com.fr.third.v2.org.apache.poi.ss.formula.functions.NumericFunction;
import com.fr.third.v2.org.apache.poi.ss.usermodel.DateUtil;
import com.fr.third.v2.org.apache.poi.util.LocaleUtil;
import java.util.Calendar;

public class WeekNum
extends Fixed2ArgFunction
implements FreeRefFunction {
    public static final FreeRefFunction instance = new WeekNum();

    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval serialNumVE, ValueEval returnTypeVE) {
        double serialNum = 0.0;
        try {
            serialNum = NumericFunction.singleOperandEvaluate(serialNumVE, srcRowIndex, srcColumnIndex);
        }
        catch (EvaluationException e) {
            return ErrorEval.VALUE_INVALID;
        }
        Calendar serialNumCalendar = LocaleUtil.getLocaleCalendar();
        serialNumCalendar.setTime(DateUtil.getJavaDate(serialNum, false));
        int returnType = 0;
        try {
            ValueEval ve = OperandResolver.getSingleValue(returnTypeVE, srcRowIndex, srcColumnIndex);
            returnType = OperandResolver.coerceValueToInt(ve);
        }
        catch (EvaluationException e) {
            return ErrorEval.NUM_ERROR;
        }
        if (returnType != 1 && returnType != 2) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(this.getWeekNo(serialNumCalendar, returnType));
    }

    public int getWeekNo(Calendar cal, int weekStartOn) {
        if (weekStartOn == 1) {
            cal.setFirstDayOfWeek(1);
        } else {
            cal.setFirstDayOfWeek(2);
        }
        return cal.get(3);
    }

    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        if (args.length == 2) {
            return this.evaluate(ec.getRowIndex(), ec.getColumnIndex(), args[0], args[1]);
        }
        return ErrorEval.VALUE_INVALID;
    }
}

