/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.ss.format;

import com.fr.third.v2.org.apache.poi.ss.format.CellDateFormatter;
import com.fr.third.v2.org.apache.poi.ss.format.CellElapsedFormatter;
import com.fr.third.v2.org.apache.poi.ss.format.CellFormatter;
import com.fr.third.v2.org.apache.poi.ss.format.CellGeneralFormatter;
import com.fr.third.v2.org.apache.poi.ss.format.CellNumberFormatter;
import com.fr.third.v2.org.apache.poi.ss.format.CellTextFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CellFormatType {
    GENERAL{

        CellFormatter formatter(String pattern) {
            return new CellGeneralFormatter();
        }

        boolean isSpecial(char ch) {
            return false;
        }
    }
    ,
    NUMBER{

        boolean isSpecial(char ch) {
            return false;
        }

        CellFormatter formatter(String pattern) {
            return new CellNumberFormatter(pattern);
        }
    }
    ,
    DATE{

        boolean isSpecial(char ch) {
            return ch == '\'' || ch <= '\u007f' && Character.isLetter(ch);
        }

        CellFormatter formatter(String pattern) {
            return new CellDateFormatter(pattern);
        }
    }
    ,
    ELAPSED{

        boolean isSpecial(char ch) {
            return false;
        }

        CellFormatter formatter(String pattern) {
            return new CellElapsedFormatter(pattern);
        }
    }
    ,
    TEXT{

        boolean isSpecial(char ch) {
            return false;
        }

        CellFormatter formatter(String pattern) {
            return new CellTextFormatter(pattern);
        }
    };


    abstract boolean isSpecial(char var1);

    abstract CellFormatter formatter(String var1);
}

