/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.poifs.storage;

import com.fr.third.v2.org.apache.poi.poifs.common.POIFSBigBlockSize;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.BATManaged;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.OPOIFSDocument;
import com.fr.third.v2.org.apache.poi.poifs.property.RootProperty;
import com.fr.third.v2.org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import com.fr.third.v2.org.apache.poi.poifs.storage.BlockWritable;
import com.fr.third.v2.org.apache.poi.poifs.storage.SmallDocumentBlock;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmallBlockTableWriter
implements BlockWritable,
BATManaged {
    private BlockAllocationTableWriter _sbat;
    private List<SmallDocumentBlock> _small_blocks;
    private int _big_block_count;
    private RootProperty _root;

    public SmallBlockTableWriter(POIFSBigBlockSize bigBlockSize, List<OPOIFSDocument> documents, RootProperty root) {
        this._sbat = new BlockAllocationTableWriter(bigBlockSize);
        this._small_blocks = new ArrayList<SmallDocumentBlock>();
        this._root = root;
        for (OPOIFSDocument doc : documents) {
            SmallDocumentBlock[] blocks = doc.getSmallBlocks();
            if (blocks.length != 0) {
                doc.setStartBlock(this._sbat.allocateSpace(blocks.length));
                for (int j = 0; j < blocks.length; ++j) {
                    this._small_blocks.add(blocks[j]);
                }
                continue;
            }
            doc.setStartBlock(-2);
        }
        this._sbat.simpleCreateBlocks();
        this._root.setSize(this._small_blocks.size());
        this._big_block_count = SmallDocumentBlock.fill(bigBlockSize, this._small_blocks);
    }

    public int getSBATBlockCount() {
        return (this._big_block_count + 15) / 16;
    }

    public BlockAllocationTableWriter getSBAT() {
        return this._sbat;
    }

    @Override
    public int countBlocks() {
        return this._big_block_count;
    }

    @Override
    public void setStartBlock(int start_block) {
        this._root.setStartBlock(start_block);
    }

    @Override
    public void writeBlocks(OutputStream stream) throws IOException {
        for (BlockWritable blockWritable : this._small_blocks) {
            blockWritable.writeBlocks(stream);
        }
    }
}

