/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.hssf.usermodel;

import com.fr.third.v2.org.apache.poi.hssf.record.HyperlinkRecord;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Hyperlink;

public class HSSFHyperlink
implements Hyperlink {
    public static final int LINK_URL = 1;
    public static final int LINK_DOCUMENT = 2;
    public static final int LINK_EMAIL = 3;
    public static final int LINK_FILE = 4;
    protected final HyperlinkRecord record;
    protected final int link_type;

    public HSSFHyperlink(int type) {
        this.link_type = type;
        this.record = new HyperlinkRecord();
        switch (type) {
            case 1: 
            case 3: {
                this.record.newUrlLink();
                break;
            }
            case 4: {
                this.record.newFileLink();
                break;
            }
            case 2: {
                this.record.newDocumentLink();
            }
        }
    }

    protected HSSFHyperlink(HyperlinkRecord record) {
        this.record = record;
        this.link_type = this.getType(record);
    }

    private int getType(HyperlinkRecord record) {
        int link_type = record.isFileLink() ? 4 : (record.isDocumentLink() ? 2 : (record.getAddress() != null && record.getAddress().startsWith("mailto:") ? 3 : 1));
        return link_type;
    }

    protected HSSFHyperlink(Hyperlink other) {
        if (other instanceof HSSFHyperlink) {
            HSSFHyperlink hlink = (HSSFHyperlink)other;
            this.record = hlink.record.clone();
            this.link_type = this.getType(this.record);
        } else {
            this.link_type = other.getType();
            this.record = new HyperlinkRecord();
            this.setFirstRow(other.getFirstRow());
            this.setFirstColumn(other.getFirstColumn());
            this.setLastRow(other.getLastRow());
            this.setLastColumn(other.getLastColumn());
        }
    }

    public int getFirstRow() {
        return this.record.getFirstRow();
    }

    public void setFirstRow(int row) {
        this.record.setFirstRow(row);
    }

    public int getLastRow() {
        return this.record.getLastRow();
    }

    public void setLastRow(int row) {
        this.record.setLastRow(row);
    }

    public int getFirstColumn() {
        return this.record.getFirstColumn();
    }

    public void setFirstColumn(int col) {
        this.record.setFirstColumn((short)col);
    }

    public int getLastColumn() {
        return this.record.getLastColumn();
    }

    public void setLastColumn(int col) {
        this.record.setLastColumn((short)col);
    }

    public String getAddress() {
        return this.record.getAddress();
    }

    public String getTextMark() {
        return this.record.getTextMark();
    }

    public void setTextMark(String textMark) {
        this.record.setTextMark(textMark);
    }

    public String getShortFilename() {
        return this.record.getShortFilename();
    }

    public void setShortFilename(String shortFilename) {
        this.record.setShortFilename(shortFilename);
    }

    public void setAddress(String address) {
        this.record.setAddress(address);
    }

    public String getLabel() {
        return this.record.getLabel();
    }

    public void setLabel(String label) {
        this.record.setLabel(label);
    }

    public int getType() {
        return this.link_type;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HSSFHyperlink)) {
            return false;
        }
        HSSFHyperlink otherLink = (HSSFHyperlink)other;
        return this.record == otherLink.record;
    }

    public int hashCode() {
        return this.record.hashCode();
    }
}

