/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.persist;

import com.fr.third.org.hsqldb.lib.DoubleIntIndex;

public class DataFileBlockManager {
    private DoubleIntIndex lookup;
    private final int capacity;
    private int midSize;
    private final int scale;
    private long releaseCount;
    private long requestCount;
    private long requestSize;
    long lostFreeBlockSize;
    boolean isModified;

    public DataFileBlockManager(int capacity, int scale, long lostSize) {
        this.lookup = new DoubleIntIndex(capacity, true);
        this.lookup.setValuesSearchTarget();
        this.capacity = capacity;
        this.scale = scale;
        this.lostFreeBlockSize = lostSize;
        this.midSize = 128;
    }

    void add(int pos, int rowSize) {
        this.isModified = true;
        if (this.capacity == 0) {
            this.lostFreeBlockSize += (long)rowSize;
            return;
        }
        ++this.releaseCount;
        if (this.lookup.size() == this.capacity) {
            this.resetList();
        }
        this.lookup.add(pos, rowSize);
    }

    int get(int rowSize) {
        if (this.lookup.size() == 0) {
            return -1;
        }
        int index = this.lookup.findFirstGreaterEqualKeyIndex(rowSize);
        if (index == -1) {
            return -1;
        }
        ++this.requestCount;
        this.requestSize += (long)rowSize;
        int length = this.lookup.getValue(index);
        int difference = length - rowSize;
        int key = this.lookup.getKey(index);
        this.lookup.remove(index);
        if (difference >= this.midSize) {
            int pos = key + rowSize / this.scale;
            this.lookup.add(pos, difference);
        } else {
            this.lostFreeBlockSize += (long)difference;
        }
        return key;
    }

    int size() {
        return this.lookup.size();
    }

    long getLostBlocksSize() {
        return this.lostFreeBlockSize;
    }

    boolean isModified() {
        return this.isModified;
    }

    void clear() {
        this.removeBlocks(this.lookup.size());
    }

    private void resetList() {
        int first;
        if (this.requestCount != 0L) {
            this.midSize = (int)(this.requestSize / this.requestCount);
        }
        if ((first = this.lookup.findFirstGreaterEqualSlotIndex(this.midSize)) < this.lookup.size() / 4) {
            first = this.lookup.size() / 4;
        }
        this.removeBlocks(first);
    }

    private void removeBlocks(int blocks) {
        for (int i = 0; i < blocks; ++i) {
            this.lostFreeBlockSize += (long)this.lookup.getValue(i);
        }
        this.lookup.removeRange(0, blocks);
    }

    private void checkIntegrity() throws NullPointerException {
    }
}

