/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.poifs.storage;

import com.fr.third.org.apache.poi.poifs.storage.BigBlock;
import com.fr.third.org.apache.poi.util.IntegerField;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class BATBlock
extends BigBlock {
    private static final int _entries_per_block = 128;
    private static final int _entries_per_xbat_block = 127;
    private static final int _xbat_chain_offset = 508;
    private static final byte _default_value = -1;
    private IntegerField[] _fields;
    private byte[] _data = new byte[512];

    private BATBlock() {
        Arrays.fill(this._data, (byte)-1);
        this._fields = new IntegerField[128];
        int offset = 0;
        for (int j = 0; j < 128; ++j) {
            this._fields[j] = new IntegerField(offset);
            offset += 4;
        }
    }

    public static BATBlock[] createBATBlocks(int[] entries) {
        int block_count = BATBlock.calculateStorageRequirements(entries.length);
        BATBlock[] blocks = new BATBlock[block_count];
        int index = 0;
        int remaining = entries.length;
        for (int j = 0; j < entries.length; j += 128) {
            blocks[index++] = new BATBlock(entries, j, remaining > 128 ? j + 128 : entries.length);
            remaining -= 128;
        }
        return blocks;
    }

    public static BATBlock[] createXBATBlocks(int[] entries, int startBlock) {
        int block_count = BATBlock.calculateXBATStorageRequirements(entries.length);
        BATBlock[] blocks = new BATBlock[block_count];
        int index = 0;
        int remaining = entries.length;
        if (block_count != 0) {
            for (int j = 0; j < entries.length; j += 127) {
                blocks[index++] = new BATBlock(entries, j, remaining > 127 ? j + 127 : entries.length);
                remaining -= 127;
            }
            for (index = 0; index < blocks.length - 1; ++index) {
                blocks[index].setXBATChain(startBlock + index + 1);
            }
            blocks[index].setXBATChain(-2);
        }
        return blocks;
    }

    public static int calculateStorageRequirements(int entryCount) {
        return (entryCount + 128 - 1) / 128;
    }

    public static int calculateXBATStorageRequirements(int entryCount) {
        return (entryCount + 127 - 1) / 127;
    }

    public static final int entriesPerBlock() {
        return 128;
    }

    public static final int entriesPerXBATBlock() {
        return 127;
    }

    public static final int getXBATChainOffset() {
        return 508;
    }

    private void setXBATChain(int chainIndex) {
        this._fields[127].set(chainIndex, this._data);
    }

    private BATBlock(int[] entries, int start_index, int end_index) {
        this();
        for (int k = start_index; k < end_index; ++k) {
            this._fields[k - start_index].set(entries[k], this._data);
        }
    }

    void writeData(OutputStream stream) throws IOException {
        this.doWriteData(stream, this._data);
    }
}

