/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;

public abstract class TextFunction
implements Function {
    protected static final String EMPTY_STRING = "";

    protected ValueEval singleOperandEvaluate(Eval eval, int srcRow, short srcCol) {
        ValueEval retval;
        if (eval instanceof AreaEval) {
            AreaEval ae = (AreaEval)eval;
            if (ae.contains(srcRow, srcCol)) {
                retval = ErrorEval.CIRCULAR_REF_ERROR;
            } else if (ae.isRow()) {
                if (ae.containsColumn(srcCol)) {
                    ValueEval ve = ae.getValueAt(ae.getFirstRow(), srcCol);
                    retval = this.attemptXlateToText(ve);
                } else {
                    retval = ErrorEval.VALUE_INVALID;
                }
            } else if (ae.isColumn()) {
                if (ae.containsRow(srcRow)) {
                    ValueEval ve = ae.getValueAt(srcRow, ae.getFirstColumn());
                    retval = this.attemptXlateToText(ve);
                } else {
                    retval = ErrorEval.VALUE_INVALID;
                }
            } else {
                retval = ErrorEval.VALUE_INVALID;
            }
        } else {
            retval = this.attemptXlateToText((ValueEval)eval);
        }
        return retval;
    }

    protected ValueEval attemptXlateToText(ValueEval ve) {
        RefEval re;
        ValueEval ive;
        ValueEval retval = ve instanceof StringValueEval ? ve : (ve instanceof RefEval ? ((ive = (re = (RefEval)ve).getInnerValueEval()) instanceof StringValueEval ? ive : (ive instanceof BlankEval ? ive : ErrorEval.VALUE_INVALID)) : (ve instanceof BlankEval ? ve : ErrorEval.VALUE_INVALID));
        return retval;
    }
}

