/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.NumericFunction;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDateUtil;
import java.util.GregorianCalendar;

public class Date
extends NumericFunction {
    public Eval evaluate(Eval[] operands, int srcCellRow, short srcCellCol) {
        ValueEval[] ve;
        if (operands.length == 3 && this.validValues(ve = new ValueEval[]{this.singleOperandEvaluate(operands[0], srcCellRow, srcCellCol), this.singleOperandEvaluate(operands[1], srcCellRow, srcCellCol), this.singleOperandEvaluate(operands[2], srcCellRow, srcCellCol)})) {
            int year = this.getYear(ve[0]);
            int month = (int)((NumericValueEval)ve[1]).getNumberValue() - 1;
            int day = (int)((NumericValueEval)ve[2]).getNumberValue();
            if (year < 0 || month < 0 || day < 0) {
                return ErrorEval.VALUE_INVALID;
            }
            if (year == 1900 && month == 1 && day == 29) {
                return new NumberEval(60.0);
            }
            if (year == 1900 && (month == 0 && day >= 60 || month == 1 && day >= 30)) {
                --day;
            }
            GregorianCalendar c = new GregorianCalendar();
            c.set(year, month, day, 0, 0, 0);
            c.set(14, 0);
            return new NumberEval(HSSFDateUtil.getExcelDate(c.getTime(), false));
        }
        return ErrorEval.VALUE_INVALID;
    }

    private int getYear(ValueEval ve) {
        int year = (int)((NumericValueEval)ve).getNumberValue();
        if (year < 0) {
            return -1;
        }
        return year < 1900 ? 1900 + year : year;
    }

    private boolean validValues(ValueEval[] values) {
        for (int i = 0; i < values.length; ++i) {
            ValueEval value = values[i];
            if (value instanceof RefEval) {
                RefEval re = (RefEval)value;
                ValueEval ive = re.getInnerValueEval();
                if (ive instanceof BlankEval) {
                    value = new NumberEval(0.0);
                } else if (ive instanceof NumericValueEval) {
                    value = ive;
                } else {
                    return false;
                }
            }
            if (value instanceof NumericValueEval) continue;
            return false;
        }
        return true;
    }
}

