/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;

public class HeaderRecord
extends Record {
    public static final short sid = 20;
    private byte field_1_header_len;
    private byte field_2_reserved;
    private byte field_3_unicode_flag;
    private String field_4_header;

    public HeaderRecord() {
    }

    public HeaderRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 20) {
            throw new RecordFormatException("NOT A HEADERRECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        if (in.remaining() > 0) {
            this.field_1_header_len = in.readByte();
            this.field_2_reserved = in.readByte();
            this.field_3_unicode_flag = in.readByte();
            this.field_4_header = this.isMultibyte() ? in.readUnicodeLEString(LittleEndian.ubyteToInt(this.field_1_header_len)) : in.readCompressedUnicode(LittleEndian.ubyteToInt(this.field_1_header_len));
        }
    }

    public boolean isMultibyte() {
        return (this.field_3_unicode_flag & 0xFF) == 1;
    }

    public void setHeaderLength(byte len) {
        this.field_1_header_len = len;
    }

    public void setHeader(String header) {
        this.field_4_header = header;
        this.field_3_unicode_flag = (byte)(StringUtil.hasMultibyte(this.field_4_header) ? 1 : 0);
    }

    public short getHeaderLength() {
        return (short)(0xFF & this.field_1_header_len);
    }

    public String getHeader() {
        return this.field_4_header;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[HEADER]\n");
        buffer.append("    .length         = ").append(this.getHeaderLength()).append("\n");
        buffer.append("    .header         = ").append(this.getHeader()).append("\n");
        buffer.append("[/HEADER]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int len = 4;
        if (this.getHeaderLength() != 0) {
            len += 3;
        }
        short bytelen = (short)(this.isMultibyte() ? this.getHeaderLength() * 2 : this.getHeaderLength());
        LittleEndian.putShort(data, 0 + offset, (short)20);
        LittleEndian.putShort(data, 2 + offset, (short)(len - 4 + bytelen));
        if (this.getHeaderLength() > 0) {
            data[4 + offset] = (byte)this.getHeaderLength();
            data[6 + offset] = this.field_3_unicode_flag;
            if (this.isMultibyte()) {
                StringUtil.putUnicodeLE(this.getHeader(), data, 7 + offset);
            } else {
                StringUtil.putCompressedUnicode(this.getHeader(), data, 7 + offset);
            }
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int retval = 4;
        if (this.getHeaderLength() != 0) {
            retval += 3;
        }
        return this.isMultibyte() ? retval + this.getHeaderLength() * 2 : retval + this.getHeaderLength();
    }

    public short getSid() {
        return 20;
    }

    public Object clone() {
        HeaderRecord rec = new HeaderRecord();
        rec.field_1_header_len = this.field_1_header_len;
        rec.field_2_reserved = this.field_2_reserved;
        rec.field_3_unicode_flag = this.field_3_unicode_flag;
        rec.field_4_header = this.field_4_header;
        return rec;
    }
}

