/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.model;

import com.fr.third.org.apache.poi.ddf.EscherOptRecord;
import com.fr.third.org.apache.poi.ddf.EscherProperty;
import com.fr.third.org.apache.poi.ddf.EscherSimpleProperty;
import com.fr.third.org.apache.poi.hssf.model.TextboxShape;
import com.fr.third.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import com.fr.third.org.apache.poi.hssf.record.NoteRecord;
import com.fr.third.org.apache.poi.hssf.record.NoteStructureSubRecord;
import com.fr.third.org.apache.poi.hssf.record.ObjRecord;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFComment;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFShape;
import java.util.Iterator;
import java.util.List;

public class CommentShape
extends TextboxShape {
    private NoteRecord note;

    public CommentShape(HSSFComment hssfShape, int shapeId) {
        super(hssfShape, shapeId);
        this.note = this.createNoteRecord(hssfShape, shapeId);
        ObjRecord obj = this.getObjRecord();
        List records = obj.getSubRecords();
        int cmoIdx = 0;
        for (int i = 0; i < records.size(); ++i) {
            Object r = records.get(i);
            if (!(r instanceof CommonObjectDataSubRecord)) continue;
            CommonObjectDataSubRecord cmo = (CommonObjectDataSubRecord)r;
            cmo.setAutofill(false);
            cmoIdx = i;
        }
        NoteStructureSubRecord u = new NoteStructureSubRecord();
        obj.addSubRecord(cmoIdx + 1, u);
    }

    private NoteRecord createNoteRecord(HSSFComment shape, int shapeId) {
        NoteRecord note = new NoteRecord();
        note.setColumn(shape.getColumn());
        note.setRow((short)shape.getRow());
        note.setFlags(shape.isVisible() ? (short)2 : 0);
        note.setShapeId((short)shapeId);
        note.setAuthor(shape.getAuthor() == null ? "" : shape.getAuthor());
        return note;
    }

    protected int addStandardOptions(HSSFShape shape, EscherOptRecord opt) {
        super.addStandardOptions(shape, opt);
        List props = opt.getEscherProperties();
        Iterator iterator = props.iterator();
        while (iterator.hasNext()) {
            EscherProperty prop = (EscherProperty)iterator.next();
            switch (prop.getId()) {
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 387: 
                case 448: 
                case 959: {
                    iterator.remove();
                }
            }
        }
        HSSFComment comment = (HSSFComment)shape;
        opt.addEscherProperty(new EscherSimpleProperty(959, comment.isVisible() ? 655360 : 655362));
        opt.addEscherProperty(new EscherSimpleProperty(575, 196611));
        opt.addEscherProperty(new EscherSimpleProperty(513, 0));
        opt.sortProperties();
        return opt.getEscherProperties().size();
    }

    public NoteRecord getNoteRecord() {
        return this.note;
    }
}

