/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream.xerces.util;

public class SymbolHash {
    protected int fTableSize = 101;
    protected Entry[] fBuckets;
    protected int fNum = 0;

    public SymbolHash() {
        this.fBuckets = new Entry[this.fTableSize];
    }

    public SymbolHash(int size) {
        this.fTableSize = size;
        this.fBuckets = new Entry[this.fTableSize];
    }

    public void put(Object key, Object value) {
        int bucket = (key.hashCode() & Integer.MAX_VALUE) % this.fTableSize;
        Entry entry = this.search(key, bucket);
        if (entry != null) {
            entry.value = value;
        } else {
            this.fBuckets[bucket] = entry = new Entry(key, value, this.fBuckets[bucket]);
            ++this.fNum;
        }
    }

    public Object get(Object key) {
        int bucket = (key.hashCode() & Integer.MAX_VALUE) % this.fTableSize;
        Entry entry = this.search(key, bucket);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    public int getLength() {
        return this.fNum;
    }

    public int getValues(Object[] elements, int from) {
        int i = 0;
        int j = 0;
        while (i < this.fTableSize && j < this.fNum) {
            Entry entry = this.fBuckets[i];
            while (entry != null) {
                elements[from + j] = entry.value;
                ++j;
                entry = entry.next;
            }
            ++i;
        }
        return this.fNum;
    }

    public SymbolHash makeClone() {
        SymbolHash newTable = new SymbolHash(this.fTableSize);
        newTable.fNum = this.fNum;
        int i = 0;
        while (i < this.fTableSize) {
            if (this.fBuckets[i] != null) {
                newTable.fBuckets[i] = this.fBuckets[i].makeClone();
            }
            ++i;
        }
        return newTable;
    }

    public void clear() {
        int i = 0;
        while (i < this.fTableSize) {
            this.fBuckets[i] = null;
            ++i;
        }
        this.fNum = 0;
    }

    protected Entry search(Object key, int bucket) {
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            if (key.equals(entry.key)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    protected static final class Entry {
        public Object key;
        public Object value;
        public Entry next;

        public Entry() {
            this.key = null;
            this.value = null;
            this.next = null;
        }

        public Entry(Object key, Object value, Entry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public Entry makeClone() {
            Entry entry = new Entry();
            entry.key = this.key;
            entry.value = this.value;
            if (this.next != null) {
                entry.next = this.next.makeClone();
            }
            return entry;
        }
    }
}

