/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.stream.BufferManager;
import com.fr.third.javax.xml.stream.xerces.impl.io.ASCIIReader;
import com.fr.third.javax.xml.stream.xerces.impl.io.UCSReader;
import com.fr.third.javax.xml.stream.xerces.impl.io.UTF8Reader;
import com.fr.third.javax.xml.stream.xerces.util.EncodingMap;
import com.fr.third.javax.xml.stream.xerces.util.XMLChar;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.Locale;

public class StreamBufferManager
extends BufferManager {
    static final int DEFAULT_LENGTH = 8192;
    static final boolean DEBUG = false;
    CharBuffer charBuffer = null;
    Reader fReader = null;
    boolean fAllowJavaEncodings = true;

    public StreamBufferManager(InputStream stream, String encoding) throws IOException {
        this.init(stream, encoding);
    }

    void init(InputStream istream, String encoding) throws IOException {
        Boolean isBigEndian = null;
        RewindableInputStream stream = new RewindableInputStream(istream);
        if (encoding == null) {
            byte[] b4 = new byte[4];
            int count = 0;
            while (count < 4) {
                b4[count] = (byte)((InputStream)stream).read();
                ++count;
            }
            if (count == 4) {
                Object[] encodingDesc = this.getEncodingName(b4, count);
                encoding = (String)encodingDesc[0];
                isBigEndian = (Boolean)encodingDesc[1];
                ((InputStream)stream).reset();
                boolean offset = false;
                if (count > 2 && encoding.equals("UTF-8")) {
                    int b0 = b4[0] & 0xFF;
                    int b1 = b4[1] & 0xFF;
                    int b2 = b4[2] & 0xFF;
                    if (b0 == 239 && b1 == 187 && b2 == 191) {
                        ((InputStream)stream).skip(3L);
                    }
                }
                this.fReader = this.createReader(stream, encoding, isBigEndian);
            } else {
                this.fReader = this.createReader(stream, encoding, isBigEndian);
            }
        } else {
            this.fReader = this.createReader(stream, encoding, isBigEndian);
        }
        this.charBuffer = CharBuffer.allocate(8192);
    }

    public CharBuffer getCharBuffer() {
        return this.charBuffer;
    }

    public boolean getMore() throws IOException {
        int offset;
        char[] ch;
        int count;
        if (this.charBuffer.position() != 0) {
            this.charBuffer.compact();
        }
        if ((count = this.fReader.read(ch = this.charBuffer.array(), offset = this.charBuffer.position(), this.charBuffer.capacity())) == -1) {
            this.endOfStream = true;
            return false;
        }
        this.charBuffer = CharBuffer.wrap(ch);
        this.charBuffer.limit(count);
        return count > 0;
    }

    protected Reader createReader(InputStream inputStream, String encoding, Boolean isBigEndian) throws IOException {
        String ENCODING;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if ((ENCODING = encoding.toUpperCase(Locale.ENGLISH)).equals("UTF-8")) {
            return new UTF8Reader(inputStream, 8192, null, Locale.getDefault());
        }
        if (ENCODING.equals("US-ASCII")) {
            return new ASCIIReader(inputStream, 8192, null, Locale.getDefault());
        }
        if (ENCODING.equals("ISO-10646-UCS-4")) {
            if (isBigEndian != null) {
                boolean isBE = isBigEndian;
                if (isBE) {
                    return new UCSReader(inputStream, 8);
                }
                return new UCSReader(inputStream, 4);
            }
            throw new IOException("Encoding byte order not supported");
        }
        if (ENCODING.equals("ISO-10646-UCS-2")) {
            if (isBigEndian != null) {
                boolean isBE = isBigEndian;
                if (isBE) {
                    return new UCSReader(inputStream, 2);
                }
                return new UCSReader(inputStream, 1);
            }
            throw new IOException("Encoding byte order not supported");
        }
        boolean validIANA = XMLChar.isValidIANAEncoding(encoding);
        boolean validJava = XMLChar.isValidJavaEncoding(encoding);
        if (!validIANA || this.fAllowJavaEncodings && !validJava) {
            throw new IOException("Encoding declaration " + encoding + "not valid");
        }
        String javaEncoding = EncodingMap.getIANA2JavaMapping(ENCODING);
        if (javaEncoding == null) {
            if (this.fAllowJavaEncodings) {
                javaEncoding = encoding;
            } else {
                throw new IOException("Encoding " + encoding + " not supported");
            }
        }
        return new BufferedReader(new InputStreamReader(inputStream, javaEncoding));
    }

    int getLength() {
        return 8192;
    }

    public static void main(String[] args) {
        try {
            File file = new File(args[0]);
            System.out.println("url parameter = " + file.toURI().toString());
            URL url = new URL(file.toURI().toString());
            StreamBufferManager sb = new StreamBufferManager(url.openStream(), "UTF-8");
            CharBuffer cb = sb.getCharBuffer();
            int i = 0;
            while (sb.getMore()) {
                System.out.println("Loop " + i++ + " = " + sb.getCharBuffer());
            }
            System.out.println("End of stream reached = " + sb.endOfStream());
            System.out.println("Total no. of loops required = " + i);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void close() throws IOException {
        if (this.fReader != null) {
            this.fReader.close();
        }
    }

    public void setEncoding(String encoding) throws IOException {
    }

    public boolean arrangeCapacity(int length) throws IOException {
        return false;
    }

    protected final class RewindableInputStream
    extends InputStream {
        private InputStream fInputStream;
        private byte[] fData = new byte[64];
        private int fStartOffset;
        private int fEndOffset;
        private int fOffset;
        private int fLength;
        private int fMark;
        static final int DEFAULT_XMLDECL_BUFFER_SIZE = 64;

        public RewindableInputStream(InputStream is) {
            this.fInputStream = is;
            this.fStartOffset = 0;
            this.fEndOffset = -1;
            this.fOffset = 0;
            this.fLength = 0;
            this.fMark = 0;
        }

        public void setStartOffset(int offset) {
            this.fStartOffset = offset;
        }

        public void rewind() {
            this.fOffset = this.fStartOffset;
        }

        public int read() throws IOException {
            int b = 0;
            if (this.fOffset < this.fLength) {
                return this.fData[this.fOffset++] & 0xFF;
            }
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            if (this.fOffset == this.fData.length) {
                byte[] newData = new byte[this.fOffset << 1];
                System.arraycopy(this.fData, 0, newData, 0, this.fOffset);
                this.fData = newData;
            }
            if ((b = this.fInputStream.read()) == -1) {
                this.fEndOffset = this.fOffset;
                return -1;
            }
            this.fData[this.fLength++] = (byte)b;
            ++this.fOffset;
            return b & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int bytesLeft = this.fLength - this.fOffset;
            if (bytesLeft == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return this.fInputStream.read(b, off, len);
            }
            if (len < bytesLeft) {
                if (len <= 0) {
                    return 0;
                }
            } else {
                len = bytesLeft;
            }
            if (b != null) {
                System.arraycopy(this.fData, this.fOffset, b, off, len);
            }
            this.fOffset += len;
            return len;
        }

        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            int bytesLeft = this.fLength - this.fOffset;
            if (bytesLeft == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return 0L;
                }
                return this.fInputStream.skip(n);
            }
            if (n <= (long)bytesLeft) {
                this.fOffset = (int)((long)this.fOffset + n);
                return n;
            }
            this.fOffset += bytesLeft;
            if (this.fOffset == this.fEndOffset) {
                return bytesLeft;
            }
            return this.fInputStream.skip(n -= (long)bytesLeft) + (long)bytesLeft;
        }

        public int available() throws IOException {
            int bytesLeft = this.fLength - this.fOffset;
            if (bytesLeft == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return this.fInputStream.available();
            }
            return bytesLeft;
        }

        public void mark(int howMuch) {
            this.fMark = this.fOffset;
        }

        public void reset() {
            this.fOffset = this.fMark;
        }

        public boolean markSupported() {
            return true;
        }

        public void close() throws IOException {
            if (this.fInputStream != null) {
                this.fInputStream.close();
                this.fInputStream = null;
            }
        }
    }
}

