/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.hyphenation;

import com.fr.third.fr.pdf.io.util.ResourceUtil;
import com.fr.third.fr.pdf.layout.hyphenation.Hyphenation;
import com.fr.third.fr.pdf.layout.hyphenation.HyphenationException;
import com.fr.third.fr.pdf.layout.hyphenation.HyphenationTree;
import com.fr.third.fr.pdf.layout.hyphenation.HyphenationTreeCache;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Hyphenator {
    private static final String HYPHENATION_DEFAULT_RESOURCE = "com/fr/third/itextpdf/hyph/";
    private static Logger log = LoggerFactory.getLogger(Hyphenator.class);
    private static HyphenationTreeCache hTreeCache;
    private static List<String> additionalHyphenationFileDirectories;
    protected String lang;
    protected String country;
    int leftMin;
    int rightMin;
    Map<String, String> hyphPathNames;

    public Hyphenator(String lang, String country, int leftMin, int rightMin) {
        this.lang = lang;
        this.country = country;
        this.leftMin = leftMin;
        this.rightMin = rightMin;
    }

    public Hyphenator(String lang, String country, int leftMin, int rightMin, Map<String, String> hyphPathNames) {
        this(lang, country, leftMin, rightMin);
        this.hyphPathNames = hyphPathNames;
    }

    public static synchronized void registerAdditionalHyphenationFileDirectory(String directory) {
        if (additionalHyphenationFileDirectories == null) {
            additionalHyphenationFileDirectories = new ArrayList<String>();
        }
        additionalHyphenationFileDirectories.add(directory);
    }

    public static synchronized HyphenationTreeCache getHyphenationTreeCache() {
        if (hTreeCache == null) {
            hTreeCache = new HyphenationTreeCache();
        }
        return hTreeCache;
    }

    public static synchronized void clearHyphenationTreeCache() {
        hTreeCache = new HyphenationTreeCache();
    }

    public static HyphenationTree getHyphenationTree(String lang, String country, Map<String, String> hyphPathNames) {
        String llKey;
        String llccKey = HyphenationTreeCache.constructLlccKey(lang, country);
        HyphenationTreeCache cache = Hyphenator.getHyphenationTreeCache();
        if (cache.isMissing(llccKey)) {
            return null;
        }
        HyphenationTree hTree = Hyphenator.getHyphenationTree2(lang, country, hyphPathNames);
        if (hTree == null && country != null && !country.equals("none") && !cache.isMissing(llKey = HyphenationTreeCache.constructLlccKey(lang, null))) {
            hTree = Hyphenator.getHyphenationTree2(lang, null, hyphPathNames);
            if (hTree != null && log.isDebugEnabled()) {
                log.debug("Couldn't find hyphenation pattern for lang=\"" + lang + "\",country=\"" + country + "\". Using general language pattern for lang=\"" + lang + "\" instead.");
            }
            if (hTree == null) {
                cache.noteMissing(llKey);
            } else {
                cache.cache(llccKey, hTree);
            }
        }
        if (hTree == null) {
            cache.noteMissing(llccKey);
            log.error("Couldn't find hyphenation pattern for lang=\"" + lang + "\"" + (country != null && !country.equals("none") ? ",country=\"" + country + "\"" : "") + ".");
        }
        return hTree;
    }

    public static HyphenationTree getHyphenationTree2(String lang, String country, Map<String, String> hyphPathNames) {
        InputStream defaultHyphenationResourceStream;
        String llccKey = HyphenationTreeCache.constructLlccKey(lang, country);
        HyphenationTreeCache cache = Hyphenator.getHyphenationTreeCache();
        HyphenationTree hTree = Hyphenator.getHyphenationTreeCache().getHyphenationTree(lang, country);
        if (hTree != null) {
            return hTree;
        }
        String key = HyphenationTreeCache.constructUserKey(lang, country, hyphPathNames);
        if (key == null) {
            key = llccKey;
        }
        if (additionalHyphenationFileDirectories != null) {
            String dir;
            Iterator<String> iterator = additionalHyphenationFileDirectories.iterator();
            while (iterator.hasNext() && (hTree = Hyphenator.getHyphenationTree(dir = iterator.next(), key)) == null) {
            }
        }
        if (hTree == null && (defaultHyphenationResourceStream = ResourceUtil.getResourceStream(HYPHENATION_DEFAULT_RESOURCE + key + ".xml")) != null) {
            hTree = Hyphenator.getHyphenationTree(defaultHyphenationResourceStream, key);
        }
        if (hTree != null) {
            cache.cache(llccKey, hTree);
        }
        return hTree;
    }

    public static HyphenationTree getHyphenationTree(String searchDirectory, String key) {
        String name = key + ".xml";
        try {
            FileInputStream fis = new FileInputStream(new File(new File(searchDirectory), name));
            return Hyphenator.getHyphenationTree(fis, name);
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug("I/O problem while trying to load " + name, ioe);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HyphenationTree getHyphenationTree(InputStream in, String name) {
        HyphenationTree hTree;
        if (in == null) {
            return null;
        }
        try {
            hTree = new HyphenationTree();
            hTree.loadPatterns(in, name);
        }
        catch (HyphenationException ex) {
            log.error("Can't load user patterns from XML file " + name + ": " + ex.getMessage());
            HyphenationTree hyphenationTree = null;
            return hyphenationTree;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return hTree;
    }

    public static Hyphenation hyphenate(String lang, String country, Map<String, String> hyphPathNames, String word, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country, hyphPathNames);
        if (hTree == null) {
            int leftInd;
            int curSoftHyphenIndex;
            log.warn("Soft hyphen unicode symbols will be used as hints for hyphenation");
            int softHyphen = 173;
            ArrayList<Integer> softHyphens = new ArrayList<Integer>();
            int lastSoftHyphenIndex = -1;
            while ((curSoftHyphenIndex = word.indexOf(173, lastSoftHyphenIndex + 1)) > 0) {
                softHyphens.add(curSoftHyphenIndex);
                lastSoftHyphenIndex = curSoftHyphenIndex;
            }
            int rightInd = softHyphens.size() - 1;
            for (leftInd = 0; leftInd < softHyphens.size() && word.substring(0, (Integer)softHyphens.get(leftInd)).replace(String.valueOf('\u00ad'), "").length() < leftMin; ++leftInd) {
            }
            while (rightInd >= 0 && word.substring((Integer)softHyphens.get(rightInd) + 1).replace(String.valueOf('\u00ad'), "").length() < rightMin) {
                --rightInd;
            }
            if (leftInd <= rightInd) {
                int[] hyphenationPoints = new int[rightInd - leftInd + 1];
                for (int i = leftInd; i <= rightInd; ++i) {
                    hyphenationPoints[i - leftInd] = (Integer)softHyphens.get(i);
                }
                return new Hyphenation(word, hyphenationPoints);
            }
            return null;
        }
        return hTree.hyphenate(word, leftMin, rightMin);
    }

    public static Hyphenation hyphenate(String lang, String country, String word, int leftMin, int rightMin) {
        return Hyphenator.hyphenate(lang, country, null, word, leftMin, rightMin);
    }

    public Hyphenation hyphenate(String word) {
        return Hyphenator.hyphenate(this.lang, this.country, this.hyphPathNames, word, this.leftMin, this.rightMin);
    }
}

