/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout;

import com.fr.third.fr.pdf.kernel.font.PdfFont;
import com.fr.third.fr.pdf.kernel.font.PdfFontFactory;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.layout.ElementPropertyContainer;
import com.fr.third.fr.pdf.layout.IPropertyContainer;
import com.fr.third.fr.pdf.layout.element.BlockElement;
import com.fr.third.fr.pdf.layout.element.Div;
import com.fr.third.fr.pdf.layout.element.IElement;
import com.fr.third.fr.pdf.layout.element.Image;
import com.fr.third.fr.pdf.layout.element.Paragraph;
import com.fr.third.fr.pdf.layout.property.FontKerning;
import com.fr.third.fr.pdf.layout.property.HorizontalAlignment;
import com.fr.third.fr.pdf.layout.property.TextAlignment;
import com.fr.third.fr.pdf.layout.property.VerticalAlignment;
import com.fr.third.fr.pdf.layout.renderer.FloatPropertiesMap;
import com.fr.third.fr.pdf.layout.renderer.PropertiesMap;
import com.fr.third.fr.pdf.layout.renderer.RootRenderer;
import com.fr.third.fr.pdf.layout.splitting.ISplitCharacters;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RootElement<T extends IPropertyContainer>
extends ElementPropertyContainer<T> {
    protected boolean immediateFlush = true;
    protected PdfDocument pdfDocument;
    protected List<IElement> childElements = new ArrayList<IElement>();
    protected PropertiesMap properties = new PropertiesMap();
    protected FloatPropertiesMap floatProperties = new FloatPropertiesMap();
    protected PdfFont defaultFont;
    protected ISplitCharacters defaultSplitCharacters;
    protected RootRenderer rootRenderer;
    private static Integer DefaultIntSize = 12;
    private static Integer DefaultRenderMode = 0;
    private static Float DefaultSpacingRatio = Float.valueOf(0.75f);

    public <T2 extends IElement> T add(BlockElement<T2> element) {
        this.childElements.add(element);
        this.ensureRootRendererNotNull().addChild(element.createRendererSubTree());
        return (T)this;
    }

    public T add(Image image) {
        this.childElements.add(image);
        this.ensureRootRendererNotNull().addChild(image.createRendererSubTree());
        return (T)this;
    }

    @Override
    public boolean hasProperty(int property) {
        return this.hasOwnProperty(property);
    }

    @Override
    public boolean hasOwnProperty(int property) {
        return this.properties.containsKey(property);
    }

    @Override
    public <T1> T1 getProperty(int property) {
        return this.getOwnProperty(property);
    }

    @Override
    public <T1> T1 getOwnProperty(int property) {
        return (T1)this.properties.get(property);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        try {
            switch (property) {
                case 20: {
                    if (this.defaultFont == null) {
                        this.defaultFont = PdfFontFactory.createFont();
                    }
                    return (T1)this.defaultFont;
                }
                case 61: {
                    return (T1)DefaultSpacingRatio;
                }
                case 22: {
                    return (T1)((Object)FontKerning.NO);
                }
            }
            return null;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public boolean hasFloatProperty(int key) {
        return this.floatProperties.containsKey(key);
    }

    @Override
    public float getFloatProperty(int key) {
        if (this.floatProperties.containsKey(key)) {
            return this.floatProperties.get(key);
        }
        return this.getDefaultFloatProperty(key);
    }

    @Override
    public void setFloatProperty(int key, float value) {
        this.floatProperties.put(key, value);
    }

    @Override
    public float getDefaultFloatProperty(int property) {
        switch (property) {
            case 61: {
                return 0.75f;
            }
        }
        return 0.0f;
    }

    @Override
    public void deleteOwnProperty(int property) {
        this.properties.remove(property);
    }

    @Override
    public void setProperty(int property, Object value) {
        this.properties.put(property, value);
    }

    public RootRenderer getRenderer() {
        return this.ensureRootRendererNotNull();
    }

    public T showTextAligned(String text, float x, float y, TextAlignment textAlign) {
        return this.showTextAligned(text, x, y, textAlign, 0.0f);
    }

    public T showTextAligned(String text, float x, float y, TextAlignment textAlign, float angle) {
        return this.showTextAligned(text, x, y, textAlign, VerticalAlignment.BOTTOM, angle);
    }

    public T showTextAligned(String text, float x, float y, TextAlignment textAlign, VerticalAlignment vertAlign, float angle) {
        Paragraph p = new Paragraph(text);
        return this.showTextAligned(p, x, y, this.pdfDocument.getNumberOfPages(), textAlign, vertAlign, angle);
    }

    public T showTextAlignedKerned(String text, float x, float y, TextAlignment textAlign, VerticalAlignment vertAlign, float angle) {
        Paragraph p = (Paragraph)new Paragraph(text).setFontKerning(FontKerning.YES);
        return this.showTextAligned(p, x, y, this.pdfDocument.getNumberOfPages(), textAlign, vertAlign, angle);
    }

    public T showTextAligned(Paragraph p, float x, float y, TextAlignment textAlign) {
        return this.showTextAligned(p, x, y, this.pdfDocument.getNumberOfPages(), textAlign, VerticalAlignment.BOTTOM, 0.0f);
    }

    public T showTextAligned(Paragraph p, float x, float y, TextAlignment textAlign, VerticalAlignment vertAlign) {
        return this.showTextAligned(p, x, y, this.pdfDocument.getNumberOfPages(), textAlign, vertAlign, 0.0f);
    }

    public T showTextAligned(Paragraph p, float x, float y, int pageNumber, TextAlignment textAlign, VerticalAlignment vertAlign, float angle) {
        Div div = new Div();
        ((Div)div.setTextAlignment(textAlign)).setVerticalAlignment(vertAlign);
        if (angle != 0.0f) {
            div.setRotationAngle(angle);
        }
        div.setProperty(58, Float.valueOf(x));
        div.setProperty(59, Float.valueOf(y));
        float divWidth = 1000000.0f;
        float divHeight = 1000000.0f;
        float divX = x;
        float divY = y;
        if (textAlign == TextAlignment.CENTER) {
            divX = x - divWidth / 2.0f;
            p.setHorizontalAlignment(HorizontalAlignment.CENTER);
        } else if (textAlign == TextAlignment.RIGHT) {
            divX = x - divWidth;
            p.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        }
        if (vertAlign == VerticalAlignment.MIDDLE) {
            divY = y - divHeight / 2.0f;
        } else if (vertAlign == VerticalAlignment.TOP) {
            divY = y - divHeight;
        }
        if (pageNumber == 0) {
            pageNumber = 1;
        }
        ((Div)div.setFixedPosition(pageNumber, divX, divY, divWidth)).setHeight(divHeight);
        if (p.getProperty(33) == null) {
            p.setMultipliedLeading(1.0f);
        }
        div.add((BlockElement)p.setMargins(0.0f, 0.0f, 0.0f, 0.0f));
        div.setRole(PdfName.Artifact);
        this.add(div);
        return (T)this;
    }

    protected abstract RootRenderer ensureRootRendererNotNull();
}

