/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.crypto;

import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class AESCipher {
    private PaddedBufferedBlockCipher bp;

    public AESCipher(boolean forEncryption, byte[] key, byte[] iv) {
        AESFastEngine aes = new AESFastEngine();
        CBCBlockCipher cbc = new CBCBlockCipher(aes);
        this.bp = new PaddedBufferedBlockCipher(cbc);
        KeyParameter kp = new KeyParameter(key);
        ParametersWithIV piv = new ParametersWithIV(kp, iv);
        this.bp.init(forEncryption, piv);
    }

    public byte[] update(byte[] inp, int inpOff, int inpLen) {
        int neededLen = this.bp.getUpdateOutputSize(inpLen);
        byte[] outp = neededLen > 0 ? new byte[neededLen] : new byte[]{};
        this.bp.processBytes(inp, inpOff, inpLen, outp, 0);
        return outp;
    }

    public byte[] doFinal() {
        int n;
        int neededLen = this.bp.getOutputSize(0);
        byte[] outp = new byte[neededLen];
        try {
            n = this.bp.doFinal(outp, 0);
        }
        catch (Exception ex) {
            return outp;
        }
        if (n != outp.length) {
            byte[] outp2 = new byte[n];
            System.arraycopy(outp, 0, outp2, 0, n);
            return outp2;
        }
        return outp;
    }
}

