/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.color;

import com.fr.third.fr.pdf.kernel.color.Color;
import com.fr.third.fr.pdf.kernel.pdf.colorspace.PdfColorSpace;
import com.fr.third.fr.pdf.kernel.pdf.colorspace.PdfPattern;
import com.fr.third.fr.pdf.kernel.pdf.colorspace.PdfSpecialCs;

public class PatternColor
extends Color {
    private PdfPattern pattern;
    private Color underlyingColor;

    public PatternColor(PdfPattern coloredPattern) {
        super(new PdfSpecialCs.Pattern(), null);
        this.pattern = coloredPattern;
    }

    public PatternColor(PdfPattern.Tiling uncoloredPattern, Color color) {
        this(uncoloredPattern, color.getColorSpace(), color.getColorValue());
    }

    public PatternColor(PdfPattern.Tiling uncoloredPattern, PdfColorSpace underlyingCS, float[] colorValue) {
        super(new PdfSpecialCs.UncoloredTilingPattern(underlyingCS), colorValue);
        if (underlyingCS instanceof PdfSpecialCs.Pattern) {
            throw new IllegalArgumentException("underlyingCS");
        }
        this.pattern = uncoloredPattern;
        this.underlyingColor = PatternColor.makeColor(underlyingCS, colorValue);
    }

    public PatternColor(PdfPattern.Tiling uncoloredPattern, PdfSpecialCs.UncoloredTilingPattern uncoloredTilingCS, float[] colorValue) {
        super(uncoloredTilingCS, colorValue);
        this.pattern = uncoloredPattern;
        this.underlyingColor = PatternColor.makeColor(uncoloredTilingCS.getUnderlyingColorSpace(), colorValue);
    }

    public PdfPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(PdfPattern pattern) {
        this.pattern = pattern;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        PatternColor color = (PatternColor)o;
        return this.pattern.equals(color.pattern) && (this.underlyingColor != null ? this.underlyingColor.equals(color.underlyingColor) : color.underlyingColor == null);
    }
}

