/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.util;

import com.fr.third.fr.pdf.io.util.ArrayUtil;
import java.util.ArrayList;

public final class TextUtil {
    private TextUtil() {
    }

    public static boolean isSurrogateHigh(char c) {
        return c >= '\ud800' && c <= '\udbff';
    }

    public static boolean isSurrogateLow(char c) {
        return c >= '\udc00' && c <= '\udfff';
    }

    public static boolean isSurrogatePair(String text, int idx) {
        return idx >= 0 && idx <= text.length() - 2 && TextUtil.isSurrogateHigh(text.charAt(idx)) && TextUtil.isSurrogateLow(text.charAt(idx + 1));
    }

    public static boolean isSurrogatePair(char[] text, int idx) {
        return idx >= 0 && idx <= text.length - 2 && TextUtil.isSurrogateHigh(text[idx]) && TextUtil.isSurrogateLow(text[idx + 1]);
    }

    public static int convertToUtf32(char highSurrogate, char lowSurrogate) {
        return (highSurrogate - 55296) * 1024 + lowSurrogate - 56320 + 65536;
    }

    public static int convertToUtf32(char[] text, int idx) {
        return (text[idx] - 55296) * 1024 + text[idx + 1] - 56320 + 65536;
    }

    public static int convertToUtf32(String text, int idx) {
        return (text.charAt(idx) - 55296) * 1024 + text.charAt(idx + 1) - 56320 + 65536;
    }

    public static int[] convertToUtf32(String text) {
        if (text == null) {
            return null;
        }
        ArrayList<Integer> charCodes = new ArrayList<Integer>(text.length());
        int pos = 0;
        while (pos < text.length()) {
            if (TextUtil.isSurrogatePair(text, pos)) {
                charCodes.add(TextUtil.convertToUtf32(text, pos));
                pos += 2;
                continue;
            }
            charCodes.add(Integer.valueOf(text.charAt(pos)));
            ++pos;
        }
        return ArrayUtil.toArray(charCodes);
    }

    public static char[] convertFromUtf32(int codePoint) {
        if (codePoint < 65536) {
            return new char[]{(char)codePoint};
        }
        return new char[]{(char)((codePoint -= 65536) / 1024 + 55296), (char)(codePoint % 1024 + 56320)};
    }

    public static String convertFromUtf32(int[] text, int startPos, int endPos) {
        StringBuilder sb = new StringBuilder();
        for (int i = startPos; i < endPos; ++i) {
            sb.append(TextUtil.convertFromUtf32ToCharArray(text[i]));
        }
        return sb.toString();
    }

    public static char[] convertFromUtf32ToCharArray(int codePoint) {
        if (codePoint < 65536) {
            return new char[]{(char)codePoint};
        }
        return new char[]{(char)((codePoint -= 65536) / 1024 + 55296), (char)(codePoint % 1024 + 56320)};
    }
}

