/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.image;

import com.fr.third.fr.pdf.io.IOException;
import com.fr.third.fr.pdf.io.codec.CCITTG4Encoder;
import com.fr.third.fr.pdf.io.codec.TIFFFaxDecoder;
import com.fr.third.fr.pdf.io.image.RawImageData;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RawImageHelper {
    public static void updateImageAttributes(RawImageData image, Map<String, Object> additional) {
        if (!image.isRawImage()) {
            throw new IllegalArgumentException("Raw image expected.");
        }
        int colorSpace = image.getColorSpace();
        int typeCCITT = image.getTypeCcitt();
        if (typeCCITT > 255) {
            if (!image.isMask()) {
                image.setColorSpace(1);
            }
            image.setBpc(1);
            image.setFilter("CCITTFaxDecode");
            int k = typeCCITT - 257;
            HashMap<String, Constable> decodeparms = new HashMap<String, Constable>();
            if (k != 0) {
                decodeparms.put("K", Integer.valueOf(k));
            }
            if ((colorSpace & 1) != 0) {
                decodeparms.put("BlackIs1", Boolean.valueOf(true));
            }
            if ((colorSpace & 2) != 0) {
                decodeparms.put("EncodedByteAlign", Boolean.valueOf(true));
            }
            if ((colorSpace & 4) != 0) {
                decodeparms.put("EndOfLine", Boolean.valueOf(true));
            }
            if ((colorSpace & 8) != 0) {
                decodeparms.put("EndOfBlock", Boolean.valueOf(false));
            }
            decodeparms.put("Columns", Float.valueOf(image.getWidth()));
            decodeparms.put("Rows", Float.valueOf(image.getHeight()));
            image.decodeParms = decodeparms;
        } else {
            switch (colorSpace) {
                case 1: {
                    if (!image.isInverted()) break;
                    image.decode = new float[]{1.0f, 0.0f};
                    break;
                }
                case 3: {
                    if (!image.isInverted()) break;
                    image.decode = new float[]{1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f};
                    break;
                }
                default: {
                    if (!image.isInverted()) break;
                    image.decode = new float[]{1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f};
                }
            }
            if (additional != null) {
                image.setImageAttributes(additional);
            }
            if (image.isMask() && (image.getBpc() == 1 || image.getBpc() > 8)) {
                image.setColorSpace(-1);
            }
            if (image.isDeflated()) {
                image.setFilter("FlateDecode");
            }
        }
    }

    protected static void updateRawImageParameters(RawImageData image, int width, int height, int components, int bpc, byte[] data) {
        image.setHeight(height);
        image.setWidth(width);
        if (components != 1 && components != 3 && components != 4) {
            throw new IOException("components.must.be.1.3.or.4");
        }
        if (bpc != 1 && bpc != 2 && bpc != 4 && bpc != 8) {
            throw new IOException("bits.per.component.must.be.1.2.4.or.8");
        }
        image.setColorSpace(components);
        image.setBpc(bpc);
        image.data = data;
    }

    protected static void updateRawImageParameters(RawImageData image, int width, int height, int components, int bpc, byte[] data, int[] transparency) {
        if (transparency != null && transparency.length != components * 2) {
            throw new IOException("transparency.length.must.be.equal.to.2.with.ccitt.images");
        }
        if (components == 1 && bpc == 1) {
            byte[] g4 = CCITTG4Encoder.compress(data, width, height);
            RawImageHelper.updateRawImageParameters(image, width, height, false, 256, 1, g4, transparency);
        } else {
            RawImageHelper.updateRawImageParameters(image, width, height, components, bpc, data);
            image.setTransparency(transparency);
        }
    }

    protected static void updateRawImageParameters(RawImageData image, int width, int height, boolean reverseBits, int typeCCITT, int parameters, byte[] data, int[] transparency) {
        if (transparency != null && transparency.length != 2) {
            throw new IOException("transparency.length.must.be.equal.to.2.with.ccitt.images");
        }
        RawImageHelper.updateCcittImageParameters(image, width, height, reverseBits, typeCCITT, parameters, data);
        image.setTransparency(transparency);
    }

    protected static void updateCcittImageParameters(RawImageData image, int width, int height, boolean reverseBits, int typeCcitt, int parameters, byte[] data) {
        if (typeCcitt != 256 && typeCcitt != 257 && typeCcitt != 258) {
            throw new IOException("ccitt.compression.type.must.be.ccittg4.ccittg3.1d.or.ccittg3.2d");
        }
        if (reverseBits) {
            TIFFFaxDecoder.reverseBits(data);
        }
        image.setHeight(height);
        image.setWidth(width);
        image.setColorSpace(parameters);
        image.setTypeCcitt(typeCcitt);
        image.data = data;
    }
}

