/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.image;

import com.fr.third.fr.pdf.io.IOException;
import com.fr.third.fr.pdf.io.color.IccProfile;
import com.fr.third.fr.pdf.io.image.ImageData;
import com.fr.third.fr.pdf.io.image.ImageType;
import com.fr.third.fr.pdf.io.util.StreamUtil;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;

class JpegImageHelper {
    private static final int NOT_A_MARKER = -1;
    private static final int VALID_MARKER = 0;
    private static final int[] VALID_MARKERS = new int[]{192, 193, 194};
    private static final int UNSUPPORTED_MARKER = 1;
    private static final int[] UNSUPPORTED_MARKERS = new int[]{195, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207};
    private static final int NOPARAM_MARKER = 2;
    private static final int[] NOPARAM_MARKERS = new int[]{208, 209, 210, 211, 212, 213, 214, 215, 216, 1};
    private static final int M_APP0 = 224;
    private static final int M_APP2 = 226;
    private static final int M_APPE = 238;
    private static final int M_APPD = 237;
    private static final byte[] JFIF_ID = new byte[]{74, 70, 73, 70, 0};
    private static final byte[] PS_8BIM_RESO = new byte[]{56, 66, 73, 77, 3, -19};

    JpegImageHelper() {
    }

    public static void processImage(ImageData image) {
        if (image.getOriginalType() != ImageType.JPEG) {
            throw new IllegalArgumentException("JPEG image expected");
        }
        InputStream jpegStream = null;
        try {
            String errorID;
            if (image.getData() == null) {
                image.loadData();
                errorID = image.getUrl().toString();
            } else {
                errorID = "Byte array";
            }
            jpegStream = new ByteArrayInputStream(image.getData());
            image.imageSize = image.getData().length;
            JpegImageHelper.processParameters(jpegStream, errorID, image);
        }
        catch (java.io.IOException e) {
            throw new IOException("jpeg.image.exception", e);
        }
        finally {
            if (jpegStream != null) {
                try {
                    jpegStream.close();
                }
                catch (java.io.IOException iOException) {}
            }
        }
        JpegImageHelper.updateAttributes(image);
    }

    private static void updateAttributes(ImageData image) {
        image.filter = "DCTDecode";
        if (image.getColorTransform() == 0) {
            HashMap<String, Object> decodeParms = new HashMap<String, Object>();
            decodeParms.put("ColorTransform", 0);
            image.decodeParms = decodeParms;
        }
        if (image.getColorSpace() != 1 && image.getColorSpace() != 3 && image.isInverted()) {
            image.decode = new float[]{1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f};
        }
    }

    private static void processParameters(InputStream jpegStream, String errorID, ImageData image) throws java.io.IOException {
        Object icc = null;
        if (jpegStream.read() != 255 || jpegStream.read() != 216) {
            throw new IOException("{0} is.not.a.valid.jpeg.file").setMessageParams(errorID);
        }
        boolean firstPass = true;
        while (true) {
            int dx;
            boolean found;
            int len;
            int v;
            if ((v = jpegStream.read()) < 0) {
                throw new IOException("premature.eof.while.reading.jpg");
            }
            if (v != 255) continue;
            int marker = jpegStream.read();
            if (firstPass && marker == 224) {
                firstPass = false;
                len = JpegImageHelper.getShort(jpegStream);
                if (len < 16) {
                    StreamUtil.skip(jpegStream, len - 2);
                    continue;
                }
                byte[] bcomp = new byte[JFIF_ID.length];
                int r = jpegStream.read(bcomp);
                if (r != bcomp.length) {
                    throw new IOException("{0} corrupted.jfif.marker").setMessageParams(errorID);
                }
                found = true;
                for (int k = 0; k < bcomp.length; ++k) {
                    if (bcomp[k] == JFIF_ID[k]) continue;
                    found = false;
                    break;
                }
                if (!found) {
                    StreamUtil.skip(jpegStream, len - 2 - bcomp.length);
                    continue;
                }
                StreamUtil.skip(jpegStream, 2L);
                int units = jpegStream.read();
                dx = JpegImageHelper.getShort(jpegStream);
                int dy = JpegImageHelper.getShort(jpegStream);
                if (units == 1) {
                    image.setDpi(dx, dy);
                } else if (units == 2) {
                    image.setDpi((int)((float)dx * 2.54f + 0.5f), (int)((float)dy * 2.54f + 0.5f));
                }
                StreamUtil.skip(jpegStream, len - 2 - bcomp.length - 7);
                continue;
            }
            if (marker == 238) {
                String appe;
                len = JpegImageHelper.getShort(jpegStream) - 2;
                byte[] byteappe = new byte[len];
                for (int k = 0; k < len; ++k) {
                    byteappe[k] = (byte)jpegStream.read();
                }
                if (byteappe.length < 12 || !(appe = new String(byteappe, 0, 5, "ISO-8859-1")).equals("Adobe")) continue;
                image.setInverted(true);
                continue;
            }
            if (marker == 226) {
                String app2;
                len = JpegImageHelper.getShort(jpegStream) - 2;
                byte[] byteapp2 = new byte[len];
                for (int k = 0; k < len; ++k) {
                    byteapp2[k] = (byte)jpegStream.read();
                }
                if (byteapp2.length < 14 || !(app2 = new String(byteapp2, 0, 11, "ISO-8859-1")).equals("ICC_PROFILE")) continue;
                int order = byteapp2[12] & 0xFF;
                int count = byteapp2[13] & 0xFF;
                if (order < 1) {
                    order = 1;
                }
                if (count < 1) {
                    count = 1;
                }
                if (icc == null) {
                    icc = new byte[count][];
                }
                icc[order - 1] = byteapp2;
                continue;
            }
            if (marker == 237) {
                Logger logger;
                int resosize;
                int k;
                len = JpegImageHelper.getShort(jpegStream) - 2;
                byte[] byteappd = new byte[len];
                for (k = 0; k < len; ++k) {
                    byteappd[k] = (byte)jpegStream.read();
                }
                for (k = 0; k < len - PS_8BIM_RESO.length; ++k) {
                    found = true;
                    for (int j = 0; j < PS_8BIM_RESO.length; ++j) {
                        if (byteappd[k + j] == PS_8BIM_RESO[j]) continue;
                        found = false;
                        break;
                    }
                    if (found) break;
                }
                if ((k += PS_8BIM_RESO.length) >= len - PS_8BIM_RESO.length) continue;
                byte namelength = byteappd[k];
                if ((namelength = (byte)(namelength + 1)) % 2 == 1) {
                    namelength = (byte)(namelength + 1);
                }
                if ((resosize = (byteappd[k += namelength] << 24) + (byteappd[k + 1] << 16) + (byteappd[k + 2] << 8) + byteappd[k + 3]) != 16) continue;
                dx = (byteappd[k += 4] << 8) + (byteappd[k + 1] & 0xFF);
                k += 2;
                int unitsx = (byteappd[k += 2] << 8) + (byteappd[k + 1] & 0xFF);
                k += 2;
                int dy = (byteappd[k += 2] << 8) + (byteappd[k + 1] & 0xFF);
                k += 2;
                int unitsy = (byteappd[k += 2] << 8) + (byteappd[k + 1] & 0xFF);
                if (unitsx == 1 || unitsx == 2) {
                    int n = dx = unitsx == 2 ? (int)((float)dx * 2.54f + 0.5f) : dx;
                    if (image.getDpiX() != 0 && image.getDpiX() != dx) {
                        logger = LoggerFactory.getLogger(JpegImageHelper.class);
                        logger.debug(MessageFormat.format("Inconsistent metadata (dpiX: {0} vs {1})", image.getDpiX(), dx));
                    } else {
                        image.setDpi(dx, image.getDpiY());
                    }
                }
                if (unitsy != 1 && unitsy != 2) continue;
                int n = dy = unitsy == 2 ? (int)((float)dy * 2.54f + 0.5f) : dy;
                if (image.getDpiY() != 0 && image.getDpiY() != dy) {
                    logger = LoggerFactory.getLogger(JpegImageHelper.class);
                    logger.debug(MessageFormat.format("Inconsistent metadata (dpiY: {0} vs {1})", image.getDpiY(), dy));
                    continue;
                }
                image.setDpi(image.getDpiX(), dx);
                continue;
            }
            firstPass = false;
            int markertype = JpegImageHelper.marker(marker);
            if (markertype == 0) {
                StreamUtil.skip(jpegStream, 2L);
                if (jpegStream.read() != 8) {
                    throw new IOException("{0} must.have.8.bits.per.component").setMessageParams(errorID);
                }
                break;
            }
            if (markertype == 1) {
                throw new IOException("{0} unsupported.jpeg.marker {1}").setMessageParams(errorID, Integer.toString(marker));
            }
            if (markertype == 2) continue;
            StreamUtil.skip(jpegStream, JpegImageHelper.getShort(jpegStream) - 2);
        }
        image.setHeight(JpegImageHelper.getShort(jpegStream));
        image.setWidth(JpegImageHelper.getShort(jpegStream));
        image.setColorSpace(jpegStream.read());
        image.setBpc(8);
        if (icc != null) {
            int total = 0;
            for (int k = 0; k < ((byte[][])icc).length; ++k) {
                if (icc[k] == null) {
                    icc = null;
                    return;
                }
                total += icc[k].length - 14;
            }
            byte[] ficc = new byte[total];
            total = 0;
            for (int k = 0; k < ((byte[][])icc).length; ++k) {
                System.arraycopy(icc[k], 14, ficc, total, icc[k].length - 14);
                total += icc[k].length - 14;
            }
            try {
                image.setProfile(IccProfile.getInstance(ficc, image.getColorSpace()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static int getShort(InputStream jpegStream) throws java.io.IOException {
        return (jpegStream.read() << 8) + jpegStream.read();
    }

    private static int marker(int marker) {
        int i;
        for (i = 0; i < VALID_MARKERS.length; ++i) {
            if (marker != VALID_MARKERS[i]) continue;
            return 0;
        }
        for (i = 0; i < NOPARAM_MARKERS.length; ++i) {
            if (marker != NOPARAM_MARKERS[i]) continue;
            return 2;
        }
        for (i = 0; i < UNSUPPORTED_MARKERS.length; ++i) {
            if (marker != UNSUPPORTED_MARKERS[i]) continue;
            return 1;
        }
        return -1;
    }
}

