/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.font.otf;

import com.fr.third.fr.pdf.io.font.otf.ActualTextIterator;
import com.fr.third.fr.pdf.io.font.otf.Glyph;
import com.fr.third.fr.pdf.io.font.otf.OpenTableLookup;
import com.fr.third.fr.pdf.io.font.otf.OpenTypeFontTableReader;
import com.fr.third.fr.pdf.io.util.TextUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphLine {
    protected List<Glyph> glyphs;
    protected List<ActualText> actualText;
    public int start;
    public int end;
    public int idx;

    public GlyphLine() {
        this.glyphs = new ArrayList<Glyph>();
    }

    public GlyphLine(List<Glyph> glyphs) {
        this.glyphs = glyphs;
        this.start = 0;
        this.end = glyphs.size();
    }

    public GlyphLine(List<Glyph> glyphs, int start, int end) {
        this.glyphs = glyphs;
        this.start = start;
        this.end = end;
    }

    protected GlyphLine(List<Glyph> glyphs, List<ActualText> actualText, int start, int end) {
        this(glyphs, start, end);
        this.actualText = actualText;
    }

    public GlyphLine(GlyphLine other) {
        this.glyphs = other.glyphs;
        this.actualText = other.actualText;
        this.start = other.start;
        this.end = other.end;
        this.idx = other.idx;
    }

    public GlyphLine(GlyphLine other, int start, int end) {
        this.glyphs = other.glyphs.subList(start, end);
        if (other.actualText != null) {
            this.actualText = other.actualText.subList(start, end);
        }
        this.start = 0;
        this.end = end - start;
        this.idx = other.idx - start;
    }

    public String toUnicodeString(int start, int end) {
        ActualTextIterator iter = new ActualTextIterator(this, start, end);
        StringBuilder str = new StringBuilder();
        while (iter.hasNext()) {
            GlyphLinePart part = (GlyphLinePart)iter.next();
            if (part.actualText != null) {
                str.append(part.actualText);
                continue;
            }
            for (int i = part.start; i < part.end; ++i) {
                if (this.glyphs.get(i).getChars() != null) {
                    str.append(this.glyphs.get(i).getChars());
                    continue;
                }
                if (!this.glyphs.get(i).hasValidUnicode()) continue;
                str.append(TextUtil.convertFromUtf32(this.glyphs.get(i).getUnicode()));
            }
        }
        return str.toString();
    }

    public GlyphLine copy(int left, int right) {
        GlyphLine glyphLine = new GlyphLine();
        glyphLine.start = 0;
        glyphLine.end = right - left;
        glyphLine.glyphs = new ArrayList<Glyph>(this.glyphs.subList(left, right));
        glyphLine.actualText = this.actualText == null ? null : new ArrayList<ActualText>(this.actualText.subList(left, right));
        return glyphLine;
    }

    public Glyph get(int index) {
        return this.glyphs.get(index);
    }

    public Glyph set(int index, Glyph glyph) {
        return this.glyphs.set(index, glyph);
    }

    public void add(Glyph glyph) {
        this.glyphs.add(glyph);
        if (this.actualText != null) {
            this.actualText.add(null);
        }
    }

    public void add(int index, Glyph glyph) {
        this.glyphs.add(index, glyph);
        if (this.actualText != null) {
            this.actualText.add(index, null);
        }
    }

    public void setGlyphs(List<Glyph> replacementGlyphs) {
        this.glyphs = new ArrayList<Glyph>(replacementGlyphs);
        this.start = 0;
        this.end = replacementGlyphs.size();
        this.actualText = null;
    }

    public void replaceContent(GlyphLine other) {
        this.glyphs.clear();
        this.glyphs.addAll(other.glyphs);
        if (this.actualText != null) {
            this.actualText.clear();
        }
        if (other.actualText != null) {
            if (this.actualText == null) {
                this.actualText = new ArrayList<ActualText>();
            }
            this.actualText.addAll(other.actualText);
        }
        this.start = other.start;
        this.end = other.end;
    }

    public int size() {
        return this.glyphs.size();
    }

    public void substituteManyToOne(OpenTypeFontTableReader tableReader, int lookupFlag, int rightPartLen, int substitutionGlyphIndex) {
        OpenTableLookup.GlyphIndexer gidx = new OpenTableLookup.GlyphIndexer();
        gidx.line = this;
        gidx.idx = this.idx;
        StringBuilder chars = new StringBuilder();
        Glyph currentGlyph = this.glyphs.get(this.idx);
        if (currentGlyph.getChars() != null) {
            chars.append(currentGlyph.getChars());
        } else if (currentGlyph.hasValidUnicode()) {
            chars.append(TextUtil.convertFromUtf32(currentGlyph.getUnicode()));
        }
        for (int j = 0; j < rightPartLen; ++j) {
            gidx.nextGlyph(tableReader, lookupFlag);
            currentGlyph = this.glyphs.get(gidx.idx);
            if (currentGlyph.getChars() != null) {
                chars.append(currentGlyph.getChars());
            } else if (currentGlyph.hasValidUnicode()) {
                chars.append(TextUtil.convertFromUtf32(currentGlyph.getUnicode()));
            }
            this.removeGlyph(gidx.idx--);
        }
        char[] newChars = new char[chars.length()];
        chars.getChars(0, chars.length(), newChars, 0);
        Glyph newGlyph = tableReader.getGlyph(substitutionGlyphIndex);
        newGlyph.setChars(newChars);
        this.glyphs.set(this.idx, newGlyph);
        this.end -= rightPartLen;
    }

    public void substituteOneToOne(OpenTypeFontTableReader tableReader, int substitutionGlyphIndex) {
        Glyph oldGlyph = this.glyphs.get(this.idx);
        Glyph newGlyph = tableReader.getGlyph(substitutionGlyphIndex);
        if (oldGlyph.getChars() != null) {
            newGlyph.setChars(oldGlyph.getChars());
        } else if (newGlyph.hasValidUnicode()) {
            newGlyph.setChars(TextUtil.convertFromUtf32(newGlyph.getUnicode()));
        } else if (oldGlyph.hasValidUnicode()) {
            newGlyph.setChars(TextUtil.convertFromUtf32(oldGlyph.getUnicode()));
        }
        this.glyphs.set(this.idx, newGlyph);
    }

    public void substituteOneToMany(OpenTypeFontTableReader tableReader, int[] substGlyphIds) {
        int substCode = substGlyphIds[0];
        Glyph glyph = tableReader.getGlyph(substCode);
        this.glyphs.set(this.idx, glyph);
        if (substGlyphIds.length > 1) {
            ArrayList<Glyph> additionalGlyphs = new ArrayList<Glyph>(substGlyphIds.length - 1);
            for (int i = 1; i < substGlyphIds.length; ++i) {
                substCode = substGlyphIds[i];
                glyph = tableReader.getGlyph(substCode);
                additionalGlyphs.add(glyph);
            }
            this.addAllGlyphs(this.idx + 1, additionalGlyphs);
            this.idx += substGlyphIds.length - 1;
            this.end += substGlyphIds.length - 1;
        }
    }

    public GlyphLine filter(IGlyphLineFilter filter) {
        boolean anythingFiltered = false;
        ArrayList<Glyph> filteredGlyphs = new ArrayList<Glyph>(this.end - this.start);
        ArrayList<ActualText> filteredActualText = this.actualText != null ? new ArrayList<ActualText>(this.end - this.start) : null;
        for (int i = this.start; i < this.end; ++i) {
            if (filter.accept(this.glyphs.get(i))) {
                filteredGlyphs.add(this.glyphs.get(i));
                if (filteredActualText == null) continue;
                filteredActualText.add(this.actualText.get(i));
                continue;
            }
            anythingFiltered = true;
        }
        if (anythingFiltered) {
            return new GlyphLine(filteredGlyphs, filteredActualText, 0, filteredGlyphs.size());
        }
        return this;
    }

    public void setActualText(int left, int right, String text) {
        if (this.actualText == null) {
            this.actualText = new ArrayList<ActualText>(this.glyphs.size());
            for (int i = 0; i < this.glyphs.size(); ++i) {
                this.actualText.add(null);
            }
        }
        ActualText actualText = new ActualText(text);
        for (int i = left; i < right; ++i) {
            this.actualText.set(i, actualText);
        }
    }

    public Iterator<GlyphLinePart> iterator() {
        return new ActualTextIterator(this);
    }

    private void removeGlyph(int index) {
        this.glyphs.remove(index);
        if (this.actualText != null) {
            this.actualText.remove(index);
        }
    }

    private void addAllGlyphs(int index, List<Glyph> additionalGlyphs) {
        this.glyphs.addAll(index, additionalGlyphs);
        if (this.actualText != null) {
            for (int i = 0; i < additionalGlyphs.size(); ++i) {
                this.actualText.add(index, null);
            }
        }
    }

    protected static class ActualText {
        public String value;

        public ActualText(String value) {
            this.value = value;
        }
    }

    public static interface IGlyphLineFilter {
        public boolean accept(Glyph var1);
    }

    public static class GlyphLinePart {
        public int start;
        public int end;
        public String actualText;

        public GlyphLinePart(int start, int end, String actualText) {
            this.start = start;
            this.end = end;
            this.actualText = actualText;
        }
    }
}

