/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.forms.xfa;

import com.fr.third.fr.pdf.forms.PdfAcroForm;
import com.fr.third.fr.pdf.forms.xfa.AcroFieldsSearch;
import com.fr.third.fr.pdf.forms.xfa.Xml2Som;
import com.fr.third.fr.pdf.forms.xfa.Xml2SomDatasets;
import com.fr.third.fr.pdf.io.util.ResourceUtil;
import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.xmp.XmlDomWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XfaForm {
    private static final String DEFAULT_XFA = "com/fr/third/fr/pdf/forms/xfa/default.xml";
    private Node templateNode;
    private Xml2SomDatasets datasetsSom;
    private Node datasetsNode;
    private AcroFieldsSearch acroFieldsSom;
    private boolean xfaPresent = false;
    private Document domDocument;
    public static final String XFA_DATA_SCHEMA = "http://www.xfa.org/schema/xfa-data/1.0/";

    public XfaForm() {
        this(ResourceUtil.getResourceStream(DEFAULT_XFA));
    }

    public XfaForm(InputStream inputStream) {
        try {
            this.initXfaForm(inputStream);
        }
        catch (Exception e) {
            throw new PdfException(e);
        }
    }

    public XfaForm(Document domDocument) {
        this.setDomDocument(domDocument);
    }

    public XfaForm(PdfDictionary acroFormDictionary) {
        PdfObject xfa = acroFormDictionary.get(PdfName.XFA);
        if (xfa != null) {
            try {
                this.initXfaForm(xfa);
            }
            catch (Exception e) {
                throw new PdfException(e);
            }
        }
    }

    public XfaForm(PdfDocument pdfDocument) {
        PdfObject xfa = XfaForm.getXfaObject(pdfDocument);
        if (xfa != null) {
            try {
                this.initXfaForm(xfa);
            }
            catch (Exception e) {
                throw new PdfException(e);
            }
        }
    }

    public static void setXfaForm(XfaForm form, PdfDocument pdfDocument) throws IOException {
        PdfDictionary af = (PdfDictionary)PdfAcroForm.getAcroForm(pdfDocument, true).getPdfObject();
        PdfObject xfa = XfaForm.getXfaObject(pdfDocument);
        if (xfa != null && xfa.isArray()) {
            PdfArray ar = (PdfArray)xfa;
            int t = -1;
            int d = -1;
            for (int k = 0; k < ar.size(); k += 2) {
                PdfString s = ar.getAsString(k);
                if ("template".equals(s.toString())) {
                    t = k + 1;
                }
                if (!"datasets".equals(s.toString())) continue;
                d = k + 1;
            }
            if (t > -1 && d > -1) {
                PdfStream tStream = new PdfStream(XfaForm.serializeDocument(form.templateNode));
                tStream.setCompressionLevel(pdfDocument.getWriter().getCompressionLevel());
                ar.set(t, tStream);
                PdfStream dStream = new PdfStream(XfaForm.serializeDocument(form.datasetsNode));
                dStream.setCompressionLevel(pdfDocument.getWriter().getCompressionLevel());
                ar.set(d, dStream);
                ar.flush();
                af.put(PdfName.XFA, new PdfArray(ar));
                return;
            }
        }
        PdfStream stream = new PdfStream(XfaForm.serializeDocument(form.domDocument));
        stream.setCompressionLevel(pdfDocument.getWriter().getCompressionLevel());
        stream.flush();
        af.put(PdfName.XFA, stream);
        af.setModified();
    }

    public static Map<String, Node> extractXFANodes(Document domDocument) {
        HashMap<String, Node> xfaNodes = new HashMap<String, Node>();
        Node n = domDocument.getFirstChild();
        while (n.getChildNodes().getLength() == 0) {
            n = n.getNextSibling();
        }
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            String s = n.getLocalName();
            xfaNodes.put(s, n);
        }
        return xfaNodes;
    }

    public void write(PdfDocument document) throws IOException {
        XfaForm.setXfaForm(this, document);
    }

    public void setXfaFieldValue(String name, String value) {
        if (this.isXfaPresent() && (name = this.findFieldName(name)) != null) {
            String shortName = Xml2Som.getShortName(name);
            Node xn = this.findDatasetsNode(shortName);
            if (xn == null) {
                xn = this.datasetsSom.insertNode(this.getDatasetsNode(), shortName);
            }
            this.setNodeText(xn, value);
        }
    }

    public String getXfaFieldValue(String name) {
        if (this.isXfaPresent() && (name = this.findFieldName(name)) != null) {
            name = Xml2Som.getShortName(name);
            return XfaForm.getNodeText(this.findDatasetsNode(name));
        }
        return null;
    }

    public boolean isXfaPresent() {
        return this.xfaPresent;
    }

    public String findFieldName(String name) {
        if (this.acroFieldsSom == null && this.xfaPresent) {
            this.acroFieldsSom = new AcroFieldsSearch(this.datasetsSom.getName2Node().keySet());
            return this.acroFieldsSom.getAcroShort2LongName().containsKey(name) ? this.acroFieldsSom.getAcroShort2LongName().get(name) : this.acroFieldsSom.inverseSearchGlobal(Xml2Som.splitParts(name));
        }
        return null;
    }

    public String findDatasetsName(String name) {
        return this.datasetsSom.getName2Node().containsKey(name) ? name : this.datasetsSom.inverseSearchGlobal(Xml2Som.splitParts(name));
    }

    public Node findDatasetsNode(String name) {
        if (name == null) {
            return null;
        }
        if ((name = this.findDatasetsName(name)) == null) {
            return null;
        }
        return this.datasetsSom.getName2Node().get(name);
    }

    public static String getNodeText(Node n) {
        return n == null ? "" : XfaForm.getNodeText(n, "");
    }

    public void setNodeText(Node n, String text) {
        if (n == null) {
            return;
        }
        Node nc = null;
        while ((nc = n.getFirstChild()) != null) {
            n.removeChild(nc);
        }
        if (n.getAttributes().getNamedItemNS(XFA_DATA_SCHEMA, "dataNode") != null) {
            n.getAttributes().removeNamedItemNS(XFA_DATA_SCHEMA, "dataNode");
        }
        n.appendChild(this.domDocument.createTextNode(text));
    }

    public Document getDomDocument() {
        return this.domDocument;
    }

    public void setDomDocument(Document domDocument) {
        this.domDocument = domDocument;
        this.extractNodes();
    }

    public Node getDatasetsNode() {
        return this.datasetsNode;
    }

    public void fillXfaForm(File file) throws IOException {
        this.fillXfaForm(file, false);
    }

    public void fillXfaForm(File file, boolean readOnly) throws IOException {
        this.fillXfaForm(new FileInputStream(file), readOnly);
    }

    public void fillXfaForm(InputStream is) throws IOException {
        this.fillXfaForm(is, false);
    }

    public void fillXfaForm(InputStream is, boolean readOnly) throws IOException {
        this.fillXfaForm(new InputSource(is), readOnly);
    }

    public void fillXfaForm(InputSource is) throws IOException {
        this.fillXfaForm(is, false);
    }

    public void fillXfaForm(InputSource is, boolean readOnly) throws IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document newdoc = db.parse(is);
            this.fillXfaForm(newdoc.getDocumentElement(), readOnly);
        }
        catch (ParserConfigurationException e) {
            throw new PdfException(e);
        }
        catch (SAXException e) {
            throw new PdfException(e);
        }
    }

    public void fillXfaForm(Node node) {
        this.fillXfaForm(node, false);
    }

    public void fillXfaForm(Node node, boolean readOnly) {
        NodeList list;
        if (readOnly) {
            NodeList nodeList = this.domDocument.getElementsByTagName("field");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ((Element)nodeList.item(i)).setAttribute("access", "readOnly");
            }
        }
        NodeList allChilds = this.datasetsNode.getChildNodes();
        int len = allChilds.getLength();
        Node data = null;
        for (int k = 0; k < len; ++k) {
            Node n = allChilds.item(k);
            if (n.getNodeType() != 1 || !n.getLocalName().equals("data") || !XFA_DATA_SCHEMA.equals(n.getNamespaceURI())) continue;
            data = n;
            break;
        }
        if (data == null) {
            data = this.datasetsNode.getOwnerDocument().createElementNS(XFA_DATA_SCHEMA, "xfa:data");
            this.datasetsNode.appendChild(data);
        }
        if ((list = data.getChildNodes()).getLength() == 0) {
            data.appendChild(this.domDocument.importNode(node, true));
        } else {
            Node firstNode = this.getFirstElementNode(data);
            if (firstNode != null) {
                data.replaceChild(this.domDocument.importNode(node, true), firstNode);
            }
        }
        this.extractNodes();
    }

    private static String getNodeText(Node n, String name) {
        for (Node n2 = n.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (n2.getNodeType() == 1) {
                name = XfaForm.getNodeText(n2, name);
                continue;
            }
            if (n2.getNodeType() != 3) continue;
            name = name + n2.getNodeValue();
        }
        return name;
    }

    private static PdfObject getXfaObject(PdfDocument pdfDocument) {
        PdfDictionary af = ((PdfDictionary)pdfDocument.getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm);
        return af == null ? null : af.get(PdfName.XFA);
    }

    private static byte[] serializeDocument(Node n) throws IOException {
        XmlDomWriter xw = new XmlDomWriter();
        ByteArrayOutputStream fout = new ByteArrayOutputStream();
        xw.setOutput(fout, null);
        xw.setCanonical(false);
        xw.write(n);
        fout.close();
        return fout.toByteArray();
    }

    private void initXfaForm(PdfObject xfa) throws IOException, ParserConfigurationException, SAXException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (xfa.isArray()) {
            PdfArray ar = (PdfArray)xfa;
            for (int k = 1; k < ar.size(); k += 2) {
                PdfObject ob = ar.get(k);
                if (!(ob instanceof PdfStream)) continue;
                byte[] b = ((PdfStream)ob).getBytes();
                bout.write(b);
            }
        } else if (xfa instanceof PdfStream) {
            byte[] b = ((PdfStream)xfa).getBytes();
            bout.write(b);
        }
        bout.close();
        this.initXfaForm(new ByteArrayInputStream(bout.toByteArray()));
    }

    private void initXfaForm(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setNamespaceAware(true);
        DocumentBuilder db = fact.newDocumentBuilder();
        this.setDomDocument(db.parse(inputStream));
        this.xfaPresent = true;
    }

    private void extractNodes() {
        Map<String, Node> xfaNodes = XfaForm.extractXFANodes(this.domDocument);
        if (xfaNodes.containsKey("template")) {
            this.templateNode = xfaNodes.get("template");
        }
        if (xfaNodes.containsKey("datasets")) {
            this.datasetsNode = xfaNodes.get("datasets");
            this.datasetsSom = new Xml2SomDatasets(this.datasetsNode.getFirstChild());
        }
        if (this.datasetsNode == null) {
            this.createDatasetsNode(this.domDocument.getFirstChild());
        }
    }

    private void createDatasetsNode(Node n) {
        while (n.getChildNodes().getLength() == 0) {
            n = n.getNextSibling();
        }
        if (n != null) {
            Element e = n.getOwnerDocument().createElement("xfa:datasets");
            e.setAttribute("xmlns:xfa", XFA_DATA_SCHEMA);
            this.datasetsNode = e;
            n.appendChild(this.datasetsNode);
        }
    }

    private Node getFirstElementNode(Node src) {
        Node result = null;
        NodeList list = src.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            result = list.item(i);
            break;
        }
        return result;
    }
}

