/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;

public class SoundStreamHead
extends DefinitionTag {
    protected int playbackSoundRate;
    protected boolean playbackSoundSize16;
    protected boolean playbackSoundStereo;
    protected int streamSoundCompression;
    protected int streamSoundRate;
    protected boolean streamSoundSize16;
    protected boolean streamSoundStereo;
    protected int samples;
    protected int latencySeek;

    public SoundStreamHead(int n2, boolean bl, int n3, boolean bl2, int n4) {
        this();
        this.playbackSoundRate = n2;
        this.playbackSoundSize16 = true;
        this.playbackSoundStereo = bl;
        this.streamSoundCompression = 1;
        this.streamSoundRate = n3;
        this.streamSoundSize16 = true;
        this.streamSoundStereo = bl2;
        this.samples = n4;
    }

    public SoundStreamHead() {
        super(18, 1);
    }

    protected SoundStreamHead(int n2, int n3) {
        super(n2, n3);
    }

    public SWFTag read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
        SoundStreamHead soundStreamHead = new SoundStreamHead();
        soundStreamHead.read(sWFInputStream, n3);
        return soundStreamHead;
    }

    protected void read(SWFInputStream sWFInputStream, int n2) throws IOException {
        sWFInputStream.readUBits(4);
        this.playbackSoundRate = (int)sWFInputStream.readUBits(2);
        this.playbackSoundSize16 = sWFInputStream.readBitFlag();
        this.playbackSoundStereo = sWFInputStream.readBitFlag();
        this.streamSoundCompression = (int)sWFInputStream.readUBits(4);
        this.streamSoundRate = (int)sWFInputStream.readUBits(2);
        this.streamSoundSize16 = sWFInputStream.readBitFlag();
        this.streamSoundStereo = sWFInputStream.readBitFlag();
        this.samples = sWFInputStream.readUnsignedShort();
        if (this.streamSoundCompression == 2) {
            this.latencySeek = sWFInputStream.readShort();
        }
    }

    public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
        this.write(sWFOutputStream);
    }

    protected void write(SWFOutputStream sWFOutputStream) throws IOException {
        sWFOutputStream.writeUBits(0L, 4);
        sWFOutputStream.writeUBits(this.playbackSoundRate, 2);
        sWFOutputStream.writeBitFlag(this.playbackSoundSize16);
        sWFOutputStream.writeBitFlag(this.playbackSoundStereo);
        sWFOutputStream.writeUBits(this.streamSoundCompression, 4);
        sWFOutputStream.writeUBits(this.streamSoundRate, 2);
        sWFOutputStream.writeBitFlag(this.streamSoundSize16);
        sWFOutputStream.writeBitFlag(this.streamSoundStereo);
        sWFOutputStream.writeUnsignedShort(this.samples);
        if (this.streamSoundCompression == 2) {
            sWFOutputStream.writeShort(this.latencySeek);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

