/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import org.freehep.graphicsio.swf.DefineFont;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineFontInfo
extends DefinitionTag {
    protected int fontID;
    protected String name;
    protected boolean shiftJIS;
    protected boolean ansi;
    protected boolean italic;
    protected boolean bold;
    protected boolean wideCodes;
    protected int[] codes;

    public DefineFontInfo(int n2, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int[] nArray) {
        this();
        this.fontID = n2;
        this.name = string;
        this.shiftJIS = bl;
        this.ansi = bl2;
        this.italic = bl3;
        this.bold = bl4;
        this.wideCodes = bl5;
        this.codes = nArray;
    }

    public DefineFontInfo() {
        super(13, 1);
    }

    protected DefineFontInfo(int n2, int n3) {
        super(n2, n3);
    }

    public SWFTag read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
        DefineFontInfo defineFontInfo = new DefineFontInfo();
        defineFontInfo.fontID = sWFInputStream.readUnsignedShort();
        DefineFont defineFont = (DefineFont)sWFInputStream.getDictionary().get(defineFontInfo.fontID);
        int n4 = defineFont.getGlyphCount();
        defineFont.setFontInfo(defineFontInfo);
        int n5 = sWFInputStream.readUnsignedByte();
        defineFontInfo.name = sWFInputStream.getVersion() >= 6 ? sWFInputStream.readUTF() : new String(sWFInputStream.readByte(n5));
        sWFInputStream.readUBits(3);
        defineFontInfo.shiftJIS = sWFInputStream.readBitFlag();
        defineFontInfo.ansi = sWFInputStream.readBitFlag();
        defineFontInfo.italic = sWFInputStream.readBitFlag();
        defineFontInfo.bold = sWFInputStream.readBitFlag();
        defineFontInfo.wideCodes = sWFInputStream.readBitFlag();
        defineFontInfo.codes = defineFontInfo.wideCodes ? sWFInputStream.readUnsignedShort(n4) : sWFInputStream.readUnsignedByte(n4);
        return defineFontInfo;
    }

    public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
        sWFOutputStream.writeUnsignedShort(this.fontID);
        sWFOutputStream.writeUnsignedByte(this.name.length());
        if (sWFOutputStream.getVersion() >= 6) {
            sWFOutputStream.writeUTF(this.name);
        } else {
            sWFOutputStream.writeByte(this.name.getBytes());
        }
        sWFOutputStream.writeUBits(0L, 3);
        sWFOutputStream.writeBitFlag(this.shiftJIS);
        sWFOutputStream.writeBitFlag(this.ansi);
        sWFOutputStream.writeBitFlag(this.italic);
        sWFOutputStream.writeBitFlag(this.bold);
        sWFOutputStream.writeBitFlag(this.wideCodes);
        if (this.wideCodes) {
            sWFOutputStream.writeUnsignedShort(this.codes);
        } else {
            sWFOutputStream.writeUnsignedByte(this.codes);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append("  name:      " + this.name + "\n");
        stringBuffer.append("  numGlyphs: " + this.codes.length + "\n");
        stringBuffer.append("    ");
        for (int i2 = 0; i2 < this.codes.length; ++i2) {
            stringBuffer.append("[" + this.codes[i2] + ",'" + (char)this.codes[i2] + "'] ");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

