/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.gif;

public class Quantize {
    static final boolean QUICK = false;
    static final int MAX_RGB = 255;
    static final int MAX_NODES = 266817;
    static final int MAX_TREE_DEPTH = 8;
    static int[] SQUARES;
    static int[] SHIFT;

    public static int[] quantizeImage(int[][] nArray, int n2) {
        Cube cube = new Cube(nArray, n2);
        cube.classification();
        cube.reduction();
        cube.assignment();
        return cube.colormap;
    }

    static {
        int n2;
        SQUARES = new int[511];
        for (n2 = -255; n2 <= 255; ++n2) {
            Quantize.SQUARES[n2 + 255] = n2 * n2;
        }
        SHIFT = new int[9];
        for (n2 = 0; n2 < 9; ++n2) {
            Quantize.SHIFT[n2] = 1 << 15 - n2;
        }
    }

    static class Cube {
        int[][] pixels;
        int max_colors;
        int[] colormap;
        Node root;
        int depth;
        int colors;
        int nodes;

        Cube(int[][] nArray, int n2) {
            this.pixels = nArray;
            this.max_colors = n2;
            this.colors = 1;
            int n3 = n2;
            this.depth = 1;
            while (n3 != 0) {
                n3 /= 4;
                ++this.depth;
            }
            if (this.depth > 1) {
                --this.depth;
            }
            if (this.depth > 8) {
                this.depth = 8;
            } else if (this.depth < 2) {
                this.depth = 2;
            }
            this.root = new Node(this);
        }

        void classification() {
            int[][] nArray = this.pixels;
            int n2 = nArray.length;
            int n3 = nArray[0].length;
            int n4 = n2;
            while (n4-- > 0) {
                int n5 = n3;
                while (n5-- > 0) {
                    int n6 = nArray[n4][n5];
                    int n7 = n6 >> 24 & 0xFF;
                    int n8 = n6 >> 16 & 0xFF;
                    int n9 = n6 >> 8 & 0xFF;
                    int n10 = n6 >> 0 & 0xFF;
                    if (n7 <= 0) continue;
                    if (this.nodes > 266817) {
                        System.out.println("pruning");
                        this.root.pruneLevel();
                        --this.depth;
                    }
                    Node node = this.root;
                    for (int i2 = 1; i2 <= this.depth; ++i2) {
                        int n11 = (n8 > node.mid_red ? 1 : 0) << 0 | (n9 > node.mid_green ? 1 : 0) << 1 | (n10 > node.mid_blue ? 1 : 0) << 2;
                        if (node.child[n11] == null) {
                            new Node(node, n11, i2);
                        }
                        node = node.child[n11];
                        node.number_pixels += SHIFT[i2];
                    }
                    ++node.unique;
                    node.total_alpha += n7;
                    node.total_red += n8;
                    node.total_green += n9;
                    node.total_blue += n10;
                }
            }
        }

        void reduction() {
            int n2 = 1;
            while (this.colors > this.max_colors) {
                this.colors = 1;
                n2 = this.root.reduce(n2, Integer.MAX_VALUE);
            }
        }

        void assignment() {
            this.colormap = new int[this.colors];
            this.colormap[0] = 0x800000;
            this.colors = 1;
            this.root.colormap();
            int[][] nArray = this.pixels;
            int n2 = nArray.length;
            int n3 = nArray[0].length;
            Search search = new Search();
            int n4 = n2;
            while (n4-- > 0) {
                int n5 = n3;
                while (n5-- > 0) {
                    int n6 = nArray[n4][n5];
                    int n7 = n6 >> 24 & 0xFF;
                    int n8 = n6 >> 16 & 0xFF;
                    int n9 = n6 >> 8 & 0xFF;
                    int n10 = n6 >> 0 & 0xFF;
                    if (n7 > 0) {
                        int n11;
                        Node node = this.root;
                        while (node.child[n11 = (n8 > node.mid_red ? 1 : 0) << 0 | (n9 > node.mid_green ? 1 : 0) << 1 | (n10 > node.mid_blue ? 1 : 0) << 2] != null) {
                            node = node.child[n11];
                        }
                        search.distance = Integer.MAX_VALUE;
                        node.parent.closestColor(n8, n9, n10, search);
                        nArray[n4][n5] = search.color_number;
                        continue;
                    }
                    nArray[n4][n5] = 0;
                }
            }
        }

        static class Node {
            Cube cube;
            Node parent;
            Node[] child;
            int nchild;
            int id;
            int level;
            int mid_red;
            int mid_green;
            int mid_blue;
            int number_pixels;
            int unique;
            int total_alpha;
            int total_red;
            int total_green;
            int total_blue;
            int color_number;

            Node(Cube cube) {
                this.cube = cube;
                this.parent = this;
                this.child = new Node[8];
                this.id = 0;
                this.level = 0;
                this.number_pixels = Integer.MAX_VALUE;
                this.mid_red = 128;
                this.mid_green = 128;
                this.mid_blue = 128;
            }

            Node(Node node, int n2, int n3) {
                this.cube = node.cube;
                this.parent = node;
                this.child = new Node[8];
                this.id = n2;
                this.level = n3;
                ++this.cube.nodes;
                if (n3 == this.cube.depth) {
                    ++this.cube.colors;
                }
                ++node.nchild;
                node.child[n2] = this;
                int n4 = 1 << 8 - n3 >> 1;
                this.mid_red = node.mid_red + ((n2 & 1) > 0 ? n4 : -n4);
                this.mid_green = node.mid_green + ((n2 & 2) > 0 ? n4 : -n4);
                this.mid_blue = node.mid_blue + ((n2 & 4) > 0 ? n4 : -n4);
            }

            void pruneChild() {
                --this.parent.nchild;
                this.parent.unique += this.unique;
                this.parent.total_alpha += this.total_alpha;
                this.parent.total_red += this.total_red;
                this.parent.total_green += this.total_green;
                this.parent.total_blue += this.total_blue;
                this.parent.child[this.id] = null;
                --this.cube.nodes;
                this.cube = null;
                this.parent = null;
            }

            void pruneLevel() {
                if (this.nchild != 0) {
                    for (int i2 = 0; i2 < 8; ++i2) {
                        if (this.child[i2] == null) continue;
                        this.child[i2].pruneLevel();
                    }
                }
                if (this.level == this.cube.depth) {
                    this.pruneChild();
                }
            }

            int reduce(int n2, int n3) {
                if (this.nchild != 0) {
                    for (int i2 = 0; i2 < 8; ++i2) {
                        if (this.child[i2] == null) continue;
                        n3 = this.child[i2].reduce(n2, n3);
                    }
                }
                if (this.number_pixels <= n2) {
                    this.pruneChild();
                } else {
                    if (this.unique != 0) {
                        ++this.cube.colors;
                    }
                    if (this.number_pixels < n3) {
                        n3 = this.number_pixels;
                    }
                }
                return n3;
            }

            void colormap() {
                int n2;
                if (this.nchild != 0) {
                    for (n2 = 0; n2 < 8; ++n2) {
                        if (this.child[n2] == null) continue;
                        this.child[n2].colormap();
                    }
                }
                if (this.unique != 0) {
                    n2 = (this.total_alpha + (this.unique >> 1)) / this.unique;
                    int n3 = (this.total_red + (this.unique >> 1)) / this.unique;
                    int n4 = (this.total_green + (this.unique >> 1)) / this.unique;
                    int n5 = (this.total_blue + (this.unique >> 1)) / this.unique;
                    this.cube.colormap[this.cube.colors] = (n2 & 0xFF) << 24 | (n3 & 0xFF) << 16 | (n4 & 0xFF) << 8 | (n5 & 0xFF) << 0;
                    this.color_number = this.cube.colors++;
                }
            }

            void closestColor(int n2, int n3, int n4, Search search) {
                int n5;
                int n6;
                if (this.nchild != 0) {
                    for (n6 = 0; n6 < 8; ++n6) {
                        if (this.child[n6] == null) continue;
                        this.child[n6].closestColor(n2, n3, n4, search);
                    }
                }
                if (this.unique != 0 && (n5 = Node.distance(n6 = this.cube.colormap[this.color_number], n2, n3, n4)) < search.distance) {
                    search.distance = n5;
                    search.color_number = this.color_number;
                }
            }

            static final int distance(int n2, int n3, int n4, int n5) {
                return SQUARES[(n2 >> 16 & 0xFF) - n3 + 255] + SQUARES[(n2 >> 8 & 0xFF) - n4 + 255] + SQUARES[(n2 >> 0 & 0xFF) - n5 + 255];
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.parent == this) {
                    stringBuffer.append("root");
                } else {
                    stringBuffer.append("node");
                }
                stringBuffer.append(' ');
                stringBuffer.append(this.level);
                stringBuffer.append(" [");
                stringBuffer.append(this.mid_red);
                stringBuffer.append(',');
                stringBuffer.append(this.mid_green);
                stringBuffer.append(',');
                stringBuffer.append(this.mid_blue);
                stringBuffer.append(']');
                return new String(stringBuffer);
            }
        }

        static class Search {
            int distance;
            int color_number;

            Search() {
            }
        }
    }
}

