/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream.xerces.util;

public class SymbolTable {
    protected static final int TABLE_SIZE = 173;
    protected char[] symbolAsArray = null;
    protected Entry[] fBuckets = null;
    protected int fTableSize;

    public SymbolTable() {
        this(173);
    }

    public SymbolTable(int n2) {
        this.fTableSize = n2;
        this.fBuckets = new Entry[this.fTableSize];
    }

    public String addSymbol(String string) {
        int n2 = this.hash(string);
        int n3 = n2 % this.fTableSize;
        int n4 = string.length();
        Entry entry = this.fBuckets[n3];
        while (entry != null) {
            if (n4 == entry.characters.length && n2 == entry.hashCode && string.regionMatches(0, entry.symbol, 0, n4)) {
                this.symbolAsArray = entry.characters;
                return entry.symbol;
            }
            entry = entry.next;
        }
        entry = new Entry(string, this.fBuckets[n3]);
        entry.hashCode = n2;
        this.symbolAsArray = entry.characters;
        this.fBuckets[n3] = entry;
        return entry.symbol;
    }

    public String addSymbol(char[] cArray, int n2, int n3) {
        int n4 = this.hash(cArray, n2, n3);
        int n5 = n4 % this.fTableSize;
        Entry entry = this.fBuckets[n5];
        while (entry != null) {
            block4: {
                if (n3 == entry.characters.length && n4 == entry.hashCode) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (cArray[n2 + i2] == entry.characters[i2]) {
                            continue;
                        }
                        break block4;
                    }
                    this.symbolAsArray = entry.characters;
                    return entry.symbol;
                }
            }
            entry = entry.next;
        }
        this.fBuckets[n5] = entry = new Entry(cArray, n2, n3, this.fBuckets[n5]);
        entry.hashCode = n4;
        this.symbolAsArray = entry.characters;
        return entry.symbol;
    }

    public int hash(String string) {
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            n2 = n2 * 37 + string.charAt(n4);
            ++n4;
        }
        return n2 & 0x7FFFFFF;
    }

    public int hash(char[] cArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            n4 = n4 * 37 + cArray[n2 + n5];
            ++n5;
        }
        return n4 & 0x7FFFFFF;
    }

    public boolean containsSymbol(String string) {
        int n2 = this.hash(string);
        int n3 = n2 % this.fTableSize;
        int n4 = string.length();
        Entry entry = this.fBuckets[n3];
        while (entry != null) {
            if (n4 == entry.characters.length && n2 == entry.hashCode && string.regionMatches(0, entry.symbol, 0, n4)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean containsSymbol(char[] cArray, int n2, int n3) {
        int n4 = this.hash(cArray, n2, n3);
        int n5 = n4 % this.fTableSize;
        Entry entry = this.fBuckets[n5];
        while (entry != null) {
            block4: {
                if (n3 == entry.characters.length && n4 == entry.hashCode) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        if (cArray[n2 + i2] == entry.characters[i2]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    public char[] getCharArray() {
        return this.symbolAsArray;
    }

    protected static final class Entry {
        public String symbol;
        int hashCode = 0;
        public char[] characters;
        public Entry next;

        public Entry(String string, Entry entry) {
            this.symbol = string.intern();
            this.characters = new char[string.length()];
            string.getChars(0, this.characters.length, this.characters, 0);
            this.next = entry;
        }

        public Entry(char[] cArray, int n2, int n3, Entry entry) {
            this.characters = new char[n3];
            System.arraycopy(cArray, n2, this.characters, 0, n3);
            this.symbol = new String(this.characters).intern();
            this.next = entry;
        }
    }
}

